/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFieldChar0;
import edu.jas.ufd.SquarefreeFieldCharP;
import edu.jas.ufd.SquarefreeFiniteFieldCharP;
import edu.jas.ufd.SquarefreeInfiniteAlgebraicFieldCharP;
import edu.jas.ufd.SquarefreeInfiniteFieldCharP;
import edu.jas.ufd.SquarefreeRingChar0;
import org.apache.log4j.Logger;

public class SquarefreeFactory {
    private static final Logger logger = Logger.getLogger(SquarefreeFactory.class);

    protected SquarefreeFactory() {
    }

    public static SquarefreeAbstract<ModInteger> getImplementation(ModIntegerRing fac) {
        return new SquarefreeFiniteFieldCharP<ModInteger>(fac);
    }

    public static SquarefreeAbstract<ModLong> getImplementation(ModLongRing fac) {
        return new SquarefreeFiniteFieldCharP<ModLong>(fac);
    }

    public static SquarefreeAbstract<BigInteger> getImplementation(BigInteger fac) {
        return new SquarefreeRingChar0<BigInteger>(fac);
    }

    public static SquarefreeAbstract<BigRational> getImplementation(BigRational fac) {
        return new SquarefreeFieldChar0<BigRational>(fac);
    }

    public static <C extends GcdRingElem<C>> SquarefreeAbstract<AlgebraicNumber<C>> getImplementation(AlgebraicNumberRing<C> fac) {
        PolyUfdUtil.ensureFieldProperty(fac);
        if (fac.isField()) {
            if (fac.characteristic().signum() == 0) {
                return new SquarefreeFieldChar0<AlgebraicNumber<C>>(fac);
            }
            if (fac.isFinite()) {
                return new SquarefreeFiniteFieldCharP<AlgebraicNumber<C>>(fac);
            }
            return new SquarefreeInfiniteAlgebraicFieldCharP(fac);
        }
        throw new ArithmeticException("eventually no integral domain " + fac.getClass().getName());
    }

    public static <C extends GcdRingElem<C>> SquarefreeAbstract<Quotient<C>> getImplementation(QuotientRing<C> fac) {
        if (fac.characteristic().signum() == 0) {
            return new SquarefreeFieldChar0<Quotient<C>>(fac);
        }
        return new SquarefreeInfiniteFieldCharP(fac);
    }

    public static <C extends GcdRingElem<C>> SquarefreeAbstract<C> getImplementation(GenPolynomialRing<C> fac) {
        return SquarefreeFactory.getImplementationPoly(fac);
    }

    protected static <C extends GcdRingElem<C>> SquarefreeAbstract<C> getImplementationPoly(GenPolynomialRing<C> fac) {
        if (fac.characteristic().signum() == 0) {
            if (fac.coFac.isField()) {
                return new SquarefreeFieldChar0(fac.coFac);
            }
            return new SquarefreeRingChar0(fac.coFac);
        }
        if (fac.coFac.isFinite()) {
            return new SquarefreeFiniteFieldCharP(fac.coFac);
        }
        RingFactory ocfac = fac.coFac;
        SquarefreeFieldCharP saq = null;
        if (ocfac instanceof QuotientRing) {
            QuotientRing qf = (QuotientRing)ocfac;
            saq = new SquarefreeInfiniteFieldCharP(qf);
        } else if (ocfac instanceof AlgebraicNumberRing) {
            AlgebraicNumberRing af = (AlgebraicNumberRing)ocfac;
            saq = new SquarefreeInfiniteAlgebraicFieldCharP(af);
        }
        if (saq == null) {
            throw new IllegalArgumentException("no squarefree factorization " + fac.coFac);
        }
        SquarefreeInfiniteFieldCharP sa = saq;
        return sa;
    }

    public static <C extends GcdRingElem<C>> SquarefreeAbstract<C> getImplementation(RingFactory<C> fac) {
        int t = 0;
        SquarefreeAbstract ufd = null;
        AlgebraicNumberRing afac = null;
        QuotientRing qfac = null;
        GenPolynomialRing pfac = null;
        RingFactory ofac = fac;
        if (ofac instanceof BigInteger) {
            t = 1;
        } else if (ofac instanceof BigRational) {
            t = 2;
        } else if (ofac instanceof ModIntegerRing) {
            t = 3;
        } else if (ofac instanceof ModLongRing) {
            t = 10;
        } else if (ofac instanceof AlgebraicNumberRing) {
            afac = (AlgebraicNumberRing)ofac;
            ofac = afac.ring.coFac;
            t = 4;
        } else if (ofac instanceof QuotientRing) {
            qfac = (QuotientRing)ofac;
            t = 7;
        } else if (ofac instanceof GenPolynomialRing) {
            pfac = (GenPolynomialRing)ofac;
            t = 8;
        } else {
            t = fac.isField() ? 9 : 11;
        }
        if (t == 1) {
            ufd = new SquarefreeRingChar0<C>(fac);
        }
        if (t == 2) {
            ufd = new SquarefreeFieldChar0<C>(fac);
        }
        if (t == 3) {
            ufd = new SquarefreeFiniteFieldCharP<C>(fac);
        }
        if (t == 10) {
            ufd = new SquarefreeFiniteFieldCharP<C>(fac);
        }
        if (t == 4) {
            ufd = SquarefreeFactory.getImplementation(afac);
        }
        if (t == 7) {
            ufd = SquarefreeFactory.getImplementation(qfac);
        }
        if (t == 8) {
            ufd = SquarefreeFactory.getImplementationPoly(pfac);
        }
        if (t == 9) {
            ufd = fac.characteristic().signum() == 0 ? new SquarefreeFieldChar0<C>(fac) : (fac.isFinite() ? new SquarefreeFiniteFieldCharP<C>(fac) : new SquarefreeInfiniteFieldCharP(fac));
        }
        if (t == 11 && fac.characteristic().signum() == 0) {
            ufd = new SquarefreeRingChar0(fac);
        }
        if (ufd == null) {
            throw new IllegalArgumentException("no squarefree factorization implementation for " + fac.getClass().getName());
        }
        logger.debug((Object)("ufd = " + ufd));
        return ufd;
    }
}

