/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Power;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeInfiniteFieldCharP;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SquarefreeQuotModTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    int rl = 3;
    int kl = 1;
    int ll = 3;
    int el = 3;
    float q = 0.25f;
    String[] vars;
    String[] cvars;
    String[] c1vars;
    String[] rvars;
    ModIntegerRing mfac;
    String[] alpha;
    GenPolynomialRing<ModInteger> mpfac;
    GenPolynomial<ModInteger> agen;
    QuotientRing<ModInteger> fac;
    GreatestCommonDivisorAbstract<Quotient<ModInteger>> ufd;
    SquarefreeInfiniteFieldCharP<ModInteger> sqf;
    GenPolynomialRing<Quotient<ModInteger>> dfac;
    GenPolynomial<Quotient<ModInteger>> a;
    GenPolynomial<Quotient<ModInteger>> b;
    GenPolynomial<Quotient<ModInteger>> c;
    GenPolynomial<Quotient<ModInteger>> d;
    GenPolynomial<Quotient<ModInteger>> e;
    GenPolynomialRing<Quotient<ModInteger>> cfac;
    GenPolynomialRing<GenPolynomial<Quotient<ModInteger>>> rfac;
    GenPolynomial<GenPolynomial<Quotient<ModInteger>>> ar;
    GenPolynomial<GenPolynomial<Quotient<ModInteger>>> br;
    GenPolynomial<GenPolynomial<Quotient<ModInteger>>> cr;
    GenPolynomial<GenPolynomial<Quotient<ModInteger>>> dr;
    GenPolynomial<GenPolynomial<Quotient<ModInteger>>> er;

    public static void main(String[] args) {
        TestRunner.run((Test)SquarefreeQuotModTest.suite());
        ComputerThreads.terminate();
    }

    public SquarefreeQuotModTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SquarefreeQuotModTest.class);
        return suite;
    }

    protected void setUp() {
        this.vars = ExpVector.STDVARS(this.rl);
        this.cvars = ExpVector.STDVARS(this.rl - 1);
        this.c1vars = new String[]{this.cvars[0]};
        this.rvars = new String[]{this.vars[this.rl - 1]};
        this.mfac = new ModIntegerRing(7L);
        this.alpha = new String[]{"u"};
        this.mpfac = new GenPolynomialRing<ModInteger>(this.mfac, 1, this.to, this.alpha);
        this.fac = new QuotientRing<ModInteger>(this.mpfac);
        this.ufd = GCDFactory.getProxy(this.fac);
        this.sqf = new SquarefreeInfiniteFieldCharP(this.fac);
        SquarefreeAbstract<Quotient<ModInteger>> sqff = SquarefreeFactory.getImplementation(this.fac);
        SquarefreeQuotModTest.assertEquals((String)"sqf == sqff ", this.sqf.getClass(), sqff.getClass());
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
    }

    public void testBaseSquarefree() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl + 1, this.ll, this.el + 1, this.q);
        this.b = this.dfac.random(this.kl + 1, this.ll, this.el + 1, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((Quotient<ModInteger>)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.c = this.a.multiply((Quotient<ModInteger>)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.baseSquarefreePart(this.c);
        this.d = this.sqf.baseSquarefreePart(this.d);
        SquarefreeQuotModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        SquarefreeQuotModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeQuotModTest.assertTrue((String)("squarefree(abc) | squarefree(aabbbc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testBaseSquarefreeFactors() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl + 1, this.ll, this.el + 2, this.q);
        this.b = this.dfac.random(this.kl + 1, this.ll, this.el + 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el + 1, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((Quotient<ModInteger>)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        SortedMap sfactors = this.sqf.baseSquarefreeFactors(this.d);
        SquarefreeQuotModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sfactors));
    }

    public void testRecursiveSquarefree() {
        this.cfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<Quotient<ModInteger>>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 2, this.q);
        this.br = this.rfac.random(this.kl, 3, 2, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<Quotient<ModInteger>>)this.ar).multiply(this.br).multiply(this.br);
        this.cr = this.ar.multiply((GenPolynomial<Quotient<ModInteger>>)this.br);
        this.cr = this.sqf.recursiveUnivariateSquarefreePart(this.cr);
        this.dr = this.sqf.recursiveUnivariateSquarefreePart(this.dr);
        SquarefreeQuotModTest.assertTrue((String)("isSquarefree(cr) " + this.cr), (boolean)this.sqf.isRecursiveSquarefree(this.cr));
        SquarefreeQuotModTest.assertTrue((String)("isSquarefree(dr) " + this.dr), (boolean)this.sqf.isRecursiveSquarefree(this.dr));
        this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
        SquarefreeQuotModTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.er), (boolean)this.er.isZERO());
    }

    public void testRecursiveSquarefreeFactors() {
        this.cfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<Quotient<ModInteger>>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 2, this.q);
        this.br = this.rfac.random(this.kl, 3, 2, this.q);
        this.cr = this.rfac.random(this.kl, 3, 2, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<Quotient<ModInteger>>)this.cr).multiply(this.br).multiply(this.br);
        SortedMap sfactors = this.sqf.recursiveUnivariateSquarefreeFactors(this.dr);
        SquarefreeQuotModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isRecursiveFactorization(this.dr, sfactors));
    }

    public void testSquarefree() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, this.ll, 2, this.q);
        this.b = this.dfac.random(this.kl, this.ll - 1, 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((Quotient<ModInteger>)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.c);
        this.c = this.a.multiply((Quotient<ModInteger>)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.squarefreePart(this.c);
        this.d = this.sqf.squarefreePart(this.d);
        SquarefreeQuotModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        SquarefreeQuotModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeQuotModTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testSquarefreeFactors() {
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 2, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((Quotient<ModInteger>)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        SortedMap sfactors = this.sqf.squarefreeFactors((ModInteger)((Object)this.d));
        SquarefreeQuotModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sfactors));
    }

    public void testBaseSquarefreeCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl + 1, this.ll + 1, this.el + 2, this.q).monic();
        this.b = this.dfac.random(this.kl, this.ll + 1, this.el + 2, this.q).monic();
        this.c = this.dfac.random(this.kl + 1, this.ll, this.el, this.q).monic();
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.a.isConstant() || this.b.isConstant()) {
            return;
        }
        this.d = this.a.multiply((Quotient<ModInteger>)((Object)this.a)).multiply(Power.positivePower(this.b, p)).multiply(this.c);
        this.c = this.a.multiply((Quotient<ModInteger>)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.baseSquarefreePart(this.c);
        this.d = this.sqf.baseSquarefreePart(this.d);
        SquarefreeQuotModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        SquarefreeQuotModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeQuotModTest.assertTrue((String)("squarefree(abc) | squarefree(aab^pc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testBaseSquarefreeFactorsCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll + 1, this.el + 3, this.q).monic();
        this.b = this.dfac.random(this.kl, this.ll + 1, this.el + 3, this.q).monic();
        this.c = this.dfac.random(this.kl, this.ll, this.el + 2, this.q).monic();
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.a.isConstant() || this.b.isConstant()) {
            return;
        }
        this.d = this.a.multiply((Quotient<ModInteger>)((Object)this.a)).multiply(Power.positivePower(this.b, p)).multiply(this.c);
        SortedMap sfactors = this.sqf.baseSquarefreeFactors(this.d);
        SquarefreeQuotModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sfactors));
    }

    public void testRecursiveSquarefreeCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.cfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<Quotient<ModInteger>>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 3, this.q);
        this.br = this.rfac.random(this.kl, 3, 2, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.ar = PolyUtil.monic(this.ar);
        this.br = PolyUtil.monic(this.br);
        this.cr = PolyUtil.monic(this.cr);
        this.dr = this.ar.multiply((GenPolynomial<Quotient<ModInteger>>)Power.positivePower(this.br, p)).multiply(this.cr);
        this.cr = this.ar.multiply((GenPolynomial<Quotient<ModInteger>>)this.br).multiply(this.cr);
        this.cr = this.sqf.recursiveUnivariateSquarefreePart(this.cr);
        this.dr = this.sqf.recursiveUnivariateSquarefreePart(this.dr);
        SquarefreeQuotModTest.assertTrue((String)("isSquarefree(cr) " + this.cr), (boolean)this.sqf.isRecursiveSquarefree(this.cr));
        SquarefreeQuotModTest.assertTrue((String)("isSquarefree(dr) " + this.dr), (boolean)this.sqf.isRecursiveSquarefree(this.dr));
        this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
        SquarefreeQuotModTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.er), (boolean)this.er.isZERO());
    }

    public void testRecursiveSquarefreeFactorsCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.cfac = new GenPolynomialRing<ModInteger>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<Quotient<ModInteger>>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 3, this.q);
        this.br = this.rfac.random(this.kl, 3, 2, this.q);
        this.cr = this.rfac.random(this.kl, 3, 2, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.ar = PolyUtil.monic(this.ar);
        this.br = PolyUtil.monic(this.br);
        this.cr = PolyUtil.monic(this.cr);
        this.dr = this.ar.multiply((GenPolynomial<Quotient<ModInteger>>)Power.positivePower(this.br, p)).multiply(this.cr);
        SortedMap sfactors = this.sqf.recursiveUnivariateSquarefreeFactors(this.dr);
        SquarefreeQuotModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isRecursiveFactorization(this.dr, sfactors));
    }

    public void testSquarefreeCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, this.ll, 3, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, 3, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.b.isConstant()) {
            return;
        }
        this.d = this.a.multiply((Quotient<ModInteger>)((Object)this.a)).multiply(Power.positivePower(this.b, p)).multiply(this.c);
        this.c = this.a.multiply((Quotient<ModInteger>)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.squarefreePart(this.c);
        this.d = this.sqf.squarefreePart(this.d);
        SquarefreeQuotModTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        SquarefreeQuotModTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeQuotModTest.assertTrue((String)("squarefree(abc) | squarefree(aab^pc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testSquarefreeFactorsCharRoot() {
        long p = this.fac.characteristic().longValue();
        this.dfac = new GenPolynomialRing<ModInteger>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, this.ll, 3, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, 3, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.b.isConstant()) {
            return;
        }
        this.d = this.a.multiply((Quotient<ModInteger>)((Object)this.a)).multiply(Power.positivePower(this.b, p)).multiply(this.c);
        SortedMap sfactors = this.sqf.squarefreeFactors((ModInteger)((Object)this.d));
        SquarefreeQuotModTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sfactors));
    }
}

