/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeFieldChar0;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SquarefreeRatTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    int rl = 3;
    int kl = 3;
    int ll = 4;
    int el = 3;
    float q = 0.25f;
    String[] vars;
    String[] cvars;
    String[] c1vars;
    String[] rvars;
    BigRational fac;
    GreatestCommonDivisorAbstract<BigRational> ufd;
    SquarefreeFieldChar0<BigRational> sqf;
    GenPolynomialRing<BigRational> dfac;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    GenPolynomialRing<BigRational> cfac;
    GenPolynomialRing<GenPolynomial<BigRational>> rfac;
    GenPolynomial<GenPolynomial<BigRational>> ar;
    GenPolynomial<GenPolynomial<BigRational>> br;
    GenPolynomial<GenPolynomial<BigRational>> cr;
    GenPolynomial<GenPolynomial<BigRational>> dr;
    GenPolynomial<GenPolynomial<BigRational>> er;

    public static void main(String[] args) {
        TestRunner.run((Test)SquarefreeRatTest.suite());
        ComputerThreads.terminate();
    }

    public SquarefreeRatTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SquarefreeRatTest.class);
        return suite;
    }

    protected void setUp() {
        this.vars = ExpVector.STDVARS(this.rl);
        this.cvars = ExpVector.STDVARS(this.rl - 1);
        this.c1vars = new String[]{this.cvars[0]};
        this.rvars = new String[]{this.vars[this.rl - 1]};
        this.fac = new BigRational(1L);
        this.ufd = GCDFactory.getProxy(this.fac);
        this.sqf = new SquarefreeFieldChar0<BigRational>(this.fac);
        SquarefreeAbstract<BigRational> sqff = SquarefreeFactory.getImplementation(this.fac);
        SquarefreeRatTest.assertEquals((String)"sqf == sqff ", this.sqf.getClass(), sqff.getClass());
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.er = null;
        this.dr = null;
        this.cr = null;
        this.br = null;
        this.ar = null;
    }

    public void testBaseSquarefree() {
        this.dfac = new GenPolynomialRing<BigRational>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        this.b = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((BigRational)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        this.c = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.baseSquarefreePart(this.c);
        this.d = this.sqf.baseSquarefreePart(this.d);
        SquarefreeRatTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        SquarefreeRatTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeRatTest.assertTrue((String)("squarefree(abc) | squarefree(aabbbc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testBaseSquarefreeFactors() {
        this.dfac = new GenPolynomialRing<BigRational>(this.fac, 1, this.to, this.rvars);
        this.a = this.dfac.random(this.kl, this.ll, this.el + 3, this.q);
        this.b = this.dfac.random(this.kl, this.ll, this.el + 3, this.q);
        this.c = this.dfac.random(this.kl, this.ll, this.el + 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((BigRational)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        SortedMap sfactors = this.sqf.baseSquarefreeFactors(this.d);
        SquarefreeRatTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sfactors));
    }

    public void testRecursiveSquarefree() {
        this.cfac = new GenPolynomialRing<BigRational>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<BigRational>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.br = this.rfac.random(this.kl, this.ll, this.el, this.q);
        this.cr = this.rfac.random(this.kl, this.ll, this.el, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<BigRational>)this.ar).multiply(this.br).multiply(this.br);
        this.cr = this.ar.multiply((GenPolynomial<BigRational>)this.br);
        this.cr = this.sqf.recursiveUnivariateSquarefreePart(this.cr);
        this.dr = this.sqf.recursiveUnivariateSquarefreePart(this.dr);
        SquarefreeRatTest.assertTrue((String)("isSquarefree(cr) " + this.cr), (boolean)this.sqf.isRecursiveSquarefree(this.cr));
        SquarefreeRatTest.assertTrue((String)("isSquarefree(dr) " + this.dr), (boolean)this.sqf.isRecursiveSquarefree(this.dr));
        this.er = PolyUtil.recursivePseudoRemainder(this.dr, this.cr);
        SquarefreeRatTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.er), (boolean)this.er.isZERO());
    }

    public void testRecursiveSquarefreeFactors() {
        this.cfac = new GenPolynomialRing<BigRational>(this.fac, 1, this.to, this.c1vars);
        this.rfac = new GenPolynomialRing<BigRational>(this.cfac, 1, this.to, this.rvars);
        this.ar = this.rfac.random(this.kl, 3, 2, this.q);
        this.br = this.rfac.random(this.kl, 3, 2, this.q);
        this.cr = this.rfac.random(this.kl, 3, 2, this.q);
        if (this.ar.isZERO() || this.br.isZERO() || this.cr.isZERO()) {
            return;
        }
        this.dr = this.ar.multiply((GenPolynomial<BigRational>)this.cr).multiply(this.br).multiply(this.br);
        SortedMap sfactors = this.sqf.recursiveUnivariateSquarefreeFactors(this.dr);
        SquarefreeRatTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isRecursiveFactorization(this.dr, sfactors));
    }

    public void testSquarefree() {
        this.dfac = new GenPolynomialRing<BigRational>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, this.ll, 2, this.q);
        this.b = this.dfac.random(this.kl, this.ll, 2, this.q);
        this.c = this.dfac.random(this.kl, this.ll, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((BigRational)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.c);
        this.c = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        this.c = this.sqf.squarefreePart(this.c);
        this.d = this.sqf.squarefreePart(this.d);
        SquarefreeRatTest.assertTrue((String)("isSquarefree(d) " + this.d), (boolean)this.sqf.isSquarefree(this.d));
        SquarefreeRatTest.assertTrue((String)("isSquarefree(c) " + this.c), (boolean)this.sqf.isSquarefree(this.c));
        this.e = PolyUtil.basePseudoRemainder(this.d, this.c);
        SquarefreeRatTest.assertTrue((String)("squarefree(abc) | squarefree(aabbc) " + this.e), (boolean)this.e.isZERO());
    }

    public void testSquarefreeFactors() {
        this.dfac = new GenPolynomialRing<BigRational>(this.fac, this.rl, this.to, this.vars);
        this.a = this.dfac.random(this.kl, 3, 2, this.q);
        this.b = this.dfac.random(this.kl, 3, 2, this.q);
        this.c = this.dfac.random(this.kl, 3, 2, this.q);
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO()) {
            return;
        }
        this.d = this.a.multiply((BigRational)((Object)this.a)).multiply(this.b).multiply(this.b).multiply(this.b).multiply(this.c);
        SortedMap sfactors = this.sqf.squarefreeFactors((BigRational)((Object)this.d));
        SquarefreeRatTest.assertTrue((String)"isFactorization(d,sfactors) ", (boolean)this.sqf.isFactorization(this.d, sfactors));
    }
}

