/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeFieldChar0;
import edu.jas.ufd.SquarefreeFiniteFieldCharP;
import edu.jas.ufd.SquarefreeInfiniteFieldCharP;
import edu.jas.ufd.SquarefreeRingChar0;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SquarefreeTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)SquarefreeTest.suite());
    }

    public SquarefreeTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SquarefreeTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testFactorySpecific() {
        ModIntegerRing mi = new ModIntegerRing(19L, true);
        SquarefreeAbstract<ModInteger> sqfm = SquarefreeFactory.getImplementation(mi);
        SquarefreeTest.assertTrue((String)("sqf != Modular " + sqfm), (boolean)(sqfm instanceof SquarefreeFiniteFieldCharP));
        ModLongRing ml = new ModLongRing(19L, true);
        SquarefreeAbstract<ModLong> sqfml = SquarefreeFactory.getImplementation(ml);
        SquarefreeTest.assertTrue((String)("sqf != Modular " + sqfml), (boolean)(sqfml instanceof SquarefreeFiniteFieldCharP));
        BigInteger bi = new BigInteger(1L);
        SquarefreeAbstract<BigInteger> sqfi = SquarefreeFactory.getImplementation(bi);
        SquarefreeTest.assertTrue((String)("sqf != Integer " + sqfi), (boolean)(sqfi instanceof SquarefreeRingChar0));
        BigRational br = new BigRational(1L);
        SquarefreeAbstract<BigRational> sqfr = SquarefreeFactory.getImplementation(br);
        SquarefreeTest.assertTrue((String)("sqf != Rational " + sqfr), (boolean)(sqfr instanceof SquarefreeFieldChar0));
        GenPolynomialRing<ModInteger> pmfac = new GenPolynomialRing<ModInteger>(mi, 1);
        GenPolynomial<ModInteger> pm = pmfac.univariate(0);
        AlgebraicNumberRing<ModInteger> am = new AlgebraicNumberRing<ModInteger>(pm, true);
        SquarefreeAbstract<AlgebraicNumber<ModInteger>> sqfam = SquarefreeFactory.getImplementation(am);
        SquarefreeTest.assertTrue((String)("sqf != AlgebraicNumber<ModInteger> " + sqfam), (boolean)(sqfam instanceof SquarefreeFiniteFieldCharP));
        GenPolynomialRing<BigRational> prfac = new GenPolynomialRing<BigRational>(br, 1);
        GenPolynomial<BigRational> pr = prfac.univariate(0);
        AlgebraicNumberRing<BigRational> ar = new AlgebraicNumberRing<BigRational>(pr, true);
        SquarefreeAbstract<AlgebraicNumber<BigRational>> sqfar = SquarefreeFactory.getImplementation(ar);
        SquarefreeTest.assertTrue((String)("sqf != AlgebraicNumber<BigRational> " + sqfar), (boolean)(sqfar instanceof SquarefreeFieldChar0));
        prfac = new GenPolynomialRing<BigRational>(br, 2);
        QuotientRing<BigRational> qrfac = new QuotientRing<BigRational>(prfac);
        SquarefreeAbstract<Quotient<BigRational>> sqfqr = SquarefreeFactory.getImplementation(qrfac);
        SquarefreeTest.assertTrue((String)("sqf != Quotient<BigRational> " + sqfqr), (boolean)(sqfqr instanceof SquarefreeFieldChar0));
        pmfac = new GenPolynomialRing<ModInteger>(mi, 1);
        QuotientRing<ModInteger> qmfac = new QuotientRing<ModInteger>(pmfac);
        SquarefreeAbstract<Quotient<ModInteger>> sqfqm = SquarefreeFactory.getImplementation(qmfac);
        SquarefreeTest.assertTrue((String)("sqf != Quotient<ModInteger> " + sqfqm), (boolean)(sqfqm instanceof SquarefreeInfiniteFieldCharP));
    }

    public void testFactoryGeneric() {
        ModIntegerRing mi = new ModIntegerRing(19L, true);
        SquarefreeAbstract<ModInteger> sqfm = SquarefreeFactory.getImplementation(mi);
        SquarefreeTest.assertTrue((String)("sqf != Modular " + sqfm), (boolean)(sqfm instanceof SquarefreeFiniteFieldCharP));
        ModLongRing ml = new ModLongRing(19L, true);
        SquarefreeAbstract<ModLong> sqfml = SquarefreeFactory.getImplementation(ml);
        SquarefreeTest.assertTrue((String)("sqf != Modular " + sqfml), (boolean)(sqfml instanceof SquarefreeFiniteFieldCharP));
        BigInteger bi = new BigInteger(1L);
        SquarefreeAbstract<BigInteger> sqfi = SquarefreeFactory.getImplementation(bi);
        SquarefreeTest.assertTrue((String)("sqf != Integer " + sqfi), (boolean)(sqfi instanceof SquarefreeRingChar0));
        BigRational br = new BigRational(1L);
        SquarefreeAbstract<BigRational> sqfr = SquarefreeFactory.getImplementation(br);
        SquarefreeTest.assertTrue((String)("sqf != Rational " + sqfr), (boolean)(sqfr instanceof SquarefreeFieldChar0));
        GenPolynomialRing<ModInteger> pmfac = new GenPolynomialRing<ModInteger>(mi, 1);
        GenPolynomial<ModInteger> pm = pmfac.univariate(0);
        AlgebraicNumberRing<ModInteger> am = new AlgebraicNumberRing<ModInteger>(pm, true);
        SquarefreeAbstract<ModInteger> sqfam = SquarefreeFactory.getImplementation(am);
        SquarefreeTest.assertTrue((String)("sqf != AlgebraicNumber<ModInteger> " + sqfam), (boolean)(sqfam instanceof SquarefreeFiniteFieldCharP));
        GenPolynomialRing<BigRational> prfac = new GenPolynomialRing<BigRational>(br, 1);
        GenPolynomial<BigRational> pr = prfac.univariate(0);
        AlgebraicNumberRing<BigRational> ar = new AlgebraicNumberRing<BigRational>(pr, true);
        SquarefreeAbstract<BigRational> sqfar = SquarefreeFactory.getImplementation(ar);
        SquarefreeTest.assertTrue((String)("sqf != AlgebraicNumber<BigRational> " + sqfar), (boolean)(sqfar instanceof SquarefreeFieldChar0));
        prfac = new GenPolynomialRing<BigRational>(br, 2);
        QuotientRing<BigRational> qrfac = new QuotientRing<BigRational>(prfac);
        SquarefreeAbstract<BigRational> sqfqr = SquarefreeFactory.getImplementation(qrfac);
        SquarefreeTest.assertTrue((String)("sqf != Quotient<BigRational> " + sqfqr), (boolean)(sqfqr instanceof SquarefreeFieldChar0));
        pmfac = new GenPolynomialRing<ModInteger>(mi, 1);
        QuotientRing<ModInteger> qmfac = new QuotientRing<ModInteger>(pmfac);
        SquarefreeAbstract<ModInteger> sqfqm = SquarefreeFactory.getImplementation(qmfac);
        SquarefreeTest.assertTrue((String)("sqf != Quotient<ModInteger> " + sqfqm), (boolean)(sqfqm instanceof SquarefreeInfiniteFieldCharP));
    }
}

