/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DHTTransport;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;

class DHTBroadcaster<K>
extends Thread {
    private static final Logger logger = Logger.getLogger(DHTBroadcaster.class);
    private final SocketChannel channel;
    private final List<DHTBroadcaster<K>> bcaster;
    private final SortedMap<K, DHTTransport> theList;

    public DHTBroadcaster(SocketChannel s, List<DHTBroadcaster<K>> bc, SortedMap<K, DHTTransport> sm) {
        this.channel = s;
        this.bcaster = bc;
        this.theList = sm;
    }

    public void closeChannel() {
        this.channel.close();
    }

    public void sendChannel(DHTTransport tc) throws IOException {
        this.channel.send(tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void broadcast(DHTTransport o) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("broadcast = " + o));
        }
        DHTTransport tc = null;
        if (o == null) {
            return;
        }
        tc = o;
        Object key = null;
        Object object = this.theList;
        synchronized (object) {
            try {
                key = tc.key();
                this.theList.put(key, tc);
            }
            catch (IOException e) {
                logger.warn((Object)("IO exception: tc.key() not ok " + tc));
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)("CNF exception: tc.key() not ok " + tc));
                e.printStackTrace();
            }
            catch (Exception e) {
                logger.warn((Object)("exception:tc.key() not ok " + tc));
                e.printStackTrace();
            }
        }
        logger.info((Object)("sending key=" + key + " to " + this.bcaster.size() + " nodes"));
        object = this.bcaster;
        synchronized (object) {
            Iterator<DHTBroadcaster<K>> it = this.bcaster.iterator();
            while (true) {
                if (!it.hasNext()) {
                    return;
                }
                DHTBroadcaster<K> br = it.next();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("bcasting to " + br));
                    }
                    br.sendChannel(tc);
                    continue;
                }
                catch (IOException e) {
                    logger.info((Object)("bcaster, exception " + e));
                    try {
                        br.closeChannel();
                        while (br.isAlive()) {
                            br.interrupt();
                            br.join(100L);
                        }
                    }
                    catch (InterruptedException w) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (Exception e) {
                    logger.info((Object)("bcaster, exception " + e));
                    continue;
                }
                it.remove();
                logger.debug((Object)("bcaster.remove() " + br));
            }
        }
    }

    @Override
    public void run() {
        boolean goon = true;
        while (goon) {
            try {
                logger.debug((Object)"trying to receive");
                Object o = this.channel.receive();
                if (this.isInterrupted()) break;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("received = " + o));
                }
                if (!(o instanceof DHTTransport)) {
                    logger.warn((Object)("swallowed: " + o));
                    continue;
                }
                DHTTransport tc = (DHTTransport)o;
                this.broadcast(tc);
                if (!this.isInterrupted()) continue;
                goon = false;
            }
            catch (IOException e) {
                goon = false;
                logger.info((Object)("receive, IO exception " + e));
            }
            catch (ClassNotFoundException e) {
                goon = false;
                logger.info((Object)("receive, CNF exception " + e));
                e.printStackTrace();
            }
            catch (Exception e) {
                goon = false;
                logger.info((Object)("receive, exception " + e));
                e.printStackTrace();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DHTBroadcaster terminated " + this));
        }
        this.channel.close();
    }

    @Override
    public String toString() {
        return "DHTBroadcaster(" + this.channel + "," + this.bcaster.size() + ")";
    }
}

