/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DHTTransport;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.SortedMap;
import org.apache.log4j.Logger;

class DHTListener<K, V>
extends Thread {
    private static final Logger logger = Logger.getLogger(DHTListener.class);
    private final SocketChannel channel;
    private final SortedMap<K, V> theList;
    private boolean goon;

    DHTListener(SocketChannel s, SortedMap<K, V> list) {
        this.channel = s;
        this.theList = list;
    }

    void setDone() {
        this.goon = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.goon = true;
        while (this.goon) {
            DHTTransport tc = null;
            Object o = null;
            try {
                Object key;
                o = this.channel.receive();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("receive(" + o + ")"));
                }
                if (this.isInterrupted()) {
                    this.goon = false;
                    break;
                }
                if (o == null) {
                    this.goon = false;
                    break;
                }
                if (!(o instanceof DHTTransport) || (key = (tc = (DHTTransport)o).key()) == null) continue;
                logger.info((Object)("receive, put(key=" + key + ")"));
                Object val = tc.value();
                SortedMap<K, V> sortedMap = this.theList;
                synchronized (sortedMap) {
                    this.theList.put(key, val);
                    this.theList.notifyAll();
                }
            }
            catch (IOException e) {
                this.goon = false;
                logger.info((Object)("receive, IO exception " + e));
            }
            catch (ClassNotFoundException e) {
                this.goon = false;
                logger.info((Object)("receive, CNF exception " + e));
                e.printStackTrace();
            }
            catch (Exception e) {
                this.goon = false;
                logger.info((Object)("receive, exception " + e));
                e.printStackTrace();
            }
        }
    }
}

