/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.DHTBroadcaster;
import edu.jas.util.DHTTransport;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DistHashTableServer<K>
extends Thread {
    private static final Logger logger = Logger.getLogger(DistHashTableServer.class);
    public static final int DEFAULT_PORT = 9009;
    protected final ChannelFactory cf;
    protected List<DHTBroadcaster<K>> servers;
    private boolean goon = true;
    private Thread mythread = null;
    protected final SortedMap<K, DHTTransport> theList;
    private long etime;
    private long dtime;
    private long ertime;
    private long drtime;

    public DistHashTableServer() {
        this(9009);
    }

    public DistHashTableServer(int port) {
        this(new ChannelFactory(port));
    }

    public DistHashTableServer(ChannelFactory cf) {
        this.cf = cf;
        cf.init();
        this.servers = new ArrayList<DHTBroadcaster<K>>();
        this.theList = new TreeMap<K, DHTTransport>();
        this.etime = DHTTransport.etime;
        this.dtime = DHTTransport.dtime;
        this.ertime = DHTTransport.ertime;
        this.drtime = DHTTransport.drtime;
    }

    public static void main(String[] args) {
        int port = 9009;
        if (args.length < 1) {
            System.out.println("Usage: DistHashTableServer <port>");
        } else {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        new DistHashTableServer(port).run();
    }

    public void init() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SocketChannel channel = null;
        DHTBroadcaster<K> s = null;
        this.mythread = Thread.currentThread();
        while (this.goon) {
            try {
                channel = this.cf.getChannel();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("dls channel = " + channel));
                }
                if (this.mythread.isInterrupted()) {
                    this.goon = false;
                    continue;
                }
                s = new DHTBroadcaster<K>(channel, this.servers, this.theList);
                int ls = 0;
                Object object = this.servers;
                synchronized (object) {
                    if (this.goon) {
                        this.servers.add(s);
                        ls = this.theList.size();
                        s.start();
                    }
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("server " + s + " started " + s.isAlive()));
                }
                if (ls <= 0) continue;
                object = this.theList;
                synchronized (object) {
                    Iterator<Map.Entry<K, DHTTransport>> it = this.theList.entrySet().iterator();
                    int i = 0;
                    while (i < ls) {
                        Map.Entry<K, DHTTransport> e = it.next();
                        K n = e.getKey();
                        DHTTransport tc = e.getValue();
                        try {
                            s.sendChannel(tc);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
            }
            catch (InterruptedException end) {
                this.goon = false;
                Thread.currentThread().interrupt();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("listserver " + this + " terminated"));
        }
    }

    /*
     * Exception decompiling
     */
    public void terminate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<DHTBroadcaster<K>> list = this.servers;
        synchronized (list) {
            return this.servers.size();
        }
    }

    @Override
    public String toString() {
        return "DHTServer(" + this.servers.size() + ", " + this.cf + ", " + super.toString() + ")";
    }
}

