/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DistHashTable;
import edu.jas.util.DistHashTableServer;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class DistHashTableTest
extends TestCase {
    private static final String host = "localhost";
    private DistHashTable<Integer, Integer> l1;
    private DistHashTable<Integer, Integer> l2;
    private DistHashTable<Integer, Integer> l3;
    private DistHashTableServer<Integer> dls;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)DistHashTableTest.suite());
    }

    public DistHashTableTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(DistHashTableTest.class);
        return suite;
    }

    protected void setUp() {
        this.dls = new DistHashTableServer();
        this.dls.init();
    }

    protected void tearDown() {
        this.dls.terminate();
        this.dls = null;
        if (this.l1 != null) {
            this.l1.terminate();
        }
        if (this.l2 != null) {
            this.l2.terminate();
        }
        if (this.l3 != null) {
            this.l3.terminate();
        }
        this.l3 = null;
        this.l2 = null;
        this.l1 = null;
    }

    public void testDistHashTable0() {
    }

    public void testDistHashTable1() {
        this.l1 = new DistHashTable(host);
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
    }

    public void testDistHashTable2() {
        this.l1 = new DistHashTable(host);
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        this.l1.putWait(new Integer(1), new Integer(1));
        DistHashTableTest.assertFalse((String)"l1!=empty", (boolean)this.l1.isEmpty());
        DistHashTableTest.assertTrue((String)"#l1==1", (this.l1.size() == 1 ? 1 : 0) != 0);
        this.l1.putWait(new Integer(2), new Integer(2));
        DistHashTableTest.assertTrue((String)"#l1==2", (this.l1.size() == 2 ? 1 : 0) != 0);
        this.l1.putWait(new Integer(3), new Integer(3));
        DistHashTableTest.assertTrue((String)"#l1==3", (this.l1.size() == 3 ? 1 : 0) != 0);
        Iterator<Integer> it = null;
        it = this.l1.iterator();
        int i = 0;
        while (it.hasNext()) {
            Integer k = it.next();
            Integer o = this.l1.get(k);
            Integer x = new Integer(++i);
            DistHashTableTest.assertEquals((String)"l1(i)==v(i)", (Object)x, (Object)o);
            DistHashTableTest.assertEquals((String)"l1(i)==k(i)", (Object)x, (Object)k);
        }
        this.l1.clear();
        DistHashTableTest.assertTrue((String)"#l1==0", (this.l1.size() == 0 ? 1 : 0) != 0);
    }

    public void testDistHashTable3() {
        this.l2 = new DistHashTable(host);
        DistHashTableTest.assertTrue((String)"l2==empty", (boolean)this.l2.isEmpty());
        this.l1 = new DistHashTable(host);
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        int i = 0;
        int loops = 10;
        while (i < loops) {
            Integer x = new Integer(++i);
            this.l1.putWait(x, x);
            DistHashTableTest.assertTrue((String)"#l1==i", (this.l1.size() == i ? 1 : 0) != 0);
        }
        DistHashTableTest.assertTrue((String)("#l1==" + loops), (this.l1.size() == loops ? 1 : 0) != 0);
        while (this.l2.size() < loops) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException x) {
                // empty catch block
            }
        }
        DistHashTableTest.assertTrue((String)("#l2==" + loops), (this.l2.size() == loops ? 1 : 0) != 0);
        Iterator<Integer> it = null;
        it = this.l2.iterator();
        i = 0;
        while (it.hasNext()) {
            Integer k = it.next();
            Integer o = this.l2.get(k);
            Integer x = new Integer(++i);
            DistHashTableTest.assertEquals((String)"l2(i)==k(i)", (Object)x, (Object)k);
            DistHashTableTest.assertEquals((String)"l2(i)==v(i)", (Object)x, (Object)o);
        }
    }

    public void testDistHashTable4() {
        this.l1 = new DistHashTable(host);
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        this.l2 = new DistHashTable(host);
        DistHashTableTest.assertTrue((String)"l2==empty", (boolean)this.l2.isEmpty());
        this.l3 = new DistHashTable(host);
        DistHashTableTest.assertTrue((String)"l3==empty", (boolean)this.l3.isEmpty());
        int i = 0;
        int loops = 10;
        while (i < loops) {
            Integer x = new Integer(++i);
            this.l3.putWait(x, x);
            DistHashTableTest.assertTrue((String)"#l3==i", (this.l3.size() == i ? 1 : 0) != 0);
        }
        DistHashTableTest.assertTrue((String)("#l3==" + loops), (this.l3.size() == loops ? 1 : 0) != 0);
        while (this.l2.size() < loops || this.l1.size() < loops - 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException x) {
                // empty catch block
            }
        }
        DistHashTableTest.assertTrue((String)("#l2==" + loops), (this.l2.size() == loops ? 1 : 0) != 0);
        DistHashTableTest.assertTrue((String)("#l1==" + loops), (this.l1.size() == loops ? 1 : 0) != 0);
        Iterator<Integer> it = null;
        it = this.l2.iterator();
        Iterator<Integer> it3 = null;
        it3 = this.l1.iterator();
        i = 0;
        while (it.hasNext() && it3.hasNext()) {
            Integer k1 = it.next();
            Integer k2 = it3.next();
            Integer v1 = this.l2.get(k1);
            Integer v2 = this.l1.get(k2);
            Integer x = new Integer(++i);
            DistHashTableTest.assertEquals((String)"l2(i)==k(i)", (Object)x, (Object)k1);
            DistHashTableTest.assertEquals((String)"l1(i)==k(i)", (Object)x, (Object)k2);
            DistHashTableTest.assertEquals((String)"l2(i)==v(i)", (Object)x, (Object)v1);
            DistHashTableTest.assertEquals((String)"l1(i)==v(i)", (Object)x, (Object)v2);
        }
    }

    public void testDistHashTable5() {
        this.l1 = new DistHashTable(host);
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        int i = 0;
        int loops = 10;
        while (i < loops) {
            Integer x = new Integer(++i);
            this.l1.putWait(x, x);
            DistHashTableTest.assertTrue((String)"#l1==i", (this.l1.size() == i ? 1 : 0) != 0);
        }
        DistHashTableTest.assertTrue((String)("#l1==" + loops), (this.l1.size() == loops ? 1 : 0) != 0);
        this.l2 = new DistHashTable(host);
        while (this.l2.size() < loops) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException x) {
                // empty catch block
            }
        }
        Iterator<Integer> it = null;
        it = this.l2.iterator();
        i = 0;
        while (it.hasNext()) {
            Integer k = it.next();
            Integer v = this.l2.get(k);
            Integer x = new Integer(++i);
            DistHashTableTest.assertEquals((String)"l2(i)==k(i)", (Object)x, (Object)k);
            DistHashTableTest.assertEquals((String)"l2(i)==v(i)", (Object)x, (Object)v);
        }
        DistHashTableTest.assertTrue((String)("#l2==" + loops), (this.l2.size() == loops ? 1 : 0) != 0);
    }

    public void testDistHashTable6() {
        this.l1 = new DistHashTable(host);
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        int i = 0;
        int loops = 10;
        while (i < loops) {
            Integer x = new Integer(++i);
            this.l1.putWait(x, x);
            DistHashTableTest.assertTrue((String)"#l1==i", (this.l1.size() == i ? 1 : 0) != 0);
        }
        DistHashTableTest.assertTrue((String)("#l1==" + loops), (this.l1.size() == loops ? 1 : 0) != 0);
        this.l2 = new DistHashTable(host);
        Iterator<Integer> it = null;
        it = this.l1.iterator();
        i = 0;
        while (it.hasNext()) {
            Integer k = it.next();
            Integer v = this.l2.getWait(k);
            Integer x = new Integer(++i);
            DistHashTableTest.assertEquals((String)"l1(i)==k(i)", (Object)x, (Object)k);
            DistHashTableTest.assertEquals((String)"l2(i)==v(i)", (Object)x, (Object)v);
        }
        DistHashTableTest.assertTrue((String)("#l2==" + loops), (this.l2.size() == loops ? 1 : 0) != 0);
    }
}

