/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DistThreadPool;
import edu.jas.util.ExecutableChannels;
import edu.jas.util.ShutdownRequest;
import java.io.IOException;
import org.apache.log4j.Logger;

class DistPoolThread
extends Thread {
    final DistThreadPool pool;
    final ExecutableChannels ec;
    final int myId;
    private static final Logger logger = Logger.getLogger(DistPoolThread.class);
    private final boolean debug = logger.isInfoEnabled();
    boolean working = false;

    public DistPoolThread(DistThreadPool pool, ExecutableChannels ec, int i) {
        this.pool = pool;
        this.ec = ec;
        this.myId = i;
    }

    @Override
    public void run() {
        logger.info((Object)("ready, myId = " + this.myId));
        int done = 0;
        long time = 0L;
        boolean running = true;
        while (running) {
            try {
                Object o;
                long t;
                block15: {
                    logger.debug((Object)"looking for a job");
                    Runnable job = this.pool.getJob();
                    this.working = true;
                    if (this.debug) {
                        logger.info((Object)("working " + this.myId + " on " + job));
                    }
                    t = System.currentTimeMillis();
                    try {
                        if (job instanceof ShutdownRequest) {
                            this.ec.send(this.myId, "Stop");
                        } else {
                            this.ec.send(this.myId, job);
                        }
                        logger.info((Object)("send " + this.myId + " at " + this.ec + " send job " + job));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        logger.info((Object)("error send " + this.myId + " at " + this.ec + " e = " + e));
                        this.working = false;
                    }
                    o = null;
                    try {
                        if (this.working) {
                            logger.info((Object)("waiting " + this.myId + " on " + job));
                            o = this.ec.receive(this.myId);
                            logger.info((Object)("receive " + this.myId + " at " + this.ec + " send job " + job + " received " + o));
                        }
                    }
                    catch (IOException e) {
                        logger.info((Object)("receive exception " + this.myId + " send job " + job + ", " + e));
                        running = false;
                        logger.info((Object)("receive finally " + this.myId + " at " + this.ec + " send job " + job + " received " + o + " running " + running));
                        break block15;
                    }
                    catch (ClassNotFoundException e) {
                        try {
                            logger.info((Object)("receive exception " + this.myId + " send job " + job + ", " + e));
                            running = false;
                        }
                        catch (Throwable throwable) {
                            logger.info((Object)("receive finally " + this.myId + " at " + this.ec + " send job " + job + " received " + o + " running " + running));
                            throw throwable;
                        }
                        logger.info((Object)("receive finally " + this.myId + " at " + this.ec + " send job " + job + " received " + o + " running " + running));
                        break block15;
                    }
                    logger.info((Object)("receive finally " + this.myId + " at " + this.ec + " send job " + job + " received " + o + " running " + running));
                }
                this.working = false;
                time += System.currentTimeMillis() - t;
                ++done;
                if (!this.debug) continue;
                logger.info((Object)("done " + this.myId + " with " + o));
            }
            catch (InterruptedException e) {
                running = false;
                Thread.currentThread().interrupt();
            }
        }
        logger.info((Object)("terminated " + this.myId + " , done " + done + " jobs in " + time + " milliseconds"));
    }
}

