/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DistPoolThread;
import edu.jas.util.ExecutableChannels;
import edu.jas.util.ShutdownRequest;
import edu.jas.util.StrategyEnumeration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class DistThreadPool {
    private final String mfile;
    private static final String DEFAULT_MFILE = "examples/machines.test";
    protected final int threads;
    static final int DEFAULT_SIZE = 3;
    final ExecutableChannels ec;
    protected DistPoolThread[] workers;
    protected int idleworkers = 0;
    protected LinkedList<Runnable> jobstack;
    protected StrategyEnumeration strategy = StrategyEnumeration.LIFO;
    private static final Logger logger = Logger.getLogger(DistThreadPool.class);
    private final boolean debug = logger.isDebugEnabled();

    public DistThreadPool() {
        this(StrategyEnumeration.FIFO, 3, null);
    }

    public DistThreadPool(StrategyEnumeration strategy) {
        this(strategy, 3, null);
    }

    public DistThreadPool(int size) {
        this(StrategyEnumeration.FIFO, size, null);
    }

    public DistThreadPool(int size, String mfile) {
        this(StrategyEnumeration.FIFO, size, mfile);
    }

    public DistThreadPool(StrategyEnumeration strategy, int size, String mfile) {
        this.strategy = strategy;
        this.threads = size < 0 ? 0 : size;
        this.mfile = mfile == null || mfile.length() == 0 ? DEFAULT_MFILE : mfile;
        this.jobstack = new LinkedList();
        try {
            this.ec = new ExecutableChannels(this.mfile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("DistThreadPool " + e);
        }
        if (this.debug) {
            logger.debug((Object)("ExecutableChannels = " + this.ec));
        }
        try {
            this.ec.open(this.threads);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("DistThreadPool " + e);
        }
        if (this.debug) {
            logger.debug((Object)("ExecutableChannels = " + this.ec));
        }
        this.workers = new DistPoolThread[0];
    }

    public void init() {
        if (this.workers == null || this.workers.length == 0) {
            this.workers = new DistPoolThread[this.threads];
            int i = 0;
            while (i < this.workers.length) {
                this.workers[i] = new DistPoolThread(this, this.ec, i);
                this.workers[i].start();
                ++i;
            }
            logger.info((Object)("size = " + this.threads + ", strategy = " + this.strategy));
        }
    }

    public int getNumber() {
        if (this.workers == null || this.workers.length < this.threads) {
            this.init();
        }
        return this.workers.length;
    }

    public StrategyEnumeration getStrategy() {
        return this.strategy;
    }

    public ExecutableChannels getEC() {
        return this.ec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void terminate(boolean shutDown) {
        if (!shutDown) {
            this.terminate();
            return;
        }
        ShutdownRequest sdr = new ShutdownRequest();
        int i = 0;
        while (i < this.workers.length) {
            this.addJob(sdr);
            ++i;
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        logger.info((Object)("remaining jobs = " + this.jobstack.size()));
        try {
            i = 0;
            block5: while (true) {
                if (i >= this.workers.length) {
                    return;
                }
                while (true) {
                    if (!this.workers[i].isAlive()) {
                        ++i;
                        continue block5;
                    }
                    this.workers[i].interrupt();
                    this.workers[i].join(100L);
                }
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void terminate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void addJob(Runnable job) {
        if (this.workers == null || this.workers.length < this.threads) {
            this.init();
        }
        this.jobstack.addLast(job);
        logger.debug((Object)"adding job");
        if (this.idleworkers > 0) {
            logger.debug((Object)"notifying a jobless worker");
            this.notify();
        }
    }

    protected synchronized Runnable getJob() throws InterruptedException {
        while (this.jobstack.isEmpty()) {
            ++this.idleworkers;
            logger.debug((Object)"waiting");
            this.wait();
            --this.idleworkers;
        }
        if (this.strategy == StrategyEnumeration.LIFO) {
            return this.jobstack.removeLast();
        }
        return this.jobstack.removeFirst();
    }

    public boolean hasJobs() {
        if (this.jobstack.size() > 0) {
            return true;
        }
        int i = 0;
        while (i < this.workers.length) {
            if (this.workers[i].working) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasJobs(int n) {
        int j = this.jobstack.size();
        if (j > 0 && j + this.workers.length > n) {
            return true;
        }
        int x = 0;
        int i = 0;
        while (i < this.workers.length) {
            if (this.workers[i].working) {
                ++x;
            }
            ++i;
        }
        return j + x > n;
    }
}

