/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DistFastWorker;
import edu.jas.util.DistSlowWorker;
import edu.jas.util.DistThreadPool;
import edu.jas.util.ExecutableServer;
import edu.jas.util.StrategyEnumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class DistThreadPoolTest
extends TestCase {
    private static final int port = 4711;
    private ExecutableServer es;
    private DistThreadPool pool;
    static final int JOBS = 10;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)DistThreadPoolTest.suite());
    }

    public DistThreadPoolTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(DistThreadPoolTest.class);
        return suite;
    }

    protected void setUp() {
        this.es = new ExecutableServer(4711);
        this.es.init();
    }

    protected void tearDown() {
        this.pool.terminate();
        this.es.terminate();
    }

    public void testDistThreadPool1() {
        this.pool = new DistThreadPool(0);
        DistThreadPoolTest.assertTrue((String)"not empty pool ", (this.pool.getNumber() == 0 ? 1 : 0) != 0);
    }

    public void testDistThreadPool2() {
        this.pool = new DistThreadPool(1);
        DistThreadPoolTest.assertTrue((String)"# empty pool ", (this.pool.getNumber() == 1 ? 1 : 0) != 0);
        this.pool.terminate();
        this.pool = new DistThreadPool();
        DistThreadPoolTest.assertTrue((String)"# empty pool ", (this.pool.getNumber() == 3 ? 1 : 0) != 0);
        this.pool.terminate();
        this.pool = new DistThreadPool(10);
        DistThreadPoolTest.assertTrue((String)"# empty pool ", (this.pool.getNumber() == 10 ? 1 : 0) != 0);
        this.pool.terminate();
    }

    public void testDistThreadPool3() {
        this.pool = new DistThreadPool();
        DistThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.pool.hasJobs());
        DistThreadPoolTest.assertFalse((String)"more than 0 jobs ", (boolean)this.pool.hasJobs(0));
        this.pool.terminate();
    }

    public void testDistThreadPool4() {
        this.pool = new DistThreadPool();
        DistThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.pool.hasJobs());
        int i = 0;
        while (i < 10 * this.pool.getNumber()) {
            this.pool.addJob(new DistFastWorker());
            ++i;
        }
        boolean j = this.pool.hasJobs();
        DistThreadPoolTest.assertTrue((String)"more than 0 jobs ", (boolean)true);
        this.pool.terminate();
        DistThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.pool.hasJobs());
    }

    public void testDistThreadPool5() {
        this.pool = new DistThreadPool();
        DistThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.pool.hasJobs());
        int i = 0;
        while (i < 10 * this.pool.getNumber()) {
            this.pool.addJob(new DistSlowWorker());
            ++i;
        }
        DistThreadPoolTest.assertTrue((String)"more than 10 jobs ", (boolean)this.pool.hasJobs(10));
        this.pool.terminate();
        DistThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.pool.hasJobs());
    }

    public void testDistThreadPool6() {
        this.pool = new DistThreadPool(StrategyEnumeration.LIFO);
        DistThreadPoolTest.assertTrue((String)"FIFO strategy ", (this.pool.getStrategy() == StrategyEnumeration.LIFO ? 1 : 0) != 0);
    }

    public void testDistThreadPool7() {
        this.pool = new DistThreadPool(StrategyEnumeration.LIFO);
        DistThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.pool.hasJobs());
        int i = 0;
        while (i < 10 * this.pool.getNumber()) {
            this.pool.addJob(new DistFastWorker());
            ++i;
        }
        boolean j = this.pool.hasJobs();
        DistThreadPoolTest.assertTrue((String)"more than 0 jobs ", (boolean)true);
        this.pool.terminate();
        DistThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.pool.hasJobs());
    }
}

