/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DistributedList;
import edu.jas.util.DistributedListServer;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class DistributedListTest
extends TestCase {
    private static final String host = "localhost";
    private DistributedList l1;
    private DistributedList l2;
    private DistributedList l3;
    private DistributedListServer dls;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)DistributedListTest.suite());
    }

    public DistributedListTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(DistributedListTest.class);
        return suite;
    }

    protected void setUp() {
        this.dls = new DistributedListServer();
        this.dls.init();
    }

    protected void tearDown() {
        this.dls.terminate();
        this.dls = null;
        if (this.l1 != null) {
            this.l1.terminate();
        }
        if (this.l2 != null) {
            this.l2.terminate();
        }
        if (this.l3 != null) {
            this.l3.terminate();
        }
        this.l3 = null;
        this.l2 = null;
        this.l1 = null;
    }

    public void testDistributedList1() {
        this.l1 = new DistributedList(host);
        DistributedListTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        this.l1.add(new Integer(1));
        DistributedListTest.assertFalse((String)"l1!=empty", (boolean)this.l1.isEmpty());
        DistributedListTest.assertTrue((String)"#l1==1", (this.l1.size() == 1 ? 1 : 0) != 0);
        this.l1.add(new Integer(2));
        DistributedListTest.assertTrue((String)"#l1==2", (this.l1.size() == 2 ? 1 : 0) != 0);
        this.l1.add(new Integer(3));
        DistributedListTest.assertTrue((String)"#l1==3", (this.l1.size() == 3 ? 1 : 0) != 0);
        Iterator it = null;
        it = this.l1.iterator();
        int i = 0;
        while (it.hasNext()) {
            Object o = it.next();
            Integer x = new Integer(++i);
            DistributedListTest.assertEquals((String)"l1(i)==(i)", (Object)x, o);
        }
        this.l1.clear();
        DistributedListTest.assertTrue((String)"#l1==0", (this.l1.size() == 0 ? 1 : 0) != 0);
    }

    public void testDistributedList2() {
        this.l2 = new DistributedList(host);
        DistributedListTest.assertTrue((String)"l2==empty", (boolean)this.l2.isEmpty());
        this.l1 = new DistributedList(host);
        DistributedListTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        int i = 0;
        int loops = 10;
        while (i < loops) {
            Integer x = new Integer(++i);
            this.l1.add(x);
            DistributedListTest.assertTrue((String)"#l1==i", (this.l1.size() == i ? 1 : 0) != 0);
        }
        DistributedListTest.assertTrue((String)"#l1==10", (this.l1.size() == loops ? 1 : 0) != 0);
        while (this.l2.size() < loops) {
            try {
                System.out.print("2");
                Thread.sleep(100L);
            }
            catch (InterruptedException x) {
                // empty catch block
            }
        }
        Iterator it = null;
        it = this.l2.iterator();
        i = 0;
        while (it.hasNext()) {
            Object o = it.next();
            Integer x = new Integer(++i);
            DistributedListTest.assertEquals((String)"l2(i)==(i)", (Object)x, o);
        }
        DistributedListTest.assertTrue((String)"#l2==10", (this.l2.size() == loops ? 1 : 0) != 0);
    }

    public void testDistributedList3() {
        this.l1 = new DistributedList(host);
        DistributedListTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        this.l2 = new DistributedList(host);
        DistributedListTest.assertTrue((String)"l2==empty", (boolean)this.l2.isEmpty());
        this.l3 = new DistributedList(host);
        DistributedListTest.assertTrue((String)"l3==empty", (boolean)this.l3.isEmpty());
        int i = 0;
        int loops = 10;
        while (i < loops) {
            Integer x = new Integer(++i);
            this.l3.add(x);
            DistributedListTest.assertTrue((String)"#l3==i", (this.l3.size() == i ? 1 : 0) != 0);
        }
        DistributedListTest.assertTrue((String)"#l3==10", (this.l3.size() == loops ? 1 : 0) != 0);
        while (this.l2.size() < loops || this.l1.size() < loops - 1) {
            try {
                System.out.print("3");
                Thread.sleep(100L);
            }
            catch (InterruptedException x) {
                // empty catch block
            }
        }
        DistributedListTest.assertTrue((String)"#l2==10", (this.l2.size() == loops ? 1 : 0) != 0);
        DistributedListTest.assertTrue((String)"#l1==10", (this.l1.size() == loops ? 1 : 0) != 0);
        Iterator it = null;
        it = this.l2.iterator();
        Iterator it3 = null;
        it3 = this.l1.iterator();
        i = 0;
        while (it.hasNext() && it3.hasNext()) {
            Object o = it.next();
            Object p = it3.next();
            Integer x = new Integer(++i);
            DistributedListTest.assertEquals((String)"l2(i)==(i)", (Object)x, o);
            DistributedListTest.assertEquals((String)"l1(i)==(i)", (Object)x, p);
        }
    }

    public void testDistributedList6() {
        this.l1 = new DistributedList(host);
        DistributedListTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        int i = 0;
        int loops = 10;
        while (i < loops) {
            Integer x = new Integer(++i);
            this.l1.add(x);
            DistributedListTest.assertTrue((String)"#l1==i", (this.l1.size() == i ? 1 : 0) != 0);
        }
        DistributedListTest.assertTrue((String)"#l1==10", (this.l1.size() == loops ? 1 : 0) != 0);
        this.l2 = new DistributedList(host);
        while (this.l2.size() < loops) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException x) {
                // empty catch block
            }
        }
        Iterator it = null;
        it = this.l2.iterator();
        i = 0;
        while (it.hasNext()) {
            Object o = it.next();
            Integer x = new Integer(++i);
            DistributedListTest.assertEquals((String)"l2(i)==(i)", (Object)x, o);
        }
        DistributedListTest.assertTrue((String)"#l2==10", (this.l2.size() == loops ? 1 : 0) != 0);
    }
}

