/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.SocketChannel;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ExecutableChannels {
    private static final Logger logger = Logger.getLogger(ExecutableChannels.class);
    protected static final int DEFAULT_PORT = 7114;
    protected static final String DEFAULT_MFILE = "examples/machines.test";
    protected final ChannelFactory cf;
    protected SocketChannel[] channels;
    protected String[] servers;
    protected int[] ports;

    protected ExecutableChannels() {
        this.channels = null;
        this.servers = null;
        this.ports = null;
        this.cf = new ChannelFactory();
        this.cf.init();
    }

    public ExecutableChannels(String[] srvs) {
        this();
        if (srvs == null) {
            return;
        }
        this.servers = new String[srvs.length];
        this.ports = new int[srvs.length];
        int i = 0;
        while (i < srvs.length) {
            this.setServerPort(i, srvs[i]);
            ++i;
        }
    }

    public ExecutableChannels(String mfile) throws FileNotFoundException {
        ArrayList<String> list;
        block16: {
            this();
            if (mfile == null || mfile.length() == 0) {
                mfile = DEFAULT_MFILE;
            }
            BufferedReader in = new BufferedReader(new FileReader(mfile));
            String line = null;
            list = new ArrayList<String>();
            try {
                try {
                    while (in.ready() && (line = in.readLine()) != null) {
                        int x = line.indexOf("#");
                        if (x >= 0) {
                            line = line.substring(0, x);
                        }
                        if ((line = line.trim()).length() == 0) continue;
                        list.add(line);
                    }
                }
                catch (IOException iOException) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException2) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.debug((Object)("list.size() in " + mfile + " = " + list.size()));
        if (list.size() == 0) {
            return;
        }
        this.servers = new String[list.size()];
        this.ports = new int[list.size()];
        int i = 0;
        while (i < this.servers.length) {
            this.setServerPort(i, (String)list.get(i));
            ++i;
        }
    }

    protected void setServerPort(int i, String srv) {
        int x = srv.indexOf(":");
        this.ports[i] = 7114;
        if (x < 0) {
            this.servers[i] = srv;
        } else {
            this.servers[i] = srv.substring(0, x);
            String p = srv.substring(x + 1, srv.length());
            try {
                this.ports[i] = Integer.parseInt(p);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer("ExecutableChannels(");
        if (this.servers != null) {
            i = 0;
            while (i < this.servers.length) {
                s.append(String.valueOf(this.servers[i]) + ":" + this.ports[i]);
                if (i < this.servers.length - 1) {
                    s.append(" ");
                }
                ++i;
            }
        }
        if (this.channels != null) {
            s.append(" channels = ");
            i = 0;
            while (i < this.channels.length) {
                s.append(this.channels[i]);
                if (i < this.channels.length - 1) {
                    s.append(" ");
                }
                ++i;
            }
        }
        s.append(")");
        return s.toString();
    }

    public int numServers() {
        if (this.servers != null) {
            return this.servers.length;
        }
        return -1;
    }

    public String getMasterHost() {
        if (this.servers != null && this.servers.length > 0) {
            return this.servers[0];
        }
        return null;
    }

    public int getMasterPort() {
        if (this.ports != null && this.ports.length > 0) {
            return this.ports[0];
        }
        return 0;
    }

    public int numChannels() {
        if (this.channels != null) {
            return this.channels.length;
        }
        return -1;
    }

    public void open() throws IOException {
        logger.debug((Object)("opening " + this.servers.length + " channels"));
        if (this.servers.length <= 1) {
            throw new IOException("to few servers");
        }
        this.channels = new SocketChannel[this.servers.length - 1];
        int i = 1;
        while (i < this.servers.length) {
            this.channels[i - 1] = this.cf.getChannel(this.servers[i], this.ports[i]);
            ++i;
        }
    }

    public void open(int nc) throws IOException {
        logger.debug((Object)("opening " + nc + " channels"));
        if (this.servers.length <= 1) {
            throw new IOException("to few servers");
        }
        this.channels = new SocketChannel[nc];
        int j = 1;
        int i = 0;
        while (i < this.channels.length) {
            if (j >= this.servers.length) {
                j = 1;
            }
            this.channels[i] = this.cf.getChannel(this.servers[j], this.ports[j]);
            ++j;
            ++i;
        }
    }

    public void close() {
        logger.debug((Object)"closing ExecutableChannels");
        if (this.cf != null) {
            this.cf.terminate();
        }
        if (this.channels != null) {
            int i = 0;
            while (i < this.channels.length) {
                if (this.channels[i] != null) {
                    block9: {
                        try {
                            try {
                                this.channels[i].send("Stop");
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                this.channels[i].close();
                                break block9;
                            }
                        }
                        catch (Throwable throwable) {
                            this.channels[i].close();
                            throw throwable;
                        }
                        this.channels[i].close();
                    }
                    this.channels[i] = null;
                }
                ++i;
            }
            this.channels = null;
        }
        logger.debug((Object)"ExecuteChannels closed");
    }

    public SocketChannel getChannel(int i) {
        if (this.channels != null && i >= 0 && i < this.channels.length) {
            return this.channels[i];
        }
        return null;
    }

    SocketChannel[] getChannels() {
        return this.channels;
    }

    public void send(int i, Object o) throws IOException {
        if (this.channels != null && i >= 0 && i < this.channels.length) {
            this.channels[i].send(o);
        }
    }

    public Object receive(int i) throws IOException, ClassNotFoundException {
        if (this.channels != null && i >= 0 && i < this.channels.length) {
            return this.channels[i].receive();
        }
        return null;
    }
}

