/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ExecutableChannels;
import edu.jas.util.ExecutableServer;
import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ExecutableChannelsTest
extends TestCase {
    private static final String host = "localhost";
    private static final int port = 4711;
    private static final String mfile = "examples/machines.test";
    private ExecutableChannels ec;
    private ExecutableServer es;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ExecutableChannelsTest.suite());
    }

    public ExecutableChannelsTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ExecutableChannelsTest.class);
        return suite;
    }

    protected void setUp() {
        this.ec = null;
        this.es = new ExecutableServer(4711);
        this.es.init();
    }

    protected void tearDown() {
        this.es.terminate();
        this.es = null;
        if (this.ec != null) {
            this.ec.close();
            this.ec = null;
        }
    }

    public void testExecutableChannels1() {
        String[] servers = null;
        this.ec = new ExecutableChannels(servers);
        ExecutableChannelsTest.assertEquals((String)"numServers<0", (int)-1, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        String ts = "" + this.ec;
        ExecutableChannelsTest.assertEquals((String)"toString", (String)"ExecutableChannels()", (String)ts);
    }

    public void testExecutableChannels2() {
        int nums = 1;
        String[] servers = new String[nums];
        int i = 0;
        while (i < nums) {
            servers[i] = "localhost:4711";
            ++i;
        }
        this.ec = new ExecutableChannels(servers);
        ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)1, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        String ts = "" + this.ec;
        ExecutableChannelsTest.assertEquals((String)"toString", (String)"ExecutableChannels(localhost:4711)", (String)ts);
    }

    public void testExecutableChannels3() {
        int nums = 100;
        String[] servers = new String[nums];
        int i = 0;
        while (i < nums) {
            servers[i] = "localhost:4711";
            ++i;
        }
        this.ec = new ExecutableChannels(servers);
        ExecutableChannelsTest.assertEquals((String)"numServers==100", (int)100, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        String ts = "" + this.ec;
        int l = "ExecutableChannels()".length() + nums * servers[0].length() + nums - 1;
        ExecutableChannelsTest.assertEquals((String)"toString.length()", (int)l, (int)ts.length());
    }

    public void testExecutableChannels4() {
        int nums = 2;
        int numc = nums - 1;
        String[] servers = new String[nums];
        int i = 0;
        while (i < nums) {
            servers[i] = "localhost:4711";
            ++i;
        }
        this.ec = new ExecutableChannels(servers);
        ExecutableChannelsTest.assertEquals((String)"numServers==2", (int)nums, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        String ts = "" + this.ec;
        int l = "ExecutableChannels()".length() + nums * servers[0].length() + nums - 1;
        ExecutableChannelsTest.assertEquals((String)"toString.length()", (int)l, (int)ts.length());
        try {
            this.ec.open();
            ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)nums, (int)this.ec.numServers());
            ExecutableChannelsTest.assertEquals((String)"numServers==numChannels", (int)numc, (int)this.ec.numChannels());
        }
        catch (IOException e) {
            ExecutableChannelsTest.fail((String)("open()" + e));
        }
        this.ec.close();
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
    }

    public void testExecutableChannels5() {
        int nums = 11;
        int numc = nums - 1;
        String[] servers = new String[nums];
        int i = 0;
        while (i < nums) {
            servers[i] = "localhost:4711";
            ++i;
        }
        this.ec = new ExecutableChannels(servers);
        ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)nums, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        String ts = "" + this.ec;
        int l = "ExecutableChannels()".length() + nums * servers[0].length() + nums - 1;
        ExecutableChannelsTest.assertEquals((String)"toString.length()", (int)l, (int)ts.length());
        try {
            this.ec.open();
            ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)nums, (int)this.ec.numServers());
            ExecutableChannelsTest.assertEquals((String)"numServers==numChannels", (int)numc, (int)this.ec.numChannels());
        }
        catch (IOException e) {
            ExecutableChannelsTest.fail((String)("open()" + e));
        }
        this.ec.close();
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
    }

    public void testExecutableChannels6() {
        int nums = 2;
        int numc = 10;
        String[] servers = new String[nums];
        int i = 0;
        while (i < nums) {
            servers[i] = "localhost:4711";
            ++i;
        }
        this.ec = new ExecutableChannels(servers);
        ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)nums, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        try {
            this.ec.open(numc);
            ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)nums, (int)this.ec.numServers());
            ExecutableChannelsTest.assertEquals((String)"numServers==numChannels", (int)numc, (int)this.ec.numChannels());
        }
        catch (IOException e) {
            ExecutableChannelsTest.fail((String)("open()" + e));
        }
        this.ec.close();
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
    }

    public void testExecutableChannels7() {
        int nums = 10;
        int numc = 5;
        String[] servers = new String[nums];
        int i = 0;
        while (i < nums) {
            servers[i] = "localhost:4711";
            ++i;
        }
        this.ec = new ExecutableChannels(servers);
        ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)nums, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        try {
            this.ec.open(numc);
            ExecutableChannelsTest.assertEquals((String)"numServers==1", (int)nums, (int)this.ec.numServers());
            ExecutableChannelsTest.assertEquals((String)"numServers==numChannels", (int)numc, (int)this.ec.numChannels());
        }
        catch (IOException e) {
            ExecutableChannelsTest.fail((String)("open()" + e));
        }
        this.ec.close();
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
    }

    public void testExecutableChannels8() {
        try {
            this.ec = new ExecutableChannels(mfile);
        }
        catch (FileNotFoundException e) {
            ExecutableChannelsTest.fail((String)("readfile()" + e));
        }
        ExecutableChannelsTest.assertEquals((String)"numServers==4", (int)4, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        int numc = this.ec.numServers();
        try {
            this.ec.open(numc);
            ExecutableChannelsTest.assertEquals((String)"numServers==numChannels", (int)numc, (int)this.ec.numChannels());
        }
        catch (IOException e) {
            ExecutableChannelsTest.fail((String)("open()" + e));
        }
        this.ec.close();
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
    }

    public void testExecutableChannels9() {
        try {
            this.ec = new ExecutableChannels(mfile);
        }
        catch (FileNotFoundException e) {
            ExecutableChannelsTest.fail((String)("readfile()" + e));
        }
        ExecutableChannelsTest.assertEquals((String)"numServers==4", (int)4, (int)this.ec.numServers());
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
        int numc = 10;
        try {
            this.ec.open(numc);
            ExecutableChannelsTest.assertEquals((String)"numServers==numChannels", (int)numc, (int)this.ec.numChannels());
        }
        catch (IOException e) {
            ExecutableChannelsTest.fail((String)("open()" + e));
        }
        this.ec.close();
        ExecutableChannelsTest.assertEquals((String)"numChannels<0", (int)-1, (int)this.ec.numChannels());
    }
}

