/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.Executor;
import edu.jas.util.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class ExecutableServer
extends Thread {
    private static final Logger logger = Logger.getLogger(ExecutableServer.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final ChannelFactory cf;
    protected List<Executor> servers = null;
    public static final int DEFAULT_PORT = 7411;
    public static final String DONE = "Done";
    public static final String STOP = "Stop";
    private volatile boolean goon = true;
    private Thread mythread = null;

    public ExecutableServer() {
        this(7411);
    }

    public ExecutableServer(int port) {
        this(new ChannelFactory(port));
    }

    public ExecutableServer(ChannelFactory cf) {
        this.cf = cf;
        cf.init();
        this.servers = new ArrayList<Executor>();
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        int port = 7411;
        if (args.length < 1) {
            System.out.println("Usage: ExecutableServer <port>");
        } else {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        logger.info((Object)("ExecutableServer at port " + port));
        new ExecutableServer(port).run();
    }

    public void init() {
        this.start();
        logger.info((Object)("ExecutableServer at " + this.cf));
    }

    public int size() {
        return this.servers.size();
    }

    @Override
    public void run() {
        SocketChannel channel = null;
        Executor s = null;
        this.mythread = Thread.currentThread();
        while (this.goon) {
            if (this.debug) {
                logger.info((Object)("execute server " + this + " go on"));
            }
            try {
                channel = this.cf.getChannel();
                logger.debug((Object)("execute channel = " + channel));
                if (this.mythread.isInterrupted()) {
                    this.goon = false;
                    logger.debug((Object)("execute server " + this + " interrupted"));
                    channel.close();
                    continue;
                }
                s = new Executor(channel);
                if (this.goon) {
                    this.servers.add(s);
                    s.start();
                    logger.debug((Object)("server " + s + " started"));
                    continue;
                }
                s = null;
                channel.close();
            }
            catch (InterruptedException e) {
                this.goon = false;
                Thread.currentThread().interrupt();
                if (!logger.isDebugEnabled()) continue;
                e.printStackTrace();
            }
        }
        if (this.debug) {
            logger.info((Object)("execute server " + this + " terminated"));
        }
    }

    /*
     * Exception decompiling
     */
    public void terminate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

