/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.Executable;
import edu.jas.util.ExecutableServer;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ExecutableServerTest
extends TestCase {
    private static final String host = "localhost";
    private static final int port = 4711;
    private ExecutableServer es;
    private ChannelFactory cf;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ExecutableServerTest.suite());
    }

    public ExecutableServerTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ExecutableServerTest.class);
        return suite;
    }

    protected void setUp() {
        this.es = new ExecutableServer(4711);
        this.es.init();
        this.cf = new ChannelFactory();
    }

    protected void tearDown() {
        this.es.terminate();
        this.es = null;
        this.cf.terminate();
        this.cf = null;
    }

    public void testExecutableServer1() {
        ExecutableServerTest.assertTrue((String)"should never fail", (boolean)true);
    }

    public void testExecutableServer2() {
        Executable e1 = new Executable("2");
        try {
            SocketChannel sc = this.cf.getChannel(host, 4711);
            sc.send(e1);
            Object o = sc.receive();
            ExecutableServerTest.assertTrue((String)"o:String", (boolean)(o instanceof String));
            ExecutableServerTest.assertEquals((String)"o==done", (String)((String)o), (String)"Done");
            sc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            ExecutableServerTest.fail((String)"IOException");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            ExecutableServerTest.fail((String)"ClassNotFoundException");
        }
    }

    public void testExecutableServer3() {
        Executable e1 = new Executable("3");
        int numloops = 1;
        try {
            SocketChannel sc = this.cf.getChannel(host, 4711);
            int i = 0;
            while (i < numloops) {
                sc.send(e1);
                Object o = sc.receive();
                ExecutableServerTest.assertTrue((String)"o:String", (boolean)(o instanceof String));
                ExecutableServerTest.assertEquals((String)"o==done", (String)((String)o), (String)"Done");
                ++i;
            }
            sc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            ExecutableServerTest.fail((String)"IOException");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            ExecutableServerTest.fail((String)"ClassNotFoundException");
        }
    }

    public void testExecutableServer4() {
        Executable e1 = null;
        SocketChannel sc = null;
        try {
            int i = 0;
            while (i < 4) {
                e1 = new Executable("4-" + i);
                sc = this.cf.getChannel(host, 4711);
                sc.send(e1);
                Object o = sc.receive();
                ExecutableServerTest.assertTrue((String)"o:String", (boolean)(o instanceof String));
                ExecutableServerTest.assertEquals((String)"o==done", (String)((String)o), (String)"Done");
                e1 = null;
                sc.close();
                sc = null;
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            ExecutableServerTest.fail((String)"IOException");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            ExecutableServerTest.fail((String)"ClassNotFoundException");
        }
    }
}

