/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.arith.BigInteger;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.util.CartesianProduct;
import edu.jas.util.CartesianProductInfinite;
import edu.jas.util.CartesianProductLong;
import edu.jas.util.ExpVectorIterable;
import edu.jas.util.KsubSet;
import edu.jas.util.LongIterable;
import edu.jas.util.PowerSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class IteratorsTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)IteratorsTest.suite());
    }

    public IteratorsTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(IteratorsTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testCartesianProduct() {
        BigInteger ai = new BigInteger();
        int s1 = 5;
        int s2 = 3;
        int s = 1;
        int i = 0;
        while (i < s1) {
            s *= s2;
            ++i;
        }
        ArrayList tlist = new ArrayList(s1);
        int i2 = 0;
        while (i2 < s1) {
            ArrayList<BigInteger> list = new ArrayList<BigInteger>(s2);
            int j = 0;
            while (j < s2) {
                list.add(ai.fromInteger(j));
                ++j;
            }
            tlist.add(list);
            ++i2;
        }
        int t = 0;
        for (List tuple : new CartesianProduct(tlist)) {
            ++t;
            IteratorsTest.assertTrue((String)("|tuple| == " + s1 + " "), (s1 == tuple.size() ? 1 : 0) != 0);
        }
        IteratorsTest.assertTrue((String)("#tuple == " + s + " == " + t + " "), (t == s ? 1 : 0) != 0);
    }

    public void testPowerSet() {
        BigInteger ai = new BigInteger();
        int s1 = 5;
        int s = 1;
        int i = 0;
        while (i < s1) {
            s *= 2;
            ++i;
        }
        ArrayList<BigInteger> tlist = new ArrayList<BigInteger>(s1);
        int j = 0;
        while (j < s1) {
            tlist.add(ai.random(7));
            ++j;
        }
        int t = 0;
        for (List tuple : new PowerSet(tlist)) {
            ++t;
        }
        IteratorsTest.assertTrue((String)("#tuple == " + s + " == " + t + " "), (t == s ? 1 : 0) != 0);
    }

    public void testKsubSet() {
        BigInteger ai = new BigInteger();
        int s1 = 5;
        int s = 1;
        int i = 0;
        while (i < s1) {
            s *= 2;
            ++i;
        }
        ArrayList<BigInteger> tlist = new ArrayList<BigInteger>(s1);
        int j = 0;
        while (j < s1) {
            tlist.add(ai.random(7));
            ++j;
        }
        int t = 0;
        int k = 0;
        while (k <= s1) {
            for (List tuple : new KsubSet(tlist, k)) {
                ++t;
                IteratorsTest.assertTrue((String)("|tuple| == " + k + " "), (k == tuple.size() ? 1 : 0) != 0);
            }
            ++k;
        }
        IteratorsTest.assertTrue((String)("#tuple == " + s + " == " + t + " "), (t == s ? 1 : 0) != 0);
    }

    public void testInfiniteCartesianProductTwoList() {
        BigInteger ai = new BigInteger();
        ai.setNonNegativeIterator();
        int s1 = 2;
        ArrayList<Iterable<BigInteger>> tlist = new ArrayList<Iterable<BigInteger>>(s1);
        int i = 0;
        while (i < s1) {
            tlist.add(ai);
            ++i;
        }
        HashSet set = new HashSet();
        int s2 = 5;
        int s = 1;
        int i2 = 0;
        while (i2 < s1) {
            s *= s2;
            ++i2;
        }
        ArrayList ftlist = new ArrayList(s1);
        int i3 = 0;
        while (i3 < s1) {
            ArrayList<BigInteger> list = new ArrayList<BigInteger>(s2);
            int j = 0;
            while (j < s2) {
                list.add(ai.fromInteger(j));
                ++j;
            }
            ftlist.add(list);
            ++i3;
        }
        int r = 0;
        for (List tuple : new CartesianProduct(ftlist)) {
            ++r;
            set.add(tuple);
        }
        int t = 0;
        int h = 0;
        CartesianProductInfinite ib = new CartesianProductInfinite(tlist);
        for (List list : ib) {
            ++t;
            if (set.contains(list)) {
                ++h;
            }
            if (h >= r) break;
            IteratorsTest.assertTrue((String)("#tuple <= 125 " + t), (t <= 125 ? 1 : 0) != 0);
        }
    }

    public void testInfiniteCartesianProduct() {
        BigInteger ai = new BigInteger();
        ai.setNonNegativeIterator();
        int s1 = 4;
        ArrayList<Iterable<BigInteger>> tlist = new ArrayList<Iterable<BigInteger>>(s1);
        int i = 0;
        while (i < s1) {
            tlist.add(ai);
            ++i;
        }
        HashSet set = new HashSet();
        int s2 = 5;
        int s = 1;
        int i2 = 0;
        while (i2 < s1) {
            s *= s2;
            ++i2;
        }
        ArrayList ftlist = new ArrayList(s1);
        int i3 = 0;
        while (i3 < s1) {
            ArrayList<BigInteger> list = new ArrayList<BigInteger>(s2);
            int j = 0;
            while (j < s2) {
                list.add(ai.fromInteger(j));
                ++j;
            }
            ftlist.add(list);
            ++i3;
        }
        int r = 0;
        for (List tuple : new CartesianProduct(ftlist)) {
            ++r;
            set.add(tuple);
        }
        int t = 0;
        int h = 0;
        CartesianProductInfinite ib = new CartesianProductInfinite(tlist);
        for (List list : ib) {
            ++t;
            if (set.contains(list)) {
                ++h;
            }
            if (h >= r) break;
            IteratorsTest.assertTrue((String)("#tuple <= 3281 " + t), (t <= 3281 ? 1 : 0) != 0);
        }
    }

    public void testLong() {
        LongIterable li = new LongIterable();
        li.setNonNegativeIterator();
        long s = 0L;
        long t = 0L;
        for (Long i : li) {
            s = i;
            IteratorsTest.assertTrue((String)"t == i", (t == i ? 1 : 0) != 0);
            if (++t > 1000L) break;
        }
        IteratorsTest.assertTrue((String)"i == 1000", (s == 1000L ? 1 : 0) != 0);
        li.setAllIterator();
        s = 0L;
        t = 0L;
        for (Long i : li) {
            s = i;
            if (++t >= 1000L) break;
        }
        IteratorsTest.assertTrue((String)"i == 500", (s == 500L ? 1 : 0) != 0);
    }

    public void testExpVector() {
        int n = 5;
        LongIterable li = new LongIterable();
        li.setNonNegativeIterator();
        ArrayList<Iterable<LongIterable>> tlist = new ArrayList<Iterable<LongIterable>>(n);
        int i = 0;
        while (i < n) {
            tlist.add(li);
            ++i;
        }
        TreeSet<ExpVector> set = new TreeSet<ExpVector>(new TermOrder().getDescendComparator());
        CartesianProductInfinite ib = new CartesianProductInfinite(tlist);
        long t = 0L;
        for (List list : ib) {
            ExpVector e = ExpVector.create(list);
            IteratorsTest.assertFalse((String)"e in set", (boolean)set.contains(e));
            set.add(e);
            if (++t > 100L) break;
        }
        IteratorsTest.assertTrue((String)"#set", ((long)set.size() == t ? 1 : 0) != 0);
    }

    public void testGenPolynomial() {
        ModIntegerRing mi = new ModIntegerRing(5L, true);
        int n = 3;
        GenPolynomialRing<ModInteger> ring = new GenPolynomialRing<ModInteger>(mi, n);
        TreeSet<GenPolynomial<ModInteger>> set = new TreeSet<GenPolynomial<ModInteger>>();
        long t = 0L;
        for (GenPolynomial<ModInteger> genPolynomial : ring) {
            if (set.contains(genPolynomial)) {
                System.out.println("p = " + genPolynomial);
                System.out.println("set = " + set);
                IteratorsTest.assertFalse((String)"p in set ", (boolean)true);
            }
            set.add(genPolynomial);
            if (++t > 650L) break;
        }
        IteratorsTest.assertTrue((String)"#set", ((long)set.size() == t ? 1 : 0) != 0);
    }

    public void testGenPolynomialMonomial() {
        BigInteger bi = new BigInteger(1L);
        int n = 3;
        GenPolynomialRing<BigInteger> ring = new GenPolynomialRing<BigInteger>(bi, n);
        TreeSet<GenPolynomial<BigInteger>> set = new TreeSet<GenPolynomial<BigInteger>>();
        long t = 0L;
        for (GenPolynomial<BigInteger> genPolynomial : ring) {
            if (set.contains(genPolynomial)) {
                System.out.println("p = " + genPolynomial);
                IteratorsTest.assertFalse((String)"p in set ", (boolean)true);
            }
            set.add(genPolynomial);
            if (++t > 650L) break;
        }
        IteratorsTest.assertTrue((String)"#set", ((long)set.size() == t ? 1 : 0) != 0);
    }

    public void testTotalDegExpVector() {
        int n = 4;
        TreeSet<ExpVector> set = new TreeSet<ExpVector>(new TermOrder().getDescendComparator());
        TreeMap<Long, TreeSet<ExpVector>> degset = new TreeMap<Long, TreeSet<ExpVector>>();
        long t = 0L;
        long k = 0L;
        while (k < 14L) {
            LongIterable li = new LongIterable();
            li.setNonNegativeIterator();
            li.setUpperBound(k);
            ArrayList<LongIterable> tlist = new ArrayList<LongIterable>(n);
            int i = 0;
            while (i < n) {
                tlist.add(li);
                ++i;
            }
            long kdeg = k;
            CartesianProductLong ib = new CartesianProductLong(tlist, kdeg);
            for (List i2 : ib) {
                ExpVector e = ExpVector.create(i2);
                long tdeg = e.totalDeg();
                IteratorsTest.assertTrue((String)"tdeg == k", (tdeg == kdeg ? 1 : 0) != 0);
                TreeSet<ExpVector> es = (TreeSet<ExpVector>)degset.get(tdeg);
                if (es == null) {
                    es = new TreeSet<ExpVector>(new TermOrder().getDescendComparator());
                    degset.put(tdeg, es);
                }
                es.add(e);
                set.add(e);
                if (++t > 500000L) break;
            }
            ++k;
        }
        for (Set set2 : degset.values()) {
        }
        IteratorsTest.assertTrue((String)"#set", ((long)set.size() == t ? 1 : 0) != 0);
    }

    public void testTotalDegExpVectorIteratorInf() {
        int n = 4;
        TreeSet<ExpVector> set = new TreeSet<ExpVector>(new TermOrder().getDescendComparator());
        ExpVectorIterable eiter = new ExpVectorIterable(n);
        long t = 0L;
        for (ExpVector e : eiter) {
            if (++t > 500L) break;
            IteratorsTest.assertFalse((String)"e in set", (boolean)set.contains(e));
            set.add(e);
        }
    }

    public void testTotalDegExpVectorIteratorFin() {
        int n = 4;
        TreeSet<ExpVector> set = new TreeSet<ExpVector>(new TermOrder().getDescendComparator());
        ExpVectorIterable eiter = new ExpVectorIterable(n, 5L);
        long t = 0L;
        for (ExpVector e : eiter) {
            if (++t > 500L) break;
            IteratorsTest.assertFalse((String)"e in set", (boolean)set.contains(e));
            set.add(e);
        }
    }

    public void testTotalDegExpVectorIteratorAllFin() {
        int n = 4;
        TreeSet<ExpVector> set = new TreeSet<ExpVector>(new TermOrder().getDescendComparator());
        ExpVectorIterable eiter = new ExpVectorIterable(n, true, 5L);
        long t = 0L;
        for (ExpVector e : eiter) {
            if (++t > 500L) break;
            IteratorsTest.assertFalse((String)"e in set", (boolean)set.contains(e));
            set.add(e);
        }
    }
}

