/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.KsubSetIterator;
import edu.jas.util.OneSubSetIterator;
import edu.jas.util.ZeroSubSetIterator;
import java.util.Iterator;
import java.util.List;

public class KsubSet<E>
implements Iterable<List<E>> {
    public final List<E> set;
    public final int k;

    public KsubSet(List<E> set, int k) {
        if (set == null) {
            throw new IllegalArgumentException("null set not allowed");
        }
        this.set = set;
        if (k < 0 || k > set.size()) {
            throw new IllegalArgumentException("k out of range");
        }
        this.k = k;
    }

    @Override
    public Iterator<List<E>> iterator() {
        if (this.k == 0) {
            return new ZeroSubSetIterator<E>(this.set);
        }
        if (this.k == 1) {
            return new OneSubSetIterator<E>(this.set);
        }
        return new KsubSetIterator<E>(this.set, this.k);
    }
}

