/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ThreadPool;
import org.apache.log4j.Logger;

class PoolThread
extends Thread {
    ThreadPool pool;
    private static final Logger logger = Logger.getLogger(ThreadPool.class);
    private static boolean debug = logger.isDebugEnabled();
    volatile boolean isWorking = false;

    public PoolThread(ThreadPool pool) {
        this.pool = pool;
    }

    @Override
    public void run() {
        logger.info((Object)"ready");
        int done = 0;
        long time = 0L;
        boolean running = true;
        while (running) {
            try {
                logger.debug((Object)"looking for a job");
                Runnable job = this.pool.getJob();
                if (job == null) break;
                if (debug) {
                    logger.info((Object)"working");
                }
                long t = System.currentTimeMillis();
                this.isWorking = true;
                job.run();
                this.isWorking = false;
                time += System.currentTimeMillis() - t;
                ++done;
                if (!debug) continue;
                logger.info((Object)"done");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                running = false;
                this.isWorking = false;
            }
        }
        this.isWorking = false;
        logger.info((Object)("terminated, done " + done + " jobs in " + time + " milliseconds"));
    }
}

