/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.arith.BigInteger;
import edu.jas.arith.Combinatoric;
import edu.jas.util.KsubSet;
import edu.jas.util.PowerSet;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PowerSetTest
extends TestCase {
    BigInteger ai;

    public static void main(String[] args) {
        TestRunner.run((Test)PowerSetTest.suite());
    }

    public PowerSetTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(PowerSetTest.class);
        return suite;
    }

    protected void setUp() {
        this.ai = null;
    }

    protected void tearDown() {
        this.ai = null;
    }

    public void testIterator() {
        int N2 = 10;
        this.ai = new BigInteger();
        ArrayList<BigInteger> list = new ArrayList<BigInteger>();
        int i = 0;
        while (i < 10) {
            list.add(this.ai.random(7));
            ++i;
        }
        PowerSet ps = new PowerSet(list);
        long i2 = 0L;
        for (List subs : ps) {
            if (i2 < 0L) {
                System.out.println("subs = " + subs);
            }
            if (subs == null) continue;
            PowerSetTest.assertTrue((String)"size(subs) >= 0 ", (subs.size() >= 0 ? 1 : 0) != 0);
            ++i2;
        }
        long j = 1L;
        int k = 0;
        while (k < 10) {
            j *= 2L;
            ++k;
        }
        PowerSetTest.assertEquals((String)"size(ps) == 2**N ", (long)i2, (long)j);
    }

    public void noTestKSubsetIterator() {
        int N2 = 10;
        this.ai = new BigInteger();
        ArrayList<BigInteger> list = new ArrayList<BigInteger>();
        int i = 0;
        while (i < 10) {
            list.add(this.ai.random(7));
            ++i;
        }
        System.out.println("list = " + list);
        KsubSet ks = new KsubSet(list, 0);
        long i2 = 0L;
        for (List subs : ks) {
            if (i2 >= 0L) {
                System.out.println("subs = " + subs);
            }
            if (subs == null) continue;
            PowerSetTest.assertTrue((String)"size(subs) >= 0 ", (subs.size() == 0 ? 1 : 0) != 0);
            ++i2;
        }
        long s = Combinatoric.binCoeff(10, 0).getVal().longValue();
        PowerSetTest.assertEquals((String)("size(ks) == " + s + " "), (long)i2, (long)s);
        ks = new KsubSet(list, 1);
        i2 = 0L;
        for (List subs : ks) {
            if (i2 >= 0L) {
                System.out.println("subs = " + subs);
            }
            if (subs == null) continue;
            PowerSetTest.assertTrue((String)"size(subs) >= 0 ", (subs.size() == 1 ? 1 : 0) != 0);
            ++i2;
        }
        s = Combinatoric.binCoeff(10, 1).getVal().longValue();
        PowerSetTest.assertEquals((String)("size(ks) == " + s + " "), (long)i2, (long)s);
        ks = new KsubSet(list, 2);
        i2 = 0L;
        for (List subs : ks) {
            if (i2 >= 0L) {
                System.out.println("subs = " + subs);
            }
            if (subs == null) continue;
            PowerSetTest.assertTrue((String)"size(subs) >= 0 ", (subs.size() == 2 ? 1 : 0) != 0);
            ++i2;
        }
        s = Combinatoric.binCoeff(10, 2).getVal().longValue();
        PowerSetTest.assertEquals((String)("size(ks) == " + s + " "), (long)i2, (long)s);
        ks = new KsubSet(list, 3);
        i2 = 0L;
        for (List subs : ks) {
            if (i2 >= 0L) {
                System.out.println("subs = " + subs);
            }
            if (subs == null) continue;
            PowerSetTest.assertTrue((String)"size(subs) >= 0 ", (subs.size() == 3 ? 1 : 0) != 0);
            ++i2;
        }
        s = Combinatoric.binCoeff(10, 3).getVal().longValue();
        PowerSetTest.assertEquals((String)("size(ks) == " + s + " "), (long)i2, (long)s);
    }

    public void testAnyKSubsetIterator() {
        int N2 = 10;
        this.ai = new BigInteger();
        ArrayList<BigInteger> list = new ArrayList<BigInteger>();
        int i = 0;
        while (i < 10) {
            list.add(this.ai.random(7));
            ++i;
        }
        int k = 0;
        while (k <= 10) {
            KsubSet ks = new KsubSet(list, k);
            long i2 = 0L;
            for (List subs : ks) {
                if (i2 < 0L) {
                    System.out.println("subs = " + subs);
                }
                if (subs == null) continue;
                PowerSetTest.assertTrue((String)"size(subs) >= 0 ", (subs.size() == k ? 1 : 0) != 0);
                ++i2;
            }
            long s = Combinatoric.binCoeff(10, k).getVal().longValue();
            PowerSetTest.assertEquals((String)("size(ks) == " + s + " "), (long)i2, (long)s);
            ++k;
        }
    }
}

