/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class SocketChannelTest
extends TestCase {
    private ChannelFactory cf;
    private SocketChannel sc1;
    private SocketChannel sc2;
    private String host;
    private int port;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)SocketChannelTest.suite());
    }

    public SocketChannelTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SocketChannelTest.class);
        return suite;
    }

    protected void setUp() {
        this.host = "localhost";
        this.port = 4711;
        this.cf = new ChannelFactory(this.port);
        this.cf.init();
        try {
            this.sc1 = this.cf.getChannel(this.host, this.port);
            this.sc2 = this.cf.getChannel();
        }
        catch (IOException e) {
            SocketChannelTest.fail((String)("IOException" + e));
        }
        catch (InterruptedException e) {
            SocketChannelTest.fail((String)("InterruptedException" + e));
        }
    }

    protected void tearDown() {
        this.cf.terminate();
        this.sc1.close();
        this.sc2.close();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            SocketChannelTest.fail((String)("InterruptedException" + e));
        }
    }

    public void testSocketChannel0() {
    }

    public void testSocketChannel1() {
        Integer o = new Integer(0);
        try {
            this.sc1.send(o);
            SocketChannelTest.assertEquals((Object)o, (Object)this.sc2.receive());
        }
        catch (IOException e) {
            SocketChannelTest.fail((String)("Exception" + e));
        }
        catch (ClassNotFoundException e) {
            SocketChannelTest.fail((String)("Exception" + e));
        }
    }

    public void testSocketChannel2() {
        Integer o = new Integer(0);
        try {
            this.sc1.send(o);
            this.sc2.send(o);
            SocketChannelTest.assertEquals((Object)o, (Object)this.sc1.receive());
            SocketChannelTest.assertEquals((Object)o, (Object)this.sc2.receive());
        }
        catch (IOException e) {
            SocketChannelTest.fail((String)("Exception" + e));
        }
        catch (ClassNotFoundException e) {
            SocketChannelTest.fail((String)("Exception" + e));
        }
    }

    public void testSocketChannel3() {
        int n = 10;
        try {
            Integer o;
            int i = 0;
            while (i < n) {
                o = new Integer(i);
                this.sc1.send(o);
                ++i;
            }
            i = 0;
            while (i < n) {
                o = new Integer(i);
                SocketChannelTest.assertEquals((Object)o, (Object)this.sc2.receive());
                ++i;
            }
        }
        catch (IOException e) {
            SocketChannelTest.fail((String)("Exception" + e));
        }
        catch (ClassNotFoundException e) {
            SocketChannelTest.fail((String)("Exception" + e));
        }
    }
}

