/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.SocketChannel;
import edu.jas.util.TaggedSocketChannel;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class TaggedSocketChannelTest
extends TestCase {
    private ChannelFactory cf;
    private SocketChannel sc1;
    private SocketChannel sc2;
    private TaggedSocketChannel tsc1;
    private TaggedSocketChannel tsc2;
    private String host;
    private int port;
    final Integer tag1 = new Integer(1);

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)TaggedSocketChannelTest.suite());
    }

    public TaggedSocketChannelTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TaggedSocketChannelTest.class);
        return suite;
    }

    protected void setUp() {
        this.host = "localhost";
        this.port = 4711;
        this.cf = new ChannelFactory(this.port);
        this.cf.init();
        try {
            this.sc1 = this.cf.getChannel(this.host, this.port);
            this.sc2 = this.cf.getChannel();
            this.tsc1 = new TaggedSocketChannel(this.sc1);
            this.tsc1.init();
            this.tsc2 = new TaggedSocketChannel(this.sc2);
            this.tsc2.init();
        }
        catch (IOException e) {
            TaggedSocketChannelTest.fail((String)("IOException" + e));
        }
        catch (InterruptedException e) {
            TaggedSocketChannelTest.fail((String)("InterruptedException" + e));
        }
    }

    protected void tearDown() {
        this.cf.terminate();
        this.tsc1.close();
        this.tsc2.close();
        this.sc1.close();
        this.sc2.close();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            TaggedSocketChannelTest.fail((String)("InterruptedException" + e));
        }
    }

    public void testTaggedSocketChannel0() {
    }

    public void testTaggedSocketChannel1() {
        IllegalArgumentException o = new IllegalArgumentException("leer");
        Integer err = new Integer(-1);
        try {
            this.tsc1.send(err, o);
            TaggedSocketChannelTest.fail((String)"no Exception thrown");
        }
        catch (IOException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        err = null;
        try {
            this.tsc1.send(err, o);
            TaggedSocketChannelTest.fail((String)"no Exception thrown");
        }
        catch (IOException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTaggedSocketChannel2() {
        Integer o = new Integer(0);
        try {
            this.tsc1.send(this.tag1, o);
            TaggedSocketChannelTest.assertEquals((Object)o, (Object)this.tsc2.receive(this.tag1));
        }
        catch (IOException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
        catch (InterruptedException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
        catch (ClassNotFoundException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
    }

    public void testTaggedSocketChannel3() {
        Integer o = new Integer(0);
        try {
            this.tsc1.send(this.tag1, o);
            this.tsc2.send(this.tag1, o);
            TaggedSocketChannelTest.assertEquals((Object)o, (Object)this.tsc1.receive(this.tag1));
            TaggedSocketChannelTest.assertEquals((Object)o, (Object)this.tsc2.receive(this.tag1));
        }
        catch (IOException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
        catch (InterruptedException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
        catch (ClassNotFoundException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
    }

    public void testTaggedSocketChannel4() {
        int n = 10;
        try {
            Integer o;
            int i = 0;
            while (i < n) {
                o = new Integer(i);
                this.tsc1.send(this.tag1, o);
                ++i;
            }
            TaggedSocketChannelTest.assertEquals((String)"#tags == 0 ", (int)0, (int)this.tsc1.tagSize());
            i = 0;
            while (i < n) {
                o = new Integer(i);
                TaggedSocketChannelTest.assertEquals((Object)o, (Object)this.tsc2.receive(this.tag1));
                ++i;
            }
            TaggedSocketChannelTest.assertTrue((String)"#tags == 1 ", (this.tsc2.tagSize() == 1 ? 1 : 0) != 0);
            TaggedSocketChannelTest.assertTrue((String)"#messages == 0 ", (this.tsc1.messages() == 0 ? 1 : 0) != 0);
            TaggedSocketChannelTest.assertTrue((String)"#messages == 0 ", (this.tsc2.messages() == 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
        catch (InterruptedException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
        catch (ClassNotFoundException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
    }

    public void testTaggedSocketChannel5() {
        int n = 10;
        String msg = "Hello_";
        try {
            Integer o;
            int i = 0;
            while (i < n) {
                o = new Integer(i);
                this.tsc1.send(o, String.valueOf(msg) + i);
                ++i;
            }
            TaggedSocketChannelTest.assertTrue((String)"#tags == 0 ", (this.tsc1.tagSize() == 0 ? 1 : 0) != 0);
            TaggedSocketChannelTest.assertTrue((String)"#messages == 0 ", (this.tsc1.messages() == 0 ? 1 : 0) != 0);
            TaggedSocketChannelTest.assertTrue((String)"#messages >= 0 ", (this.tsc2.messages() >= 0 ? 1 : 0) != 0);
            i = 0;
            while (i < n) {
                o = new Integer(i);
                TaggedSocketChannelTest.assertEquals((Object)(String.valueOf(msg) + i), (Object)this.tsc2.receive(o));
                ++i;
            }
            TaggedSocketChannelTest.assertTrue((String)"#tags == 10 ", (this.tsc2.tagSize() == 10 ? 1 : 0) != 0);
            TaggedSocketChannelTest.assertTrue((String)"#messages == 0 ", (this.tsc2.messages() <= 1 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
        catch (InterruptedException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
        catch (ClassNotFoundException e) {
            TaggedSocketChannelTest.fail((String)("Exception" + e));
        }
    }
}

