/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class Terminator {
    private static final Logger logger = Logger.getLogger(Terminator.class);
    private int workers = 0;
    private int idler = 0;
    private final Semaphore fin = new Semaphore(0);

    public Terminator(int workers) {
        this.workers = workers;
        logger.info((Object)("constructor, workers = " + workers));
    }

    public String toString() {
        return "Terminator(workers=" + this.workers + ",idler=" + this.idler + ")";
    }

    public synchronized void beIdle() {
        ++this.idler;
        logger.debug((Object)("beIdle, idler = " + this.idler));
        if (this.idler >= this.workers) {
            this.fin.release();
        }
    }

    public synchronized void initIdle(int i) {
        this.idler += i;
        logger.info((Object)("initIdle, idler = " + this.idler));
        if (this.idler > this.workers) {
            throw new RuntimeException("idler > workers");
        }
    }

    public synchronized void beIdle(int i) {
        this.idler += i;
        logger.debug((Object)("beIdle, idler = " + this.idler));
        if (this.idler >= this.workers) {
            this.fin.release();
        }
    }

    public synchronized void allIdle() {
        this.idler = this.workers;
        this.fin.release();
    }

    public synchronized void notIdle() {
        --this.idler;
        logger.info((Object)("notIdle, idler = " + this.idler));
        if (this.idler < 0) {
            throw new RuntimeException("idler < 0");
        }
    }

    public synchronized int getJobs() {
        return this.workers - this.idler;
    }

    public boolean hasJobs() {
        return this.idler < this.workers;
    }

    public synchronized void release() {
        logger.info((Object)("release = " + this));
        if (this.idler >= this.workers) {
            this.fin.release();
        }
    }

    public void waitDone() {
        try {
            this.fin.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        logger.info((Object)("waitDone " + this));
    }
}

