/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.PoolThread;
import edu.jas.util.StrategyEnumeration;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ThreadPool {
    static final int DEFAULT_SIZE = 3;
    final int size;
    protected PoolThread[] workers;
    protected int idleworkers = 0;
    protected volatile boolean shutdown = false;
    protected LinkedList<Runnable> jobstack;
    protected StrategyEnumeration strategy = StrategyEnumeration.LIFO;
    private static final Logger logger = Logger.getLogger(ThreadPool.class);
    private static boolean debug = logger.isDebugEnabled();

    public ThreadPool() {
        this(StrategyEnumeration.FIFO, 3);
    }

    public ThreadPool(StrategyEnumeration strategy) {
        this(strategy, 3);
    }

    public ThreadPool(int size) {
        this(StrategyEnumeration.FIFO, size);
    }

    public ThreadPool(StrategyEnumeration strategy, int size) {
        this.size = size;
        this.strategy = strategy;
        this.jobstack = new LinkedList();
        this.workers = new PoolThread[0];
    }

    public void init() {
        if (this.workers == null || this.workers.length == 0) {
            this.workers = new PoolThread[this.size];
            int i = 0;
            while (i < this.workers.length) {
                this.workers[i] = new PoolThread(this);
                this.workers[i].start();
                ++i;
            }
            logger.info((Object)("size = " + this.size + ", strategy = " + this.strategy));
        }
    }

    public String toString() {
        return "ThreadPool( size=" + this.getNumber() + ", idle=" + this.idleworkers + ", " + this.getStrategy() + ", jobs=" + this.jobstack.size() + ")";
    }

    public int getNumber() {
        if (this.workers == null || this.workers.length < this.size) {
            this.init();
        }
        return this.workers.length;
    }

    public StrategyEnumeration getStrategy() {
        return this.strategy;
    }

    /*
     * Exception decompiling
     */
    public void terminate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int cancel() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void addJob(Runnable job) {
        if (this.workers == null || this.workers.length < this.size) {
            this.init();
        }
        this.jobstack.addLast(job);
        logger.debug((Object)"adding job");
        if (this.idleworkers > 0) {
            logger.debug((Object)"notifying a jobless worker");
            this.notifyAll();
        }
    }

    protected synchronized Runnable getJob() throws InterruptedException {
        while (this.jobstack.isEmpty()) {
            ++this.idleworkers;
            logger.debug((Object)"waiting");
            this.wait();
            --this.idleworkers;
            if (!this.shutdown) continue;
            throw new InterruptedException("shutdown in getJob");
        }
        if (this.strategy == StrategyEnumeration.LIFO) {
            return this.jobstack.removeLast();
        }
        return this.jobstack.removeFirst();
    }

    public boolean hasJobs() {
        if (this.jobstack.size() > 0) {
            return true;
        }
        int i = 0;
        while (i < this.workers.length) {
            if (this.workers[i].isWorking) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasJobs(int n) {
        int j = this.jobstack.size();
        if (j > 0 && j + this.workers.length > n) {
            return true;
        }
        int x = 0;
        int i = 0;
        while (i < this.workers.length) {
            if (this.workers[i].isWorking) {
                ++x;
            }
            ++i;
        }
        return j + x > n;
    }
}

