/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.FastWorker;
import edu.jas.util.SlowWorker;
import edu.jas.util.StrategyEnumeration;
import edu.jas.util.ThreadPool;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ThreadPoolTest
extends TestCase {
    static final int JOBS = 10;
    private ThreadPool p1;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ThreadPoolTest.suite());
    }

    public ThreadPoolTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ThreadPoolTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        this.p1.terminate();
    }

    public void testThreadPool1() {
        this.p1 = new ThreadPool(0);
        ThreadPoolTest.assertTrue((String)"not empty pool ", (this.p1.getNumber() == 0 ? 1 : 0) != 0);
    }

    public void testThreadPool2() {
        this.p1 = new ThreadPool(1);
        ThreadPoolTest.assertTrue((String)"# empty pool ", (this.p1.getNumber() == 1 ? 1 : 0) != 0);
        this.p1.terminate();
        this.p1 = new ThreadPool();
        ThreadPoolTest.assertTrue((String)"# empty pool ", (this.p1.getNumber() == 3 ? 1 : 0) != 0);
        this.p1.terminate();
        this.p1 = new ThreadPool(10);
        ThreadPoolTest.assertTrue((String)"# empty pool ", (this.p1.getNumber() == 10 ? 1 : 0) != 0);
        this.p1.terminate();
    }

    public void testThreadPool3() {
        this.p1 = new ThreadPool();
        ThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.p1.hasJobs());
        ThreadPoolTest.assertFalse((String)"more than 0 jobs ", (boolean)this.p1.hasJobs(0));
        this.p1.terminate();
    }

    public void testThreadPool4() {
        this.p1 = new ThreadPool();
        ThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.p1.hasJobs());
        int i = 0;
        while (i < 10 * this.p1.getNumber()) {
            this.p1.addJob(new FastWorker());
            ++i;
        }
        boolean j = this.p1.hasJobs();
        ThreadPoolTest.assertTrue((String)"more than 0 jobs ", (boolean)true);
        this.p1.terminate();
        ThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.p1.hasJobs());
    }

    public void testThreadPool5() {
        this.p1 = new ThreadPool();
        ThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.p1.hasJobs());
        int i = 0;
        while (i < 10 * this.p1.getNumber()) {
            this.p1.addJob(new SlowWorker());
            ++i;
        }
        ThreadPoolTest.assertTrue((String)"more than 10 jobs ", (boolean)this.p1.hasJobs(10));
        this.p1.terminate();
        ThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.p1.hasJobs());
    }

    public void testThreadPool6() {
        this.p1 = new ThreadPool(StrategyEnumeration.LIFO);
        ThreadPoolTest.assertTrue((String)"FIFO strategy ", (this.p1.getStrategy() == StrategyEnumeration.LIFO ? 1 : 0) != 0);
    }

    public void testThreadPool7() {
        this.p1 = new ThreadPool(StrategyEnumeration.LIFO);
        ThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.p1.hasJobs());
        int i = 0;
        while (i < 10 * this.p1.getNumber()) {
            this.p1.addJob(new FastWorker());
            ++i;
        }
        boolean j = this.p1.hasJobs();
        ThreadPoolTest.assertTrue((String)"more than 0 jobs ", (boolean)true);
        this.p1.terminate();
        ThreadPoolTest.assertFalse((String)"no jobs ", (boolean)this.p1.hasJobs());
    }
}

