/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.vector.ModuleList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BasicLinAlg<C extends RingElem<C>> {
    private static final Logger logger = Logger.getLogger(BasicLinAlg.class);

    public GenPolynomial<C> scalarProduct(List<GenPolynomial<C>> r, List<GenPolynomial<C>> F2) {
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> sp = null;
        Iterator<GenPolynomial<C>> it = r.iterator();
        Iterator<GenPolynomial<C>> jt = F2.iterator();
        while (it.hasNext() && jt.hasNext()) {
            GenPolynomial<GenPolynomial<C>> pi = it.next();
            GenPolynomial<C> pj = jt.next();
            if (pi == null || pj == null) continue;
            sp = sp == null ? pi.multiply(pj) : sp.sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)pi.multiply(pj));
        }
        if (it.hasNext() || jt.hasNext()) {
            logger.error((Object)"scalarProduct wrong sizes");
        }
        return sp;
    }

    public List<GenPolynomial<C>> scalarProduct(List<GenPolynomial<C>> r, ModuleList<C> F2) {
        List<GenPolynomial<C>> ZZ = null;
        Iterator<GenPolynomial<C>> it = r.iterator();
        Iterator jt = F2.list.iterator();
        while (it.hasNext() && jt.hasNext()) {
            GenPolynomial<C> pi = it.next();
            List vj = jt.next();
            List<GenPolynomial<C>> Z = this.scalarProduct(pi, vj);
            ZZ = ZZ == null ? Z : this.vectorAdd(ZZ, Z);
        }
        if (it.hasNext() || jt.hasNext()) {
            logger.error((Object)"scalarProduct wrong sizes");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("scalarProduct" + ZZ));
        }
        return ZZ;
    }

    public List<GenPolynomial<C>> vectorAdd(List<GenPolynomial<C>> a, List<GenPolynomial<C>> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<GenPolynomial<C>> V = new ArrayList<GenPolynomial<C>>(a.size());
        Iterator<GenPolynomial<C>> it = a.iterator();
        Iterator<GenPolynomial<C>> jt = b.iterator();
        while (it.hasNext() && jt.hasNext()) {
            GenPolynomial<GenPolynomial<C>> pi = it.next();
            GenPolynomial<C> pj = jt.next();
            GenPolynomial<GenPolynomial<C>> p = pi.sum(pj);
            V.add(p);
        }
        if (it.hasNext() || jt.hasNext()) {
            logger.error((Object)"vectorAdd wrong sizes");
        }
        return V;
    }

    public boolean isZero(List<GenPolynomial<C>> a) {
        if (a == null) {
            return true;
        }
        for (GenPolynomial<C> pi : a) {
            if (pi == null || pi.isZERO()) continue;
            return false;
        }
        return true;
    }

    public List<GenPolynomial<C>> scalarProduct(GenPolynomial<C> p, List<GenPolynomial<C>> F2) {
        ArrayList<GenPolynomial<C>> V = new ArrayList<GenPolynomial<C>>(F2.size());
        for (GenPolynomial<Object> pi : F2) {
            pi = p != null ? p.multiply(pi) : null;
            V.add(pi);
        }
        return V;
    }

    /*
     * WARNING - void declaration
     */
    public List<GenPolynomial<C>> scalarProduct(List<GenPolynomial<C>> F2, GenPolynomial<C> p) {
        ArrayList<GenPolynomial<C>> V = new ArrayList<GenPolynomial<C>>(F2.size());
        for (GenPolynomial<GenPolynomial<C>> genPolynomial : F2) {
            void var4_5;
            if (genPolynomial != null) {
                GenPolynomial<GenPolynomial<C>> genPolynomial2 = genPolynomial.multiply(p);
            }
            V.add((GenPolynomial<C>)var4_5);
        }
        return V;
    }
}

