/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.kern.PrettyPrint;
import edu.jas.structure.AlgebraElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenMatrixRing;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class GenMatrix<C extends RingElem<C>>
implements AlgebraElem<GenMatrix<C>, C> {
    private static final Logger logger = Logger.getLogger(GenMatrix.class);
    public final GenMatrixRing<C> ring;
    public final ArrayList<ArrayList<C>> matrix;
    private int hashValue = 0;

    public GenMatrix(GenMatrixRing<C> r) {
        this(r, ((GenMatrix)r.getZERO()).matrix);
    }

    public GenMatrix(GenMatrixRing<C> r, List<List<C>> m) {
        this.ring = r;
        this.matrix = new ArrayList(r.rows);
        for (List<C> row : m) {
            ArrayList<C> nr = new ArrayList<C>(row);
            this.matrix.add(nr);
        }
    }

    public GenMatrix(GenMatrixRing<C> r, ArrayList<ArrayList<C>> m) {
        if (r == null || m == null) {
            throw new IllegalArgumentException("Empty r or m not allowed, r = " + r + ", m = " + m);
        }
        this.ring = r;
        this.matrix = m;
    }

    public C get(int i, int j) {
        return (C)((RingElem)this.matrix.get(i).get(j));
    }

    public void setMutate(int i, int j, C el) {
        ArrayList<C> ri = this.matrix.get(i);
        ri.set(j, el);
        this.hashValue = 0;
    }

    public GenMatrix<C> set(int i, int j, C el) {
        Object mat = this.clone();
        ((GenMatrix)mat).setMutate(i, j, el);
        return mat;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        boolean firstRow = true;
        s.append("[\n");
        for (List list : this.matrix) {
            if (firstRow) {
                firstRow = false;
            } else {
                s.append(",\n");
            }
            boolean first = true;
            s.append("[ ");
            for (RingElem c : list) {
                if (first) {
                    first = false;
                } else {
                    s.append(", ");
                }
                s.append(c.toString());
            }
            s.append(" ]");
        }
        s.append(" ] ");
        if (!PrettyPrint.isTrue()) {
            s.append(":: " + this.ring.toString());
            s.append("\n");
        }
        return s.toString();
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer();
        boolean firstRow = true;
        s.append("( ");
        for (List list : this.matrix) {
            if (firstRow) {
                firstRow = false;
            } else {
                s.append(", ");
            }
            boolean first = true;
            s.append("( ");
            for (RingElem c : list) {
                if (first) {
                    first = false;
                } else {
                    s.append(", ");
                }
                s.append(c.toScript());
            }
            s.append(" )");
        }
        s.append(" ) ");
        return s.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((GenMatrixRing)this.factory()).toScript();
    }

    @Override
    public GenMatrixRing<C> factory() {
        return this.ring;
    }

    public GenMatrix<C> clone() {
        ArrayList<ArrayList<C>> m = new ArrayList<ArrayList<C>>(this.ring.rows);
        for (ArrayList<C> val : this.matrix) {
            ArrayList v = (ArrayList)val.clone();
            m.add(v);
        }
        return new GenMatrix<C>(this.ring, m);
    }

    @Override
    public boolean isZERO() {
        return this.compareTo((GenMatrix<C>)this.ring.getZERO()) == 0;
    }

    @Override
    public boolean isONE() {
        return this.compareTo((GenMatrix<C>)this.ring.getONE()) == 0;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GenMatrix)) {
            return false;
        }
        GenMatrix om = (GenMatrix)other;
        if (!this.ring.equals(om.ring)) {
            return false;
        }
        return this.matrix.equals(om.matrix);
    }

    @Override
    public int hashCode() {
        if (this.hashValue == 0) {
            this.hashValue = 37 * this.matrix.hashCode() + this.ring.hashCode();
            if (this.hashValue == 0) {
                this.hashValue = 1;
            }
        }
        return this.hashValue;
    }

    @Override
    public int compareTo(GenMatrix<C> b) {
        if (!this.ring.equals(b.ring)) {
            return -1;
        }
        ArrayList<ArrayList<C>> om = b.matrix;
        int i = 0;
        for (ArrayList<C> val : this.matrix) {
            ArrayList<C> ov = om.get(i++);
            int j = 0;
            for (RingElem c : val) {
                int s = c.compareTo((RingElem)ov.get(j++));
                if (s == 0) continue;
                return s;
            }
        }
        return 0;
    }

    @Override
    public boolean isUnit() {
        int i = 0;
        for (ArrayList<C> val : this.matrix) {
            int j = 0;
            for (RingElem el : val) {
                if (i == j ? !el.isUnit() : !el.isZERO()) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int signum() {
        return this.compareTo((GenMatrix<C>)this.ring.getZERO());
    }

    @Override
    public GenMatrix<C> sum(GenMatrix<C> b) {
        ArrayList<ArrayList<C>> om = b.matrix;
        ArrayList<ArrayList<C>> m = new ArrayList<ArrayList<C>>(this.ring.rows);
        int i = 0;
        for (ArrayList<C> val : this.matrix) {
            ArrayList<C> ov = om.get(i++);
            ArrayList<RingElem> v = new ArrayList<RingElem>(this.ring.cols);
            int j = 0;
            for (RingElem c : val) {
                RingElem e = c.sum((RingElem)ov.get(j++));
                v.add(e);
            }
            m.add(v);
        }
        return new GenMatrix<C>(this.ring, m);
    }

    @Override
    public GenMatrix<C> subtract(GenMatrix<C> b) {
        ArrayList<ArrayList<C>> om = b.matrix;
        ArrayList<ArrayList<C>> m = new ArrayList<ArrayList<C>>(this.ring.rows);
        int i = 0;
        for (ArrayList<C> val : this.matrix) {
            ArrayList<C> ov = om.get(i++);
            ArrayList<RingElem> v = new ArrayList<RingElem>(this.ring.cols);
            int j = 0;
            for (RingElem c : val) {
                RingElem e = c.subtract((RingElem)ov.get(j++));
                v.add(e);
            }
            m.add(v);
        }
        return new GenMatrix<C>(this.ring, m);
    }

    @Override
    public GenMatrix<C> negate() {
        ArrayList<ArrayList<C>> m = new ArrayList<ArrayList<C>>(this.ring.rows);
        for (ArrayList<C> val : this.matrix) {
            ArrayList<RingElem> v = new ArrayList<RingElem>(this.ring.cols);
            for (RingElem c : val) {
                RingElem e = (RingElem)c.negate();
                v.add(e);
            }
            m.add(v);
        }
        return new GenMatrix<C>(this.ring, m);
    }

    @Override
    public GenMatrix<C> abs() {
        if (this.signum() < 0) {
            return this.negate();
        }
        return this;
    }

    @Override
    public GenMatrix<C> scalarMultiply(C s) {
        ArrayList<ArrayList<C>> m = new ArrayList<ArrayList<C>>(this.ring.rows);
        for (ArrayList<C> val : this.matrix) {
            ArrayList<RingElem> v = new ArrayList<RingElem>(this.ring.cols);
            for (RingElem c : val) {
                RingElem e = (RingElem)c.multiply(s);
                v.add(e);
            }
            m.add(v);
        }
        return new GenMatrix<C>(this.ring, m);
    }

    public GenMatrix<C> leftScalarMultiply(C s) {
        ArrayList<ArrayList<C>> m = new ArrayList<ArrayList<C>>(this.ring.rows);
        for (ArrayList<C> val : this.matrix) {
            ArrayList<RingElem> v = new ArrayList<RingElem>(this.ring.cols);
            for (RingElem c : val) {
                RingElem e = s.multiply((RingElem)c);
                v.add(e);
            }
            m.add(v);
        }
        return new GenMatrix<C>(this.ring, m);
    }

    @Override
    public GenMatrix<C> linearCombination(C s, GenMatrix<C> b, C t) {
        ArrayList<ArrayList<C>> om = b.matrix;
        ArrayList<ArrayList<C>> m = new ArrayList<ArrayList<C>>(this.ring.rows);
        int i = 0;
        for (ArrayList<C> val : this.matrix) {
            ArrayList<C> ov = om.get(i++);
            ArrayList<RingElem> v = new ArrayList<RingElem>(this.ring.cols);
            int j = 0;
            for (RingElem c : val) {
                RingElem c1 = (RingElem)c.multiply(s);
                RingElem c2 = (RingElem)((RingElem)ov.get(j++)).multiply(t);
                RingElem e = c1.sum(c2);
                v.add(e);
            }
            m.add(v);
        }
        return new GenMatrix<C>(this.ring, m);
    }

    @Override
    public GenMatrix<C> linearCombination(GenMatrix<C> b, C t) {
        ArrayList<ArrayList<C>> om = b.matrix;
        ArrayList<ArrayList<C>> m = new ArrayList<ArrayList<C>>(this.ring.rows);
        int i = 0;
        for (ArrayList<C> val : this.matrix) {
            ArrayList<C> ov = om.get(i++);
            ArrayList<RingElem> v = new ArrayList<RingElem>(this.ring.cols);
            int j = 0;
            for (RingElem c : val) {
                RingElem c2 = (RingElem)((RingElem)ov.get(j++)).multiply(t);
                RingElem e = c.sum(c2);
                v.add(e);
            }
            m.add(v);
        }
        return new GenMatrix<C>(this.ring, m);
    }

    @Override
    public GenMatrix<C> linearCombination(C t, GenMatrix<C> b) {
        ArrayList<ArrayList<C>> om = b.matrix;
        ArrayList<ArrayList<C>> m = new ArrayList<ArrayList<C>>(this.ring.rows);
        int i = 0;
        for (ArrayList<C> val : this.matrix) {
            ArrayList<C> ov = om.get(i++);
            ArrayList<RingElem> v = new ArrayList<RingElem>(this.ring.cols);
            int j = 0;
            for (RingElem c : val) {
                RingElem c2 = t.multiply((RingElem)((RingElem)ov.get(j++)));
                RingElem e = c.sum(c2);
                v.add(e);
            }
            m.add(v);
        }
        return new GenMatrix<C>(this.ring, m);
    }

    public GenMatrix<C> leftLinearCombination(C s, C t, GenMatrix<C> b) {
        ArrayList<ArrayList<C>> om = b.matrix;
        ArrayList<ArrayList<C>> m = new ArrayList<ArrayList<C>>(this.ring.rows);
        int i = 0;
        for (ArrayList<C> val : this.matrix) {
            ArrayList<C> ov = om.get(i++);
            ArrayList<RingElem> v = new ArrayList<RingElem>(this.ring.cols);
            int j = 0;
            for (RingElem c : val) {
                RingElem c1 = s.multiply((RingElem)c);
                RingElem c2 = t.multiply((RingElem)((RingElem)ov.get(j++)));
                RingElem e = c1.sum(c2);
                v.add(e);
            }
            m.add(v);
        }
        return new GenMatrix<C>(this.ring, m);
    }

    public GenMatrix<C> transpose(GenMatrixRing<C> tr) {
        Object t = ((GenMatrix)tr.getZERO()).clone();
        ArrayList<ArrayList<C>> m = ((GenMatrix)t).matrix;
        int i = 0;
        for (ArrayList<C> val : this.matrix) {
            int j = 0;
            for (RingElem c : val) {
                m.get(j).set(i, c);
                ++j;
            }
            ++i;
        }
        return t;
    }

    @Override
    public GenMatrix<C> multiply(GenMatrix<C> S) {
        int na = this.ring.blocksize;
        int nb = this.ring.blocksize;
        ArrayList<ArrayList<C>> m = this.matrix;
        GenMatrixRing<C> tr = S.ring.transpose();
        GenMatrix<C> T = S.transpose(tr);
        ArrayList<ArrayList<C>> t = T.matrix;
        GenMatrixRing<C> pr = this.ring.product(S.ring);
        Object P = ((GenMatrix)pr.getZERO()).clone();
        ArrayList<ArrayList<C>> p = ((GenMatrix)P).matrix;
        int ii = 0;
        while (ii < m.size()) {
            int jj = 0;
            while (jj < t.size()) {
                int i = ii;
                while (i < Math.min(ii + na, m.size())) {
                    ArrayList<C> Ai = m.get(i);
                    int j = jj;
                    while (j < Math.min(jj + nb, t.size())) {
                        ArrayList<C> Bj = t.get(j);
                        RingElem c = (RingElem)this.ring.coFac.getZERO();
                        int k = 0;
                        while (k < Bj.size()) {
                            c = c.sum(((RingElem)Ai.get(k)).multiply((RingElem)Bj.get(k)));
                            ++k;
                        }
                        p.get(i).set(j, c);
                        ++j;
                    }
                    ++i;
                }
                jj += nb;
            }
            ii += na;
        }
        return new GenMatrix<C>(pr, p);
    }

    public GenMatrix<C> multiplySimple(GenMatrix<C> S) {
        ArrayList<ArrayList<C>> m = this.matrix;
        ArrayList<ArrayList<C>> B = S.matrix;
        GenMatrixRing<C> pr = this.ring.product(S.ring);
        Object P = ((GenMatrix)pr.getZERO()).clone();
        ArrayList<ArrayList<C>> p = ((GenMatrix)P).matrix;
        int i = 0;
        while (i < pr.rows) {
            ArrayList<C> Ai = m.get(i);
            int j = 0;
            while (j < pr.cols) {
                RingElem c = (RingElem)this.ring.coFac.getZERO();
                int k = 0;
                while (k < S.ring.rows) {
                    c = c.sum(((RingElem)Ai.get(k)).multiply((RingElem)B.get(k).get(j)));
                    ++k;
                }
                p.get(i).set(j, c);
                ++j;
            }
            ++i;
        }
        return new GenMatrix<C>(pr, p);
    }

    @Override
    public GenMatrix<C> divide(GenMatrix<C> S) {
        throw new UnsupportedOperationException("divide not jet implemented");
    }

    @Override
    public GenMatrix<C> remainder(GenMatrix<C> S) {
        throw new UnsupportedOperationException("remainder not implemented");
    }

    @Override
    public GenMatrix<C> inverse() {
        throw new UnsupportedOperationException("inverse not jet implemented");
    }

    @Override
    public GenMatrix<C> gcd(GenMatrix<C> b) {
        throw new UnsupportedOperationException("gcd not implemented");
    }

    public GenMatrix<C>[] egcd(GenMatrix<C> b) {
        throw new UnsupportedOperationException("egcd not implemented");
    }
}

