/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.AlgebraElem;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenMatrixTest
extends TestCase {
    int rl = 5;
    int kl = 10;
    int ll = 10;
    float q = 0.5f;
    int rows = 3;
    int cols = 3;

    public static void main(String[] args) {
        TestRunner.run((Test)GenMatrixTest.suite());
    }

    public GenMatrixTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GenMatrixTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testConstruction() {
        BigRational cfac = new BigRational(1L);
        GenMatrixRing<BigRational> mfac = new GenMatrixRing<BigRational>(cfac, this.rows, this.cols);
        GenMatrixTest.assertTrue((String)("#rows = " + this.rows), (mfac.rows == this.rows ? 1 : 0) != 0);
        GenMatrixTest.assertTrue((String)("#columns = " + this.cols), (mfac.cols == this.cols ? 1 : 0) != 0);
        GenMatrixTest.assertTrue((String)"cfac == coFac ", (cfac == mfac.coFac ? 1 : 0) != 0);
        Element a = mfac.getZERO();
        GenMatrixTest.assertTrue((String)"isZERO( a )", (boolean)((GenMatrix)a).isZERO());
        GenMatrix<BigRational> b = new GenMatrix<BigRational>(mfac);
        GenMatrixTest.assertTrue((String)"isZERO( b )", (boolean)b.isZERO());
        GenMatrixTest.assertTrue((String)"a == b ", (boolean)((GenMatrix)a).equals(b));
        Object c = b.clone();
        GenMatrixTest.assertTrue((String)"isZERO( c )", (boolean)((GenMatrix)c).isZERO());
        GenMatrixTest.assertTrue((String)"a == c ", (boolean)((GenMatrix)a).equals(c));
        GenMatrix<BigRational> d = mfac.copy(b);
        GenMatrixTest.assertTrue((String)"isZERO( d )", (boolean)d.isZERO());
        GenMatrixTest.assertTrue((String)"a == d ", (boolean)((GenMatrix)a).equals(d));
        a = mfac.getONE();
        GenMatrixTest.assertTrue((String)"isONE( a )", (boolean)((GenMatrix)a).isONE());
    }

    public void testRandom() {
        BigRational cfac = new BigRational(1L);
        GenMatrixRing<BigRational> mfac = new GenMatrixRing<BigRational>(cfac, this.rows, this.cols);
        GenMatrixRing<BigRational> tfac = mfac.transpose();
        if (this.rows == this.cols) {
            GenMatrixTest.assertTrue((String)" mfac = tfac ", (boolean)mfac.equals(tfac));
        }
        int i = 0;
        while (i < 5) {
            AlgebraElem a = mfac.random(this.kl, this.q);
            if (!((GenMatrix)a).isZERO()) {
                GenMatrixTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!((GenMatrix)a).isZERO() ? 1 : 0) != 0);
                GenMatrix<BigRational> b = ((GenMatrix)a).transpose(tfac);
                GenMatrixTest.assertTrue((String)(" not isZERO( b" + i + " )"), (!b.isZERO() ? 1 : 0) != 0);
                GenMatrix<BigRational> c = b.transpose(mfac);
                GenMatrixTest.assertEquals((String)" a^r^r == a ", (Object)a, c);
            }
            ++i;
        }
    }

    public void testAddition() {
        BigRational cfac = new BigRational(1L);
        GenMatrixRing<BigRational> mfac = new GenMatrixRing<BigRational>(cfac, this.rows, this.cols);
        AlgebraElem a = mfac.random(this.kl, this.q);
        AlgebraElem b = mfac.random(this.kl, this.q);
        AlgebraElem c = ((GenMatrix)a).sum(b);
        GenMatrix d = c.subtract(b);
        GenMatrixTest.assertEquals((String)"a+b-b = a", (Object)a, d);
        c = ((GenMatrix)a).sum(b);
        d = c.sum(((GenMatrix)b).negate());
        GenMatrixTest.assertEquals((String)"a+b+(-b) = a", (Object)a, d);
        c = ((GenMatrix)a).sum(b);
        d = ((GenMatrix)b).sum(a);
        GenMatrixTest.assertEquals((String)"a+b = b+a", c, d);
        c = mfac.random(this.kl, this.q);
        d = ((GenMatrix)a).sum(b).sum(c);
        GenMatrix e = ((GenMatrix)a).sum(((GenMatrix)b).sum(c));
        GenMatrixTest.assertEquals((String)"a+(b+c) = (a+b)+c", d, e);
    }

    public void testScalarMultiplication() {
        BigRational cfac = new BigRational(1L);
        GenMatrixRing<BigRational> mfac = new GenMatrixRing<BigRational>(cfac, this.rows, this.cols);
        BigRational r = cfac.random(this.kl);
        BigRational s = r.inverse();
        AlgebraElem a = mfac.random(this.kl, this.q);
        GenMatrix<BigRational> c = ((GenMatrix)a).scalarMultiply(r);
        GenMatrix<BigRational> d = c.scalarMultiply((RingElem)s);
        GenMatrixTest.assertEquals((String)"a*b*(1/b) = a", (Object)a, (Object)d);
        AlgebraElem b = mfac.random(this.kl, this.q);
        BigRational t = cfac.getONE();
        c = ((GenMatrix)a).linearCombination(b, t);
        d = ((GenMatrix)b).linearCombination(a, t);
        GenMatrixTest.assertEquals((String)"a+1*b = b+1*a", c, d);
        c = ((GenMatrix)a).linearCombination(b, t);
        d = ((GenMatrix)a).sum(b);
        GenMatrixTest.assertEquals((String)"a+1*b = b+1*a", c, d);
        s = t.negate();
        c = ((GenMatrix)a).linearCombination(b, t);
        d = c.linearCombination((GenMatrix<BigRational>)b, s);
        GenMatrixTest.assertEquals((String)"a+1*b+(-1)*b = a", (Object)a, d);
        c = ((GenMatrix)a).linearCombination(t, b, t);
        d = c.linearCombination(t, (GenMatrix<BigRational>)b, s);
        GenMatrixTest.assertEquals((String)"a*1+b*1+b*(-1) = a", (Object)a, d);
        t = cfac.getZERO();
        c = ((GenMatrix)a).linearCombination(b, t);
        GenMatrixTest.assertEquals((String)"a+0*b = a", (Object)a, c);
        d = ((GenMatrix)a).linearCombination(t, b, t);
        GenMatrixTest.assertEquals((String)"0*a+0*b = 0", (Object)mfac.getZERO(), d);
    }

    public void testSimpleMultiplication() {
        BigRational cfac = new BigRational(1L);
        GenMatrixRing<BigRational> mfac = new GenMatrixRing<BigRational>(cfac, this.rows, this.cols);
        Element a = mfac.getZERO();
        Element b = mfac.getZERO();
        AlgebraElem c = ((GenMatrix)a).multiplySimple(b);
        GenMatrixTest.assertTrue((String)"0*0 = 0 ", (boolean)c.isZERO());
        a = mfac.getONE();
        b = mfac.getONE();
        c = ((GenMatrix)a).multiplySimple(b);
        GenMatrixTest.assertTrue((String)"1*1 = 1 ", (boolean)c.isONE());
        a = mfac.random(this.kl, this.q);
        b = mfac.getONE();
        c = ((GenMatrix)a).multiplySimple(b);
        GenMatrix d = ((GenMatrix)a).multiply(b);
        GenMatrixTest.assertEquals((String)"a*1 = a ", a, c);
        GenMatrixTest.assertEquals((String)"a*1 = a*1 ", c, d);
        c = ((GenMatrix)b).multiplySimple(a);
        d = ((GenMatrix)a).multiply(b);
        GenMatrixTest.assertEquals((String)"1*a = a ", a, c);
        GenMatrixTest.assertEquals((String)"a*1 = a*1 ", c, d);
        b = mfac.random(this.kl, this.q);
        long s = System.currentTimeMillis();
        c = ((GenMatrix)a).multiplySimple(b);
        s = System.currentTimeMillis() - s;
        d = ((GenMatrix)b).multiplySimple(a);
        long t = System.currentTimeMillis();
        GenMatrix e = ((GenMatrix)a).multiply(b);
        t = System.currentTimeMillis() - t;
        GenMatrix f = ((GenMatrix)b).multiply(a);
        GenMatrixTest.assertTrue((String)"a*b != b*a ", (!c.equals(d) ? 1 : 0) != 0);
        GenMatrixTest.assertEquals((String)"a*1 = a*1 ", c, e);
        GenMatrixTest.assertEquals((String)"a*1 = a*1 ", d, f);
        if (!mfac.isAssociative()) {
            return;
        }
        c = mfac.random(this.kl, this.q);
        d = ((GenMatrix)a).multiply(((GenMatrix)b).sum(c));
        e = ((GenMatrix)a).multiply(b).sum(((GenMatrix)a).multiply(c));
        GenMatrixTest.assertEquals((String)"a*(b+c) = a*b+a*c", d, e);
        d = ((GenMatrix)a).multiply(((GenMatrix)b).multiply(c));
        e = ((GenMatrix)a).multiply(b).multiply(c);
        GenMatrixTest.assertEquals((String)"a*(b*c) = (a*b)*c", d, e);
    }

    public void testPolynomialConstruction() {
        BigRational cfac = new BigRational(1L);
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, this.rl);
        GenMatrixRing<BigRational> mfac = new GenMatrixRing<BigRational>(pfac, this.rows, this.cols);
        GenMatrixTest.assertTrue((String)("#rows = " + this.rows), (mfac.rows == this.rows ? 1 : 0) != 0);
        GenMatrixTest.assertTrue((String)("#columns = " + this.cols), (mfac.cols == this.cols ? 1 : 0) != 0);
        GenMatrixTest.assertTrue((String)"pfac == coFac ", (pfac == mfac.coFac ? 1 : 0) != 0);
        AbelianGroupElem a = mfac.getZERO();
        GenMatrixTest.assertTrue((String)"isZERO( a )", (boolean)((GenMatrix)a).isZERO());
        GenMatrix<BigRational> b = new GenMatrix<BigRational>(mfac);
        GenMatrixTest.assertTrue((String)"isZERO( b )", (boolean)b.isZERO());
        GenMatrixTest.assertTrue((String)"a == b ", (boolean)((GenMatrix)a).equals(b));
        Object c = b.clone();
        GenMatrixTest.assertTrue((String)"isZERO( c )", (boolean)((GenMatrix)c).isZERO());
        GenMatrixTest.assertTrue((String)"a == c ", (boolean)((GenMatrix)a).equals(c));
        GenMatrix<BigRational> d = mfac.copy(b);
        GenMatrixTest.assertTrue((String)"isZERO( d )", (boolean)d.isZERO());
        GenMatrixTest.assertTrue((String)"a == d ", (boolean)((GenMatrix)a).equals(d));
    }

    public void testPolynomialRandom() {
        BigRational cfac = new BigRational(1L);
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, this.rl);
        GenMatrixRing<BigRational> mfac = new GenMatrixRing<BigRational>(pfac, this.rows, this.cols);
        int i = 0;
        while (i < 5) {
            AlgebraElem a = mfac.random(this.kl, this.q);
            if (!((GenMatrix)a).isZERO()) {
                GenMatrixTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!((GenMatrix)a).isZERO() ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testPolynomialAddition() {
        BigRational cfac = new BigRational(1L);
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, this.rl);
        GenMatrixRing<BigRational> mfac = new GenMatrixRing<BigRational>(pfac, this.rows, this.cols);
        AlgebraElem a = mfac.random(this.kl, this.q);
        AlgebraElem b = mfac.random(this.kl, this.q);
        AlgebraElem c = ((GenMatrix)a).sum(b);
        GenMatrix d = c.subtract(b);
        GenMatrixTest.assertEquals((String)"a+b-b = a", (Object)a, d);
        c = ((GenMatrix)a).sum(b);
        d = c.sum(((GenMatrix)b).negate());
        GenMatrixTest.assertEquals((String)"a+b+(-b) = a", (Object)a, d);
        c = ((GenMatrix)a).sum(b);
        d = ((GenMatrix)b).sum(a);
        GenMatrixTest.assertEquals((String)"a+b = b+a", c, d);
        c = mfac.random(this.kl, this.q);
        d = ((GenMatrix)a).sum(b).sum(c);
        GenMatrix e = ((GenMatrix)a).sum(((GenMatrix)b).sum(c));
        GenMatrixTest.assertEquals((String)"a+(b+c) = (a+b)+c", d, e);
    }

    public void testPolynomialMultiplication() {
        BigRational cfac = new BigRational(1L);
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, this.rl);
        GenMatrixRing<BigRational> mfac = new GenMatrixRing<BigRational>(pfac, this.rows, this.cols);
        Element r = pfac.random(this.kl);
        AbelianGroupElem s = ((GenPolynomial)r).negate();
        AlgebraElem a = mfac.random(this.kl, this.q);
        GenMatrix<MonoidElem> c = ((GenMatrix)a).scalarMultiply((RingElem)r);
        GenMatrix d = ((GenMatrix)a).scalarMultiply((RingElem)s);
        GenMatrix e = c.sum(d);
        GenMatrixTest.assertEquals((String)"a*b + a*(-b) = 0", e, (Object)mfac.getZERO());
        AlgebraElem b = mfac.random(this.kl, this.q);
        Element t = pfac.getONE();
        c = ((GenMatrix)a).linearCombination(b, t);
        d = ((GenMatrix)b).linearCombination(a, t);
        GenMatrixTest.assertEquals((String)"a+1*b = b+1*a", c, d);
        c = ((GenMatrix)a).linearCombination(b, t);
        d = ((GenMatrix)a).sum(b);
        GenMatrixTest.assertEquals((String)"a+1*b = b+1*a", c, d);
        s = ((GenPolynomial)t).negate();
        c = ((GenMatrix)a).linearCombination(b, t);
        d = c.linearCombination((GenMatrix<MonoidElem>)b, (MonoidElem)((Object)s));
        GenMatrixTest.assertEquals((String)"a+1*b+(-1)*b = a", (Object)a, d);
        c = ((GenMatrix)a).linearCombination(t, b, t);
        d = c.linearCombination((MonoidElem)t, (GenMatrix<MonoidElem>)b, (MonoidElem)((Object)s));
        GenMatrixTest.assertEquals((String)"a+1*b+(-1)*b = a", (Object)a, d);
        t = pfac.getZERO();
        c = ((GenMatrix)a).linearCombination(b, t);
        GenMatrixTest.assertEquals((String)"a+0*b = a", (Object)a, c);
        d = ((GenMatrix)a).linearCombination(t, b, t);
        GenMatrixTest.assertEquals((String)"0*a+0*b = 0", (Object)mfac.getZERO(), d);
    }

    public void testParse() {
        BigRational cfac = new BigRational(1L);
        GenMatrixRing<BigRational> mfac = new GenMatrixRing<BigRational>(cfac, this.rows, this.cols);
        AlgebraElem a = mfac.random(this.kl, this.q);
        if (!((GenMatrix)a).isZERO()) {
            GenMatrixTest.assertTrue((String)" not isZERO( a )", (!((GenMatrix)a).isZERO() ? 1 : 0) != 0);
        }
        String s = ((GenMatrix)a).toString();
        Element c = mfac.parse(s);
        GenMatrixTest.assertEquals((String)"parse(toStirng(a) == a ", (Object)a, (Object)c);
    }
}

