/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.kern.PrettyPrint;
import edu.jas.structure.ModulElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenVectorModul;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class GenVector<C extends RingElem<C>>
implements ModulElem<GenVector<C>, C> {
    private static final Logger logger = Logger.getLogger(GenVector.class);
    public final GenVectorModul<C> modul;
    public final List<C> val;

    public GenVector(GenVectorModul<C> m) {
        this(m, ((GenVector)m.getZERO()).val);
    }

    public GenVector(GenVectorModul<C> m, List<C> v) {
        if (m == null || v == null) {
            throw new IllegalArgumentException("Empty m or v not allowed, m = " + m + ", v = " + v);
        }
        this.modul = m;
        this.val = v;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[ ");
        boolean first = true;
        for (RingElem c : this.val) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(c.toString());
        }
        s.append(" ]");
        if (!PrettyPrint.isTrue()) {
            s.append(" :: " + this.modul.toString());
            s.append("\n");
        }
        return s.toString();
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer();
        s.append("( ");
        boolean first = true;
        for (RingElem c : this.val) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(c.toScript());
        }
        s.append(" )");
        return s.toString();
    }

    @Override
    public String toScriptFactory() {
        return ((GenVectorModul)this.factory()).toScript();
    }

    @Override
    public GenVectorModul<C> factory() {
        return this.modul;
    }

    public GenVector<C> clone() {
        ArrayList av = (ArrayList)this.val;
        return new GenVector<C>(this.modul, (List)av.clone());
    }

    @Override
    public boolean isZERO() {
        return this.compareTo((GenVector<C>)this.modul.getZERO()) == 0;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GenVector)) {
            return false;
        }
        GenVector ovec = (GenVector)other;
        if (!this.modul.equals(ovec.modul)) {
            return false;
        }
        return this.val.equals(ovec.val);
    }

    @Override
    public int hashCode() {
        return 37 * this.val.hashCode() + this.modul.hashCode();
    }

    @Override
    public int compareTo(GenVector<C> b) {
        if (!this.modul.equals(b.modul)) {
            return -1;
        }
        List<C> oval = b.val;
        int i = 0;
        for (RingElem c : this.val) {
            int s = c.compareTo((RingElem)oval.get(i++));
            if (s == 0) continue;
            return s;
        }
        return 0;
    }

    @Override
    public int signum() {
        return this.compareTo((GenVector<C>)this.modul.getZERO());
    }

    @Override
    public GenVector<C> sum(GenVector<C> b) {
        List<C> oval = b.val;
        ArrayList<RingElem> a = new ArrayList<RingElem>(this.modul.cols);
        int i = 0;
        for (RingElem c : this.val) {
            RingElem e = c.sum((RingElem)oval.get(i++));
            a.add(e);
        }
        return new GenVector<C>(this.modul, a);
    }

    @Override
    public GenVector<C> subtract(GenVector<C> b) {
        List<C> oval = b.val;
        ArrayList<RingElem> a = new ArrayList<RingElem>(this.modul.cols);
        int i = 0;
        for (RingElem c : this.val) {
            RingElem e = c.subtract((RingElem)oval.get(i++));
            a.add(e);
        }
        return new GenVector<C>(this.modul, a);
    }

    @Override
    public GenVector<C> negate() {
        ArrayList<RingElem> a = new ArrayList<RingElem>(this.modul.cols);
        for (RingElem c : this.val) {
            RingElem e = (RingElem)c.negate();
            a.add(e);
        }
        return new GenVector<C>(this.modul, a);
    }

    @Override
    public GenVector<C> abs() {
        if (this.signum() < 0) {
            return this.negate();
        }
        return this;
    }

    @Override
    public GenVector<C> scalarMultiply(C s) {
        ArrayList<RingElem> a = new ArrayList<RingElem>(this.modul.cols);
        for (RingElem c : this.val) {
            RingElem e = (RingElem)c.multiply(s);
            a.add(e);
        }
        return new GenVector<C>(this.modul, a);
    }

    public GenVector<C> leftScalarMultiply(C s) {
        ArrayList<RingElem> a = new ArrayList<RingElem>(this.modul.cols);
        for (RingElem c : this.val) {
            RingElem e = s.multiply((RingElem)c);
            a.add(e);
        }
        return new GenVector<C>(this.modul, a);
    }

    @Override
    public GenVector<C> linearCombination(C s, GenVector<C> b, C t) {
        List<C> oval = b.val;
        ArrayList<RingElem> a = new ArrayList<RingElem>(this.modul.cols);
        int i = 0;
        for (RingElem c : this.val) {
            RingElem c1 = (RingElem)c.multiply(s);
            RingElem c2 = (RingElem)((RingElem)oval.get(i++)).multiply(t);
            RingElem e = c1.sum(c2);
            a.add(e);
        }
        return new GenVector<C>(this.modul, a);
    }

    @Override
    public GenVector<C> linearCombination(GenVector<C> b, C t) {
        List<C> oval = b.val;
        ArrayList<RingElem> a = new ArrayList<RingElem>(this.modul.cols);
        int i = 0;
        for (RingElem c : this.val) {
            RingElem c2 = (RingElem)((RingElem)oval.get(i++)).multiply(t);
            RingElem e = c.sum(c2);
            a.add(e);
        }
        return new GenVector<C>(this.modul, a);
    }

    @Override
    public GenVector<C> linearCombination(C t, GenVector<C> b) {
        List<C> oval = b.val;
        ArrayList<RingElem> a = new ArrayList<RingElem>(this.modul.cols);
        int i = 0;
        for (RingElem c : this.val) {
            RingElem c2 = t.multiply((RingElem)((RingElem)oval.get(i++)));
            RingElem e = c.sum(c2);
            a.add(e);
        }
        return new GenVector<C>(this.modul, a);
    }

    public GenVector<C> leftLinearCombination(C s, C t, GenVector<C> b) {
        List<C> oval = b.val;
        ArrayList<RingElem> a = new ArrayList<RingElem>(this.modul.cols);
        int i = 0;
        for (RingElem c : this.val) {
            RingElem c1 = s.multiply((RingElem)c);
            RingElem c2 = t.multiply((RingElem)((RingElem)oval.get(i++)));
            RingElem e = c1.sum(c2);
            a.add(e);
        }
        return new GenVector<C>(this.modul, a);
    }

    @Override
    public C scalarProduct(GenVector<C> b) {
        RingElem a = (RingElem)this.modul.coFac.getZERO();
        List<C> oval = b.val;
        int i = 0;
        for (RingElem c : this.val) {
            RingElem c2 = c.multiply((RingElem)oval.get(i++));
            a = a.sum(c2);
        }
        return (C)a;
    }

    @Override
    public GenVector<C> scalarProduct(List<GenVector<C>> B) {
        GenVector<RingElem> A = this.modul.getZERO();
        int i = 0;
        for (RingElem c : this.val) {
            GenVector<RingElem> b = B.get(i++);
            GenVector<RingElem> a = b.leftScalarMultiply(c);
            A = A.sum(a);
        }
        return A;
    }

    public GenVector<C> rightScalarProduct(List<GenVector<C>> B) {
        GenVector<C> A = this.modul.getZERO();
        int i = 0;
        for (RingElem c : this.val) {
            GenVector<C> b = B.get(i++);
            ModulElem a = b.scalarMultiply(c);
            A = A.sum((GenVector<C>)a);
        }
        return A;
    }
}

