/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.kern.StringUtil;
import edu.jas.structure.ModulFactory;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.vector.GenVector;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class GenVectorModul<C extends RingElem<C>>
implements ModulFactory<GenVector<C>, C> {
    private static final Logger logger = Logger.getLogger(GenVectorModul.class);
    public final RingFactory<C> coFac;
    public final int cols;
    public final GenVector<C> ZERO;
    public final List<GenVector<C>> BASIS;
    private static final Random random = new Random();
    public static final float DEFAULT_DENSITY = 0.5f;
    private final float density = 0.5f;

    public GenVectorModul(RingFactory<C> b, int s) {
        this.coFac = b;
        this.cols = s;
        ArrayList<RingElem> z = new ArrayList<RingElem>(this.cols);
        int i = 0;
        while (i < this.cols) {
            z.add((RingElem)this.coFac.getZERO());
            ++i;
        }
        this.ZERO = new GenVector(this, z);
        this.BASIS = new ArrayList<GenVector<C>>(this.cols);
        List cgens = this.coFac.generators();
        int i2 = 0;
        while (i2 < this.cols) {
            for (RingElem g : cgens) {
                ArrayList v = (ArrayList)z.clone();
                v.set(i2, g);
                this.BASIS.add(new GenVector(this, v));
            }
            ++i2;
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.coFac.getClass().getSimpleName());
        s.append("[" + this.cols + "]");
        return s.toString();
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer("Vec(");
        String f = null;
        try {
            f = ((RingElem)((Object)this.coFac)).toScriptFactory();
        }
        catch (Exception e) {
            f = this.coFac.toScript();
        }
        s.append(String.valueOf(f) + "," + this.cols + " )");
        return s.toString();
    }

    @Override
    public GenVector<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public List<GenVector<C>> generators() {
        return this.BASIS;
    }

    @Override
    public boolean isFinite() {
        return this.coFac.isFinite();
    }

    public boolean equals(Object other) {
        if (!(other instanceof GenVectorModul)) {
            return false;
        }
        GenVectorModul omod = (GenVectorModul)other;
        if (this.cols != omod.cols) {
            return false;
        }
        return this.coFac.equals(omod.coFac);
    }

    public int hashCode() {
        int h = this.cols;
        h = 37 * h + this.coFac.hashCode();
        return h;
    }

    @Override
    public GenVector<C> fromInteger(long a) {
        RingElem c = (RingElem)this.coFac.fromInteger(a);
        return this.BASIS.get(0).scalarMultiply(c);
    }

    @Override
    public GenVector<C> fromInteger(BigInteger a) {
        RingElem c = (RingElem)this.coFac.fromInteger(a);
        return this.BASIS.get(0).scalarMultiply(c);
    }

    @Override
    public GenVector<C> fromList(List<C> v) {
        if (v == null) {
            return this.ZERO;
        }
        if (v.size() > this.cols) {
            throw new IllegalArgumentException("size v > cols " + v + " > " + this.cols);
        }
        ArrayList<Object> r = new ArrayList<Object>(this.cols);
        r.addAll(v);
        int i = r.size();
        while (i < this.cols) {
            r.add((RingElem)this.coFac.getZERO());
            ++i;
        }
        return new GenVector(this, r);
    }

    @Override
    public GenVector<C> random(int k) {
        return this.random(k, 0.5f, random);
    }

    @Override
    public GenVector<C> random(int k, float q) {
        return this.random(k, q, random);
    }

    @Override
    public GenVector<C> random(int k, Random random) {
        return this.random(k, 0.5f, random);
    }

    public GenVector<C> random(int k, float q, Random random) {
        ArrayList<RingElem> r = new ArrayList<RingElem>(this.cols);
        int i = 0;
        while (i < this.cols) {
            if (random.nextFloat() < q) {
                r.add((RingElem)this.coFac.random(k));
            } else {
                r.add((RingElem)this.coFac.getZERO());
            }
            ++i;
        }
        return new GenVector(this, r);
    }

    @Override
    public GenVector<C> copy(GenVector<C> c) {
        if (c == null) {
            return c;
        }
        return c.clone();
    }

    @Override
    public GenVector<C> parse(String s) {
        RingElem c;
        int i = s.indexOf("[");
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        if ((i = s.indexOf("]")) >= 0) {
            s = s.substring(0, i);
        }
        ArrayList<RingElem> vec = new ArrayList<RingElem>(this.cols);
        do {
            if ((i = s.indexOf(",")) < 0) continue;
            String e = s.substring(0, i);
            s = s.substring(i + 1);
            c = (RingElem)this.coFac.parse(e);
            vec.add(c);
        } while (i >= 0);
        if (s.trim().length() > 0) {
            c = (RingElem)this.coFac.parse(s);
            vec.add(c);
        }
        return new GenVector(this, vec);
    }

    @Override
    public GenVector<C> parse(Reader r) {
        String s = StringUtil.nextPairedString(r, '[', ']');
        return this.parse(s);
    }
}

