/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.ModulElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GenVectorTest
extends TestCase {
    int rl = 5;
    int kl = 10;
    int ll = 10;
    float q = 0.5f;

    public static void main(String[] args) {
        TestRunner.run((Test)GenVectorTest.suite());
    }

    public GenVectorTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(GenVectorTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testConstruction() {
        BigRational cfac = new BigRational(1L);
        GenVectorModul<BigRational> mfac = new GenVectorModul<BigRational>(cfac, this.ll);
        GenVectorTest.assertTrue((String)("#columns = " + this.ll), (mfac.cols == this.ll ? 1 : 0) != 0);
        GenVectorTest.assertTrue((String)"cfac == coFac ", (cfac == mfac.coFac ? 1 : 0) != 0);
        AbelianGroupElem a = mfac.getZERO();
        GenVectorTest.assertTrue((String)"isZERO( a )", (boolean)((GenVector)a).isZERO());
        GenVector<BigRational> b = new GenVector<BigRational>(mfac);
        GenVectorTest.assertTrue((String)"isZERO( b )", (boolean)b.isZERO());
        GenVectorTest.assertTrue((String)"a == b ", (boolean)((GenVector)a).equals(b));
        Object c = b.clone();
        GenVectorTest.assertTrue((String)"isZERO( c )", (boolean)((GenVector)c).isZERO());
        GenVectorTest.assertTrue((String)"a == c ", (boolean)((GenVector)a).equals(c));
        GenVector<BigRational> d = mfac.copy(b);
        GenVectorTest.assertTrue((String)"isZERO( d )", (boolean)d.isZERO());
        GenVectorTest.assertTrue((String)"a == d ", (boolean)((GenVector)a).equals(d));
    }

    public void testRandom() {
        BigRational cfac = new BigRational(1L);
        GenVectorModul<BigRational> mfac = new GenVectorModul<BigRational>(cfac, this.ll);
        int i = 0;
        while (i < 7) {
            ModulElem a = mfac.random(this.kl, this.q);
            if (!((GenVector)a).isZERO()) {
                GenVectorTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!((GenVector)a).isZERO() ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testAddition() {
        BigRational cfac = new BigRational(1L);
        GenVectorModul<BigRational> mfac = new GenVectorModul<BigRational>(cfac, this.ll);
        ModulElem a = mfac.random(this.kl, this.q);
        ModulElem b = mfac.random(this.kl, this.q);
        ModulElem c = ((GenVector)a).sum(b);
        GenVector d = c.subtract(b);
        GenVectorTest.assertEquals((String)"a+b-b = a", (Object)a, d);
        c = ((GenVector)a).sum(b);
        d = c.sum(((GenVector)b).negate());
        GenVectorTest.assertEquals((String)"a+b+(-b) = a", (Object)a, d);
        c = ((GenVector)a).sum(b);
        d = ((GenVector)b).sum(a);
        GenVectorTest.assertEquals((String)"a+b = b+a", c, d);
        c = mfac.random(this.kl, this.q);
        d = ((GenVector)a).sum(b).sum(c);
        GenVector e = ((GenVector)a).sum(((GenVector)b).sum(c));
        GenVectorTest.assertEquals((String)"a+(b+c) = (a+b)+c", d, e);
    }

    public void testMultiplication() {
        BigRational cfac = new BigRational(1L);
        GenVectorModul<BigRational> mfac = new GenVectorModul<BigRational>(cfac, this.ll);
        BigRational r = cfac.random(this.kl);
        if (r.isZERO()) {
            r = cfac.getONE();
        }
        BigRational s = r.inverse();
        ModulElem a = mfac.random(this.kl, this.q);
        GenVector<BigRational> c = ((GenVector)a).scalarMultiply(r);
        GenVector<BigRational> d = c.scalarMultiply((RingElem)s);
        GenVectorTest.assertEquals((String)("a*b*(1/b) = a " + r), (Object)a, (Object)d);
        ModulElem b = mfac.random(this.kl, this.q);
        BigRational t = cfac.getONE();
        c = ((GenVector)a).linearCombination(b, t);
        d = ((GenVector)b).linearCombination(a, t);
        GenVectorTest.assertEquals((String)"a+1*b = b+1*a", c, d);
        c = ((GenVector)a).linearCombination(b, t);
        d = ((GenVector)a).sum(b);
        GenVectorTest.assertEquals((String)"a+1*b = b+1*a", c, d);
        s = t.negate();
        c = ((GenVector)a).linearCombination(b, t);
        d = c.linearCombination((GenVector<BigRational>)b, s);
        GenVectorTest.assertEquals((String)"a+1*b+(-1)*b = a", (Object)a, d);
        c = ((GenVector)a).linearCombination(t, b, t);
        d = c.linearCombination(t, (GenVector<BigRational>)b, s);
        GenVectorTest.assertEquals((String)"a*1+b*1+b*(-1) = a", (Object)a, d);
        t = cfac.getZERO();
        c = ((GenVector)a).linearCombination(b, t);
        GenVectorTest.assertEquals((String)"a+0*b = a", (Object)a, c);
        d = ((GenVector)a).linearCombination(t, b, t);
        GenVectorTest.assertEquals((String)"0*a+0*b = 0", (Object)mfac.getZERO(), d);
        r = (BigRational)((GenVector)a).scalarProduct(b);
        s = (BigRational)((GenVector)b).scalarProduct(a);
        GenVectorTest.assertEquals((String)"a.b = b.a", (Object)r, (Object)s);
    }

    public void testPolynomialConstruction() {
        BigRational cfac = new BigRational(1L);
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, this.rl);
        GenVectorModul<BigRational> mfac = new GenVectorModul<BigRational>(pfac, this.ll);
        GenVectorTest.assertTrue((String)("#columns = " + this.ll), (mfac.cols == this.ll ? 1 : 0) != 0);
        GenVectorTest.assertTrue((String)"pfac == coFac ", (pfac == mfac.coFac ? 1 : 0) != 0);
        AbelianGroupElem a = mfac.getZERO();
        GenVectorTest.assertTrue((String)"isZERO( a )", (boolean)((GenVector)a).isZERO());
        GenVector<BigRational> b = new GenVector<BigRational>(mfac);
        GenVectorTest.assertTrue((String)"isZERO( b )", (boolean)b.isZERO());
        GenVectorTest.assertTrue((String)"a == b ", (boolean)((GenVector)a).equals(b));
        Object c = b.clone();
        GenVectorTest.assertTrue((String)"isZERO( c )", (boolean)((GenVector)c).isZERO());
        GenVectorTest.assertTrue((String)"a == c ", (boolean)((GenVector)a).equals(c));
        GenVector<BigRational> d = mfac.copy(b);
        GenVectorTest.assertTrue((String)"isZERO( d )", (boolean)d.isZERO());
        GenVectorTest.assertTrue((String)"a == d ", (boolean)((GenVector)a).equals(d));
    }

    public void testPolynomialRandom() {
        BigRational cfac = new BigRational(1L);
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, this.rl);
        GenVectorModul<BigRational> mfac = new GenVectorModul<BigRational>(pfac, this.ll);
        int i = 0;
        while (i < 7) {
            ModulElem a = mfac.random(this.kl, this.q);
            GenVectorTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!((GenVector)a).isZERO() ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testPolynomialAddition() {
        BigRational cfac = new BigRational(1L);
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, this.rl);
        GenVectorModul<BigRational> mfac = new GenVectorModul<BigRational>(pfac, this.ll);
        ModulElem a = mfac.random(this.kl, this.q);
        ModulElem b = mfac.random(this.kl, this.q);
        ModulElem c = ((GenVector)a).sum(b);
        GenVector d = c.subtract(b);
        GenVectorTest.assertEquals((String)"a+b-b = a", (Object)a, d);
        c = ((GenVector)a).sum(b);
        d = c.sum(((GenVector)b).negate());
        GenVectorTest.assertEquals((String)"a+b+(-b) = a", (Object)a, d);
        c = ((GenVector)a).sum(b);
        d = ((GenVector)b).sum(a);
        GenVectorTest.assertEquals((String)"a+b = b+a", c, d);
        c = mfac.random(this.kl, this.q);
        d = ((GenVector)a).sum(b).sum(c);
        GenVector e = ((GenVector)a).sum(((GenVector)b).sum(c));
        GenVectorTest.assertEquals((String)"a+(b+c) = (a+b)+c", d, e);
    }

    public void testPolynomialMultiplication() {
        BigRational cfac = new BigRational(1L);
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, this.rl);
        GenVectorModul<BigRational> mfac = new GenVectorModul<BigRational>(pfac, this.ll);
        Element r = pfac.random(this.kl);
        AbelianGroupElem s = ((GenPolynomial)r).negate();
        ModulElem a = mfac.random(this.kl, this.q);
        GenVector<MonoidElem> c = ((GenVector)a).scalarMultiply((RingElem)r);
        GenVector d = ((GenVector)a).scalarMultiply((RingElem)s);
        GenVector e = c.sum(d);
        GenVectorTest.assertEquals((String)"a*b + a*(-b) = 0", e, (Object)mfac.getZERO());
        ModulElem b = mfac.random(this.kl, this.q);
        Element t = pfac.getONE();
        c = ((GenVector)a).linearCombination(b, t);
        d = ((GenVector)b).linearCombination(a, t);
        GenVectorTest.assertEquals((String)"a+1*b = b+1*a", c, d);
        c = ((GenVector)a).linearCombination(b, t);
        d = ((GenVector)a).sum(b);
        GenVectorTest.assertEquals((String)"a+1*b = b+1*a", c, d);
        s = ((GenPolynomial)t).negate();
        c = ((GenVector)a).linearCombination(b, t);
        d = c.linearCombination((GenVector<MonoidElem>)b, (MonoidElem)((Object)s));
        GenVectorTest.assertEquals((String)"a+1*b+(-1)*b = a", (Object)a, d);
        c = ((GenVector)a).linearCombination(t, b, t);
        d = c.linearCombination((MonoidElem)t, (GenVector<MonoidElem>)b, (MonoidElem)((Object)s));
        GenVectorTest.assertEquals((String)"a+1*b+(-1)*b = a", (Object)a, d);
        t = pfac.getZERO();
        c = ((GenVector)a).linearCombination(b, t);
        GenVectorTest.assertEquals((String)"a+0*b = a", (Object)a, c);
        d = ((GenVector)a).linearCombination(t, b, t);
        GenVectorTest.assertEquals((String)"0*a+0*b = 0", (Object)mfac.getZERO(), d);
        r = (GenPolynomial)((GenVector)a).scalarProduct(b);
        s = (GenPolynomial)((GenVector)b).scalarProduct(a);
        GenVectorTest.assertEquals((String)"a.b = b.a", (Object)r, (Object)s);
    }

    public void testParse() {
        BigRational cfac = new BigRational(1L);
        GenVectorModul<BigRational> mfac = new GenVectorModul<BigRational>(cfac, this.ll);
        ModulElem a = mfac.random(this.kl, this.q);
        if (!((GenVector)a).isZERO()) {
            GenVectorTest.assertTrue((String)" not isZERO( a )", (!((GenVector)a).isZERO() ? 1 : 0) != 0);
        }
        String s = ((GenVector)a).toString();
        Element c = mfac.parse(s);
        GenVectorTest.assertEquals((String)"parse(toStirng(a) == a ", (Object)a, (Object)c);
    }
}

