/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.RingElem;
import edu.jas.vector.ModuleList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SolvableBasicLinAlg<C extends RingElem<C>> {
    private static final Logger logger = Logger.getLogger(SolvableBasicLinAlg.class);

    public GenSolvablePolynomial<C> leftScalarProduct(List<GenSolvablePolynomial<C>> r, List<GenSolvablePolynomial<C>> F2) {
        GenSolvablePolynomial sp = null;
        Iterator<GenSolvablePolynomial<C>> it = r.iterator();
        Iterator<GenSolvablePolynomial<C>> jt = F2.iterator();
        while (it.hasNext() && jt.hasNext()) {
            GenSolvablePolynomial<GenSolvablePolynomial<C>> pi = it.next();
            GenSolvablePolynomial<C> pj = jt.next();
            if (pi == null || pj == null) continue;
            sp = sp == null ? pi.multiply(pj) : (GenSolvablePolynomial)sp.sum(pi.multiply(pj));
        }
        if (it.hasNext() || jt.hasNext()) {
            logger.error((Object)"scalarProduct wrong sizes");
        }
        return sp;
    }

    public List<GenSolvablePolynomial<C>> leftScalarProduct(List<GenSolvablePolynomial<C>> r, ModuleList<C> F2) {
        List<GenSolvablePolynomial<C>> ZZ = null;
        Iterator<GenSolvablePolynomial<C>> it = r.iterator();
        Iterator jt = F2.list.iterator();
        while (it.hasNext() && jt.hasNext()) {
            GenSolvablePolynomial<C> pi = it.next();
            List vj = jt.next();
            List<GenSolvablePolynomial<C>> Z = this.leftScalarProduct(pi, vj);
            ZZ = ZZ == null ? Z : this.vectorAdd(ZZ, Z);
        }
        if (it.hasNext() || jt.hasNext()) {
            logger.error((Object)"scalarProduct wrong sizes");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("scalarProduct" + ZZ));
        }
        return ZZ;
    }

    public List<GenSolvablePolynomial<C>> rightScalarProduct(List<GenSolvablePolynomial<C>> r, ModuleList<C> F2) {
        List ZZ = null;
        Iterator<GenSolvablePolynomial<C>> it = r.iterator();
        Iterator jt = F2.list.iterator();
        while (it.hasNext() && jt.hasNext()) {
            GenSolvablePolynomial<C> pi = it.next();
            List vj = jt.next();
            List Z = this.leftScalarProduct(vj, pi);
            ZZ = ZZ == null ? Z : this.vectorAdd(ZZ, Z);
        }
        if (it.hasNext() || jt.hasNext()) {
            logger.error((Object)"scalarProduct wrong sizes");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("scalarProduct" + ZZ));
        }
        return ZZ;
    }

    public List<GenSolvablePolynomial<C>> vectorAdd(List<GenSolvablePolynomial<C>> a, List<GenSolvablePolynomial<C>> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<GenSolvablePolynomial<C>> V = new ArrayList<GenSolvablePolynomial<C>>(a.size());
        Iterator<GenSolvablePolynomial<C>> it = a.iterator();
        Iterator<GenSolvablePolynomial<C>> jt = b.iterator();
        while (it.hasNext() && jt.hasNext()) {
            GenSolvablePolynomial<GenSolvablePolynomial<C>> pi = it.next();
            GenSolvablePolynomial<C> pj = jt.next();
            GenSolvablePolynomial p = (GenSolvablePolynomial)pi.sum(pj);
            V.add(p);
        }
        if (it.hasNext() || jt.hasNext()) {
            logger.error((Object)"vectorAdd wrong sizes");
        }
        return V;
    }

    public boolean isZero(List<GenSolvablePolynomial<C>> a) {
        if (a == null) {
            return true;
        }
        for (GenSolvablePolynomial<C> pi : a) {
            if (pi == null || pi.isZERO()) continue;
            return false;
        }
        return true;
    }

    public List<GenSolvablePolynomial<C>> leftScalarProduct(GenSolvablePolynomial<C> p, List<GenSolvablePolynomial<C>> F2) {
        ArrayList<GenSolvablePolynomial<C>> V = new ArrayList<GenSolvablePolynomial<C>>(F2.size());
        for (GenSolvablePolynomial<Object> pi : F2) {
            pi = p.multiply(pi);
            V.add(pi);
        }
        return V;
    }

    /*
     * WARNING - void declaration
     */
    public List<GenSolvablePolynomial<C>> leftScalarProduct(List<GenSolvablePolynomial<C>> F2, GenSolvablePolynomial<C> p) {
        ArrayList<GenSolvablePolynomial<C>> V = new ArrayList<GenSolvablePolynomial<C>>(F2.size());
        for (GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial : F2) {
            void var4_5;
            if (genSolvablePolynomial != null) {
                GenSolvablePolynomial<GenSolvablePolynomial<C>> genSolvablePolynomial2 = genSolvablePolynomial.multiply(p);
            }
            V.add((GenSolvablePolynomial<C>)var4_5);
        }
        return V;
    }
}

