/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.arith.BigRational;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.vector.ModuleList;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SolvableModuleListTest
extends TestCase {
    ModuleList<BigRational> m;
    PolynomialList<BigRational> p;
    GenSolvablePolynomial<BigRational> a;
    GenSolvablePolynomial<BigRational> b;
    GenSolvablePolynomial<BigRational> c;
    GenSolvablePolynomial<BigRational> d;
    GenSolvablePolynomial<BigRational> e;
    BigRational cfac;
    GenSolvablePolynomialRing<BigRational> pfac;
    int rl = 4;
    int kl = 4;
    int ll = 4;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] args) {
        TestRunner.run((Test)SolvableModuleListTest.suite());
    }

    public SolvableModuleListTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SolvableModuleListTest.class);
        return suite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cfac = new BigRational(1L);
        TermOrder tord = new TermOrder();
        this.pfac = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.rl, tord);
        this.m = null;
        this.p = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.m = null;
        this.p = null;
    }

    public void testConstructor() {
        this.p = new PolynomialList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, null);
        SolvableModuleListTest.assertTrue((String)"p = 0", (this.p.list == null ? 1 : 0) != 0);
        this.m = new ModuleList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, null);
        SolvableModuleListTest.assertTrue((String)"m = 0", (this.m.list == null ? 1 : 0) != 0);
    }

    public void testPolynomialList() {
        ArrayList l = new ArrayList();
        int i = 0;
        while (i < 7) {
            this.a = this.pfac.random(this.kl, this.ll + i, this.el, this.q);
            SolvableModuleListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            SolvableModuleListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            SolvableModuleListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            l.add(this.a);
            ++i;
        }
        this.p = new PolynomialList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, l);
        SolvableModuleListTest.assertTrue((String)"p == p", (boolean)this.p.equals(this.p));
        SolvableModuleListTest.assertEquals((String)"p.length", (int)7, (int)this.p.list.size());
    }

    public void testModuleList() {
        ArrayList l = new ArrayList();
        int i = 0;
        while (i < 4) {
            ArrayList<GenSolvablePolynomial<BigRational>> r = new ArrayList<GenSolvablePolynomial<BigRational>>();
            int j = 0;
            while (j < 3) {
                this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
                SolvableModuleListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
                r.add(this.a);
                ++j;
            }
            l.add(r);
            ++i;
        }
        this.m = new ModuleList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, l);
        SolvableModuleListTest.assertTrue((String)"m == m", (boolean)this.m.equals(this.m));
        SolvableModuleListTest.assertEquals((String)"m.length", (int)4, (int)this.m.list.size());
    }

    public void testModulePolynomialList() {
        ArrayList l = new ArrayList();
        int i = 0;
        while (i < 4) {
            ArrayList<GenSolvablePolynomial<BigRational>> r = new ArrayList<GenSolvablePolynomial<BigRational>>();
            int j = 0;
            while (j < 3) {
                this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
                SolvableModuleListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
                r.add(this.a);
                ++j;
            }
            l.add(r);
            ++i;
        }
        this.m = new ModuleList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, l);
        SolvableModuleListTest.assertTrue((String)"m == m", (boolean)this.m.equals(this.m));
        SolvableModuleListTest.assertEquals((String)"m.length", (int)4, (int)this.m.list.size());
        this.p = this.m.getPolynomialList();
        SolvableModuleListTest.assertTrue((String)"p == p", (boolean)this.p.equals(this.p));
        SolvableModuleListTest.assertEquals((String)"p.length", (int)4, (int)this.p.list.size());
    }

    public void testModulePolynomialModuleList() {
        ArrayList l = new ArrayList();
        int i = 0;
        while (i < 4) {
            ArrayList<GenSolvablePolynomial<BigRational>> r = new ArrayList<GenSolvablePolynomial<BigRational>>();
            int j = 0;
            while (j < 3) {
                this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
                SolvableModuleListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
                r.add(this.a);
                ++j;
            }
            l.add(r);
            ++i;
        }
        this.m = new ModuleList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, l);
        SolvableModuleListTest.assertTrue((String)"m == m", (boolean)this.m.equals(this.m));
        SolvableModuleListTest.assertEquals((String)"m.length", (int)4, (int)this.m.list.size());
        this.p = this.m.getPolynomialList();
        SolvableModuleListTest.assertTrue((String)"p == p", (boolean)this.p.equals(this.p));
        SolvableModuleListTest.assertEquals((String)"p.length", (int)4, (int)this.p.list.size());
        ModuleList<BigRational> m2 = null;
        m2 = this.p.getModuleList(3);
        SolvableModuleListTest.assertTrue((String)"m2 == m2", (boolean)m2.equals(m2));
        SolvableModuleListTest.assertEquals((String)"m2.length", (int)4, (int)m2.list.size());
        SolvableModuleListTest.assertTrue((String)"m == m2", (boolean)this.m.equals(m2));
    }

    public void testModulePolynomialModuleListPolynomial() {
        ArrayList l = new ArrayList();
        int i = 0;
        while (i < 4) {
            ArrayList<GenSolvablePolynomial<BigRational>> r = new ArrayList<GenSolvablePolynomial<BigRational>>();
            int j = 0;
            while (j < 3) {
                this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
                SolvableModuleListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
                r.add(this.a);
                ++j;
            }
            l.add(r);
            ++i;
        }
        this.m = new ModuleList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, l);
        SolvableModuleListTest.assertTrue((String)"m == m", (boolean)this.m.equals(this.m));
        SolvableModuleListTest.assertEquals((String)"m.length", (int)4, (int)this.m.list.size());
        this.p = this.m.getPolynomialList();
        SolvableModuleListTest.assertTrue((String)"p == p", (boolean)this.p.equals(this.p));
        SolvableModuleListTest.assertEquals((String)"p.length", (int)4, (int)this.p.list.size());
        ModuleList<BigRational> m2 = null;
        m2 = this.p.getModuleList(3);
        SolvableModuleListTest.assertTrue((String)"m2 == m2", (boolean)m2.equals(m2));
        SolvableModuleListTest.assertEquals((String)"m2.length", (int)4, (int)m2.list.size());
        SolvableModuleListTest.assertTrue((String)"m == m2", (boolean)this.m.equals(m2));
        PolynomialList<BigRational> p2 = null;
        p2 = m2.getPolynomialList();
        SolvableModuleListTest.assertTrue((String)"p2 == p2", (boolean)p2.equals(p2));
        SolvableModuleListTest.assertEquals((String)"p2.length", (int)4, (int)p2.list.size());
        SolvableModuleListTest.assertTrue((String)"p == p2", (boolean)this.p.list.equals(p2.list));
    }

    public void testWeylModulePolynomialModuleListPolynomial() {
        int rloc = 4;
        this.pfac = new GenSolvablePolynomialRing<BigRational>(this.cfac, rloc);
        WeylRelations<BigRational> wl = new WeylRelations<BigRational>(this.pfac);
        wl.generate();
        RelationTable table1 = this.pfac.table;
        RelationTable table2 = null;
        RelationTable table3 = null;
        RelationTable table4 = null;
        RelationTable table5 = null;
        ArrayList l = new ArrayList();
        int i = 0;
        while (i < 4) {
            ArrayList<GenSolvablePolynomial<BigRational>> r = new ArrayList<GenSolvablePolynomial<BigRational>>();
            int j = 0;
            while (j < 3) {
                this.a = this.pfac.random(this.kl, this.ll, this.el, this.q);
                SolvableModuleListTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
                SolvableModuleListTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
                r.add(this.a);
                ++j;
            }
            l.add(r);
            ++i;
        }
        this.m = new ModuleList<BigRational>((GenPolynomialRing<BigRational>)this.pfac, l);
        SolvableModuleListTest.assertTrue((String)"m == m", (boolean)this.m.equals(this.m));
        SolvableModuleListTest.assertEquals((String)"m.length", (int)4, (int)this.m.list.size());
        table2 = ((GenSolvablePolynomialRing)this.m.ring).table;
        SolvableModuleListTest.assertEquals((String)"table1 == table2", table1, table2);
        this.p = this.m.getPolynomialList();
        SolvableModuleListTest.assertTrue((String)"p == p", (boolean)this.p.equals(this.p));
        SolvableModuleListTest.assertEquals((String)"p.length", (int)4, (int)this.p.list.size());
        table3 = ((GenSolvablePolynomialRing)this.p.ring).table;
        ModuleList<BigRational> m2 = null;
        m2 = this.p.getModuleList(3);
        SolvableModuleListTest.assertTrue((String)"m2 == m2", (boolean)m2.equals(m2));
        SolvableModuleListTest.assertEquals((String)"m2.length", (int)4, (int)m2.list.size());
        SolvableModuleListTest.assertTrue((String)"m == m2", (boolean)this.m.equals(m2));
        table4 = ((GenSolvablePolynomialRing)m2.ring).table;
        SolvableModuleListTest.assertEquals((String)"table2 == table4", table2, table4);
        SolvableModuleListTest.assertEquals((String)"table1 == table4", table1, table4);
        PolynomialList<BigRational> p2 = null;
        p2 = m2.getPolynomialList();
        SolvableModuleListTest.assertTrue((String)"p2 == p2", (boolean)p2.equals(p2));
        SolvableModuleListTest.assertEquals((String)"p2.length", (int)4, (int)p2.list.size());
        SolvableModuleListTest.assertTrue((String)"p == p2", (boolean)this.p.list.equals(p2.list));
        table5 = ((GenSolvablePolynomialRing)p2.ring).table;
        SolvableModuleListTest.assertEquals((String)"table2 == table4", table3.table, table5.table);
    }
}

