/*
 * Decompiled with CFR 0.152.
 */
package edu.mas.kern;

import edu.jas.arith.BigRational;
import edu.mas.kern.LIST;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LISTTest
extends TestCase {
    boolean timing = false;

    public static void main(String[] args) {
        TestRunner.run((Test)LISTTest.suite());
    }

    public LISTTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(LISTTest.class);
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testLISTinit() {
        LIST a = null;
        LISTTest.assertTrue((String)"a == () ", (boolean)LIST.isEmpty(a));
        LISTTest.assertEquals((String)"len(a) == 0 ", (int)LIST.LENGTH(a), (int)0);
        a = new LIST();
        LISTTest.assertTrue((String)"a == () ", (boolean)LIST.isEmpty(a));
        LISTTest.assertEquals((String)"len(a) == 0 ", (int)LIST.LENGTH(a), (int)0);
        a = new LIST(a.list);
        LISTTest.assertTrue((String)"a == () ", (boolean)LIST.isEmpty(a));
        LISTTest.assertEquals((String)"len(a) == 0 ", (int)LIST.LENGTH(a), (int)0);
    }

    public void testLISTcreate() {
        Integer five = 5;
        LIST<Integer> a = null;
        LISTTest.assertTrue((String)"a == () ", (boolean)LIST.isEmpty(a));
        LISTTest.assertEquals((String)"len(a) == 0 ", (int)LIST.LENGTH(a), (int)0);
        a = LIST.LIST1(five);
        LISTTest.assertFalse((String)"a != () ", (boolean)LIST.isEmpty(a));
        LISTTest.assertEquals((String)"len(a) == 1 ", (int)LIST.LENGTH(a), (int)1);
        a = LIST.COMP(five, a);
        LISTTest.assertFalse((String)"a != () ", (boolean)LIST.isEmpty(a));
        LISTTest.assertEquals((String)"len(a) == 2 ", (int)LIST.LENGTH(a), (int)2);
        LIST<Integer> b = LIST.LIST2(five, five);
        LISTTest.assertFalse((String)"b != () ", (boolean)LIST.isEmpty(b));
        LISTTest.assertEquals((String)"len(a) == 2 ", (int)LIST.LENGTH(a), (int)2);
        LISTTest.assertTrue((String)"a == b ", (boolean)LIST.EQUAL(a, b));
    }

    public void testLISToper() {
        Integer five = 5;
        LIST<Integer> a = LIST.LIST1(five);
        LISTTest.assertFalse((String)"a != () ", (boolean)LIST.isEmpty(a));
        LISTTest.assertEquals((String)"len(a) == 1 ", (int)LIST.LENGTH(a), (int)1);
        a = LIST.COMP(five, a);
        LISTTest.assertFalse((String)"a != () ", (boolean)LIST.isEmpty(a));
        LISTTest.assertEquals((String)"len(a) == 2 ", (int)LIST.LENGTH(a), (int)2);
        LIST<Integer> b = LIST.CINV(a);
        LISTTest.assertFalse((String)"b != () ", (boolean)LIST.isEmpty(b));
        LISTTest.assertEquals((String)"len(a) == 2 ", (int)LIST.LENGTH(a), (int)2);
        LISTTest.assertTrue((String)"a == b ", (boolean)LIST.EQUAL(a, b));
        LIST<Integer> c = LIST.INV(a);
        LISTTest.assertFalse((String)"c != () ", (boolean)LIST.isEmpty(c));
        LISTTest.assertEquals((String)"len(c) == 2 ", (int)LIST.LENGTH(c), (int)2);
        LISTTest.assertTrue((String)"a == c ", (boolean)LIST.EQUAL(a, c));
    }

    public void testLISTelems() {
        int max = 100;
        LIST<Integer> a = null;
        int i = 0;
        while (i < max) {
            Integer n = i;
            a = LIST.COMP(n, a);
            ++i;
        }
        LISTTest.assertFalse((String)"a != () ", (boolean)LIST.isEmpty(a));
        LISTTest.assertEquals((String)("len(a) == " + max + " "), (int)LIST.LENGTH(a), (int)max);
        LIST<Integer> b = LIST.CINV(a);
        LISTTest.assertFalse((String)"b != () ", (boolean)LIST.isEmpty(b));
        LISTTest.assertEquals((String)("len(b) == " + max + " "), (int)LIST.LENGTH(b), (int)max);
        b = LIST.INV(b);
        LISTTest.assertFalse((String)"b != () ", (boolean)LIST.isEmpty(b));
        LISTTest.assertEquals((String)("len(b) == " + max + " "), (int)LIST.LENGTH(b), (int)max);
        LISTTest.assertTrue((String)"a == INV(CINV(a)) ", (boolean)LIST.EQUAL(a, b));
    }

    public void testLISTdestruct() {
        Integer n = 5;
        LIST<Integer> a = LIST.LIST1(n);
        LIST<Integer> b = LIST.LIST1(n);
        LISTTest.assertEquals((String)"len(a) == 1 ", (int)LIST.LENGTH(a), (int)1);
        LISTTest.assertEquals((String)"len(b) == 1 ", (int)LIST.LENGTH(b), (int)1);
        LIST.SRED(a, b);
        LISTTest.assertFalse((String)"a != () ", (boolean)LIST.isEmpty(a));
        LISTTest.assertFalse((String)"b != () ", (boolean)LIST.isEmpty(b));
        LISTTest.assertEquals((String)"len(b) == 1 ", (int)LIST.LENGTH(b), (int)1);
        LISTTest.assertEquals((String)"len(a) == 2 ", (int)LIST.LENGTH(a), (int)2);
        n = 7;
        LIST.SFIRST(a, n);
        LISTTest.assertEquals((String)"len(a) == 2 ", (int)LIST.LENGTH(a), (int)2);
        LIST<Integer> c = LIST.COMP(n, b);
        LISTTest.assertEquals((String)"len(c) == 2 ", (int)LIST.LENGTH(c), (int)2);
        LISTTest.assertTrue((String)"a == c ", (boolean)LIST.EQUAL(a, c));
    }

    public void testLISTrecursive() {
        Integer n = 5;
        LIST<Integer> a = LIST.LIST1(n);
        LIST<LIST<Integer>> b = LIST.LIST2(a, a);
        LIST<LIST<LIST<Integer>>> c = LIST.LIST3(b, b, b);
        LISTTest.assertEquals((String)"len(a) == 1 ", (int)LIST.LENGTH(a), (int)1);
        LISTTest.assertEquals((String)"len(b) == 2 ", (int)LIST.LENGTH(b), (int)2);
        LISTTest.assertEquals((String)"len(c) == 3 ", (int)LIST.LENGTH(c), (int)3);
        LISTTest.assertEquals((String)"EXTENT(a) == 1 ", (int)LIST.EXTENT(a), (int)1);
        LISTTest.assertEquals((String)"EXTENT(b) == 2 ", (int)LIST.EXTENT(b), (int)2);
        LISTTest.assertEquals((String)"EXTENT(c) == 6 ", (int)LIST.EXTENT(c), (int)6);
        LISTTest.assertEquals((String)"ORDER(a) == 1 ", (int)LIST.ORDER(a), (int)1);
        LISTTest.assertEquals((String)"ORDER(b) == 2 ", (int)LIST.ORDER(b), (int)2);
        LISTTest.assertEquals((String)"ORDER(c) == 3 ", (int)LIST.ORDER(c), (int)3);
    }

    public void testLISTcontent() {
        BigRational n;
        int max = 5000;
        BigRational cf = new BigRational(2L, 3L);
        LIST<BigRational> a = null;
        long t0 = System.currentTimeMillis();
        int i = 0;
        while (i < max) {
            n = cf.random(5);
            a = LIST.COMP(n, a);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        if (this.timing) {
            System.out.println("t.comp = " + (t1 - t0));
        }
        LISTTest.assertEquals((String)("len(a) == " + max + " "), (int)LIST.LENGTH(a), (int)max);
        ArrayList<BigRational> b = new ArrayList<BigRational>();
        LIST<BigRational> ap = a;
        t0 = System.currentTimeMillis();
        while (!LIST.isEmpty(ap)) {
            n = LIST.FIRST(ap);
            ap = LIST.RED(ap);
            b.add(n);
        }
        t1 = System.currentTimeMillis();
        if (this.timing) {
            System.out.println("t.red  = " + (t1 - t0));
        }
        LISTTest.assertEquals((String)("size(b) == " + max + " "), (int)b.size(), (int)max);
        b = new ArrayList();
        int len = LIST.LENGTH(a);
        t0 = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < len) {
            n = LIST.LELT(a, i2);
            b.add(n);
            ++i2;
        }
        t1 = System.currentTimeMillis();
        if (this.timing) {
            System.out.println("t.lelt = " + (t1 - t0));
        }
        LIST c = new LIST(b);
        LISTTest.assertEquals((String)("len(c) == " + max + " "), (int)LIST.LENGTH(c), (int)max);
        LISTTest.assertTrue((String)"a == c ", (boolean)LIST.EQUAL(a, c));
    }
}

