/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.integration;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegratorImpl;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class TrapezoidIntegrator
extends UnivariateRealIntegratorImpl {
    private double s;

    @Deprecated
    public TrapezoidIntegrator(UnivariateRealFunction f) {
        super(f, 64);
    }

    public TrapezoidIntegrator() {
        super(64);
    }

    double stage(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException {
        if (n == 0) {
            this.s = 0.5 * (max - min) * (f.value(min) + f.value(max));
            return this.s;
        }
        long np = 1L << n - 1;
        double sum = 0.0;
        double spacing = (max - min) / (double)np;
        double x = min + 0.5 * spacing;
        long i = 0L;
        while (i < np) {
            sum += f.value(x);
            x += spacing;
            ++i;
        }
        this.s = 0.5 * (this.s + sum * spacing);
        return this.s;
    }

    @Override
    @Deprecated
    public double integrate(double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        return this.integrate(this.f, min, max);
    }

    @Override
    public double integrate(UnivariateRealFunction f, double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        this.clearResult();
        this.verifyInterval(min, max);
        this.verifyIterationCount();
        double oldt = this.stage(f, min, max, 0);
        int i = 1;
        while (i <= this.maximalIterationCount) {
            double rLimit;
            double delta;
            double t = this.stage(f, min, max, i);
            if (i >= this.minimalIterationCount && ((delta = FastMath.abs(t - oldt)) <= (rLimit = this.relativeAccuracy * (FastMath.abs(oldt) + FastMath.abs(t)) * 0.5) || delta <= this.absoluteAccuracy)) {
                this.setResult(t, i);
                return this.result;
            }
            oldt = t;
            ++i;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    @Override
    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 64) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INVALID_ITERATIONS_LIMITS, 0, 64);
        }
    }
}

