/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import java.io.Serializable;
import org.apache.commons.math.DuplicateSampleAbscissaException;
import org.apache.commons.math.analysis.interpolation.UnivariateRealInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialFunctionLagrangeForm;
import org.apache.commons.math.analysis.polynomials.PolynomialFunctionNewtonForm;

public class DividedDifferenceInterpolator
implements UnivariateRealInterpolator,
Serializable {
    private static final long serialVersionUID = 107049519551235069L;

    @Override
    public PolynomialFunctionNewtonForm interpolate(double[] x, double[] y) throws DuplicateSampleAbscissaException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y);
        double[] c = new double[x.length - 1];
        System.arraycopy(x, 0, c, 0, c.length);
        double[] a = DividedDifferenceInterpolator.computeDividedDifference(x, y);
        return new PolynomialFunctionNewtonForm(a, c);
    }

    protected static double[] computeDividedDifference(double[] x, double[] y) throws DuplicateSampleAbscissaException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y);
        double[] divdiff = (double[])y.clone();
        int n = x.length;
        double[] a = new double[n];
        a[0] = divdiff[0];
        int i = 1;
        while (i < n) {
            int j = 0;
            while (j < n - i) {
                double denominator = x[j + i] - x[j];
                if (denominator == 0.0) {
                    throw new DuplicateSampleAbscissaException(x[j], j, j + i);
                }
                divdiff[j] = (divdiff[j + 1] - divdiff[j]) / denominator;
                ++j;
            }
            a[i] = divdiff[0];
            ++i;
        }
        return a;
    }
}

