/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math.analysis.interpolation.BivariateRealGridInterpolator;
import org.apache.commons.math.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.MathUtils;

public class SmoothingBicubicSplineInterpolator
implements BivariateRealGridInterpolator {
    @Override
    public BicubicSplineInterpolatingFunction interpolate(double[] xval, double[] yval, double[][] zval) throws MathException, IllegalArgumentException {
        int i;
        if (xval.length == 0 || yval.length == 0 || zval.length == 0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NO_DATA, new Object[0]);
        }
        if (xval.length != zval.length) {
            throw new DimensionMismatchException(xval.length, zval.length);
        }
        MathUtils.checkOrder(xval, MathUtils.OrderDirection.INCREASING, true);
        MathUtils.checkOrder(yval, MathUtils.OrderDirection.INCREASING, true);
        int xLen = xval.length;
        int yLen = yval.length;
        double[][] zX = new double[yLen][xLen];
        int i2 = 0;
        while (i2 < xLen) {
            if (zval[i2].length != yLen) {
                throw new DimensionMismatchException(zval[i2].length, yLen);
            }
            int j = 0;
            while (j < yLen) {
                zX[j][i2] = zval[i2][j];
                ++j;
            }
            ++i2;
        }
        SplineInterpolator spInterpolator = new SplineInterpolator();
        PolynomialSplineFunction[] ySplineX = new PolynomialSplineFunction[yLen];
        int j = 0;
        while (j < yLen) {
            ySplineX[j] = spInterpolator.interpolate(xval, zX[j]);
            ++j;
        }
        double[][] zY_1 = new double[xLen][yLen];
        int j2 = 0;
        while (j2 < yLen) {
            PolynomialSplineFunction f = ySplineX[j2];
            i = 0;
            while (i < xLen) {
                zY_1[i][j2] = f.value(xval[i]);
                ++i;
            }
            ++j2;
        }
        PolynomialSplineFunction[] xSplineY = new PolynomialSplineFunction[xLen];
        int i3 = 0;
        while (i3 < xLen) {
            xSplineY[i3] = spInterpolator.interpolate(yval, zY_1[i3]);
            ++i3;
        }
        double[][] zY_2 = new double[xLen][yLen];
        i = 0;
        while (i < xLen) {
            PolynomialSplineFunction f = xSplineY[i];
            int j3 = 0;
            while (j3 < yLen) {
                zY_2[i][j3] = f.value(yval[j3]);
                ++j3;
            }
            ++i;
        }
        double[][] dZdX = new double[xLen][yLen];
        int j4 = 0;
        while (j4 < yLen) {
            UnivariateRealFunction f = ySplineX[j4].derivative();
            int i4 = 0;
            while (i4 < xLen) {
                dZdX[i4][j4] = f.value(xval[i4]);
                ++i4;
            }
            ++j4;
        }
        double[][] dZdY = new double[xLen][yLen];
        int i5 = 0;
        while (i5 < xLen) {
            UnivariateRealFunction f = xSplineY[i5].derivative();
            int j5 = 0;
            while (j5 < yLen) {
                dZdY[i5][j5] = f.value(yval[j5]);
                ++j5;
            }
            ++i5;
        }
        double[][] dZdXdY = new double[xLen][yLen];
        int i6 = 0;
        while (i6 < xLen) {
            int nI = this.nextIndex(i6, xLen);
            int pI = this.previousIndex(i6);
            int j6 = 0;
            while (j6 < yLen) {
                int nJ = this.nextIndex(j6, yLen);
                int pJ = this.previousIndex(j6);
                dZdXdY[i6][j6] = (zY_2[nI][nJ] - zY_2[nI][pJ] - zY_2[pI][nJ] + zY_2[pI][pJ]) / ((xval[nI] - xval[pI]) * (yval[nJ] - yval[pJ]));
                ++j6;
            }
            ++i6;
        }
        return new BicubicSplineInterpolatingFunction(xval, yval, zY_2, dZdX, dZdY, dZdXdY);
    }

    private int nextIndex(int i, int max) {
        int index = i + 1;
        return index < max ? index : index - 1;
    }

    private int previousIndex(int i) {
        int index = i - 1;
        return index >= 0 ? index : 0;
    }
}

