/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.interpolation;

import org.apache.commons.math.MathException;
import org.apache.commons.math.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math.analysis.interpolation.BicubicSplineInterpolator;
import org.apache.commons.math.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NoDataException;
import org.apache.commons.math.optimization.fitting.PolynomialFitter;
import org.apache.commons.math.optimization.general.GaussNewtonOptimizer;
import org.apache.commons.math.util.MathUtils;

public class SmoothingPolynomialBicubicSplineInterpolator
extends BicubicSplineInterpolator {
    private final PolynomialFitter xFitter;
    private final PolynomialFitter yFitter;

    public SmoothingPolynomialBicubicSplineInterpolator() {
        this(3);
    }

    public SmoothingPolynomialBicubicSplineInterpolator(int degree) {
        this(degree, degree);
    }

    public SmoothingPolynomialBicubicSplineInterpolator(int xDegree, int yDegree) {
        this.xFitter = new PolynomialFitter(xDegree, new GaussNewtonOptimizer(false));
        this.yFitter = new PolynomialFitter(yDegree, new GaussNewtonOptimizer(false));
    }

    @Override
    public BicubicSplineInterpolatingFunction interpolate(double[] xval, double[] yval, double[][] fval) throws MathException {
        int i;
        if (xval.length == 0 || yval.length == 0 || fval.length == 0) {
            throw new NoDataException();
        }
        if (xval.length != fval.length) {
            throw new DimensionMismatchException(xval.length, fval.length);
        }
        int xLen = xval.length;
        int yLen = yval.length;
        int i2 = 0;
        while (i2 < xLen) {
            if (fval[i2].length != yLen) {
                throw new DimensionMismatchException(fval[i2].length, yLen);
            }
            ++i2;
        }
        MathUtils.checkOrder(xval);
        MathUtils.checkOrder(yval);
        PolynomialFunction[] yPolyX = new PolynomialFunction[yLen];
        int j = 0;
        while (j < yLen) {
            this.xFitter.clearObservations();
            int i3 = 0;
            while (i3 < xLen) {
                this.xFitter.addObservedPoint(1.0, xval[i3], fval[i3][j]);
                ++i3;
            }
            yPolyX[j] = this.xFitter.fit();
            ++j;
        }
        double[][] fval_1 = new double[xLen][yLen];
        int j2 = 0;
        while (j2 < yLen) {
            PolynomialFunction f = yPolyX[j2];
            i = 0;
            while (i < xLen) {
                fval_1[i][j2] = f.value(xval[i]);
                ++i;
            }
            ++j2;
        }
        PolynomialFunction[] xPolyY = new PolynomialFunction[xLen];
        int i4 = 0;
        while (i4 < xLen) {
            this.yFitter.clearObservations();
            int j3 = 0;
            while (j3 < yLen) {
                this.yFitter.addObservedPoint(1.0, yval[j3], fval_1[i4][j3]);
                ++j3;
            }
            xPolyY[i4] = this.yFitter.fit();
            ++i4;
        }
        double[][] fval_2 = new double[xLen][yLen];
        i = 0;
        while (i < xLen) {
            PolynomialFunction f = xPolyY[i];
            int j4 = 0;
            while (j4 < yLen) {
                fval_2[i][j4] = f.value(yval[j4]);
                ++j4;
            }
            ++i;
        }
        return super.interpolate(xval, yval, fval_2);
    }
}

