/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.polynomials;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.NoDataException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class PolynomialFunction
implements DifferentiableUnivariateRealFunction,
Serializable {
    private static final long serialVersionUID = -7726511984200295583L;
    private final double[] coefficients;

    /*
     * Unable to fully structure code
     */
    public PolynomialFunction(double[] c) {
        super();
        n = c.length;
        if (n != 0) ** GOTO lbl6
        throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
lbl-1000:
        // 1 sources

        {
            --n;
lbl6:
            // 2 sources

            ** while (n > 1 && c[n - 1] == 0.0)
        }
lbl7:
        // 1 sources

        this.coefficients = new double[n];
        System.arraycopy(c, 0, this.coefficients, 0, n);
    }

    @Override
    public double value(double x) {
        return PolynomialFunction.evaluate(this.coefficients, x);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    protected static double evaluate(double[] coefficients, double argument) {
        int n = coefficients.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        double result = coefficients[n - 1];
        int j = n - 2;
        while (j >= 0) {
            result = argument * result + coefficients[j];
            --j;
        }
        return result;
    }

    public PolynomialFunction add(PolynomialFunction p) {
        int lowLength = FastMath.min(this.coefficients.length, p.coefficients.length);
        int highLength = FastMath.max(this.coefficients.length, p.coefficients.length);
        double[] newCoefficients = new double[highLength];
        int i = 0;
        while (i < lowLength) {
            newCoefficients[i] = this.coefficients[i] + p.coefficients[i];
            ++i;
        }
        System.arraycopy(this.coefficients.length < p.coefficients.length ? p.coefficients : this.coefficients, lowLength, newCoefficients, lowLength, highLength - lowLength);
        return new PolynomialFunction(newCoefficients);
    }

    public PolynomialFunction subtract(PolynomialFunction p) {
        int lowLength = FastMath.min(this.coefficients.length, p.coefficients.length);
        int highLength = FastMath.max(this.coefficients.length, p.coefficients.length);
        double[] newCoefficients = new double[highLength];
        int i = 0;
        while (i < lowLength) {
            newCoefficients[i] = this.coefficients[i] - p.coefficients[i];
            ++i;
        }
        if (this.coefficients.length < p.coefficients.length) {
            i = lowLength;
            while (i < highLength) {
                newCoefficients[i] = -p.coefficients[i];
                ++i;
            }
        } else {
            System.arraycopy(this.coefficients, lowLength, newCoefficients, lowLength, highLength - lowLength);
        }
        return new PolynomialFunction(newCoefficients);
    }

    public PolynomialFunction negate() {
        double[] newCoefficients = new double[this.coefficients.length];
        int i = 0;
        while (i < this.coefficients.length) {
            newCoefficients[i] = -this.coefficients[i];
            ++i;
        }
        return new PolynomialFunction(newCoefficients);
    }

    public PolynomialFunction multiply(PolynomialFunction p) {
        double[] newCoefficients = new double[this.coefficients.length + p.coefficients.length - 1];
        int i = 0;
        while (i < newCoefficients.length) {
            newCoefficients[i] = 0.0;
            int j = FastMath.max(0, i + 1 - p.coefficients.length);
            while (j < FastMath.min(this.coefficients.length, i + 1)) {
                int n = i;
                newCoefficients[n] = newCoefficients[n] + this.coefficients[j] * p.coefficients[i - j];
                ++j;
            }
            ++i;
        }
        return new PolynomialFunction(newCoefficients);
    }

    protected static double[] differentiate(double[] coefficients) {
        int n = coefficients.length;
        if (n == 0) {
            throw new NoDataException(LocalizedFormats.EMPTY_POLYNOMIALS_COEFFICIENTS_ARRAY);
        }
        if (n == 1) {
            return new double[]{0.0};
        }
        double[] result = new double[n - 1];
        int i = n - 1;
        while (i > 0) {
            result[i - 1] = (double)i * coefficients[i];
            --i;
        }
        return result;
    }

    public PolynomialFunction polynomialDerivative() {
        return new PolynomialFunction(PolynomialFunction.differentiate(this.coefficients));
    }

    @Override
    public UnivariateRealFunction derivative() {
        return this.polynomialDerivative();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        if (this.coefficients[0] == 0.0) {
            if (this.coefficients.length == 1) {
                return "0";
            }
        } else {
            s.append(Double.toString(this.coefficients[0]));
        }
        int i = 1;
        while (i < this.coefficients.length) {
            if (this.coefficients[i] != 0.0) {
                if (s.length() > 0) {
                    if (this.coefficients[i] < 0.0) {
                        s.append(" - ");
                    } else {
                        s.append(" + ");
                    }
                } else if (this.coefficients[i] < 0.0) {
                    s.append("-");
                }
                double absAi = FastMath.abs(this.coefficients[i]);
                if (absAi - 1.0 != 0.0) {
                    s.append(Double.toString(absAi));
                    s.append(' ');
                }
                s.append("x");
                if (i > 1) {
                    s.append('^');
                    s.append(Integer.toString(i));
                }
            }
            ++i;
        }
        return s.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.coefficients);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PolynomialFunction)) {
            return false;
        }
        PolynomialFunction other = (PolynomialFunction)obj;
        return Arrays.equals(this.coefficients, other.coefficients);
    }
}

