/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.polynomials;

import org.apache.commons.math.DuplicateSampleAbscissaException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class PolynomialFunctionLagrangeForm
implements UnivariateRealFunction {
    private double[] coefficients;
    private final double[] x;
    private final double[] y;
    private boolean coefficientsComputed;

    public PolynomialFunctionLagrangeForm(double[] x, double[] y) throws IllegalArgumentException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y);
        this.x = new double[x.length];
        this.y = new double[y.length];
        System.arraycopy(x, 0, this.x, 0, x.length);
        System.arraycopy(y, 0, this.y, 0, y.length);
        this.coefficientsComputed = false;
    }

    @Override
    public double value(double z) throws FunctionEvaluationException {
        try {
            return PolynomialFunctionLagrangeForm.evaluate(this.x, this.y, z);
        }
        catch (DuplicateSampleAbscissaException e) {
            throw new FunctionEvaluationException((Throwable)e, z, e.getLocalizablePattern(), e.getArguments());
        }
    }

    public int degree() {
        return this.x.length - 1;
    }

    public double[] getInterpolatingPoints() {
        double[] out = new double[this.x.length];
        System.arraycopy(this.x, 0, out, 0, this.x.length);
        return out;
    }

    public double[] getInterpolatingValues() {
        double[] out = new double[this.y.length];
        System.arraycopy(this.y, 0, out, 0, this.y.length);
        return out;
    }

    public double[] getCoefficients() {
        if (!this.coefficientsComputed) {
            this.computeCoefficients();
        }
        double[] out = new double[this.coefficients.length];
        System.arraycopy(this.coefficients, 0, out, 0, this.coefficients.length);
        return out;
    }

    public static double evaluate(double[] x, double[] y, double z) throws DuplicateSampleAbscissaException, IllegalArgumentException {
        PolynomialFunctionLagrangeForm.verifyInterpolationArray(x, y);
        int nearest = 0;
        int n = x.length;
        double[] c = new double[n];
        double[] d = new double[n];
        double min_dist = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < n) {
            c[i] = y[i];
            d[i] = y[i];
            double dist = FastMath.abs(z - x[i]);
            if (dist < min_dist) {
                nearest = i;
                min_dist = dist;
            }
            ++i;
        }
        double value = y[nearest];
        int i2 = 1;
        while (i2 < n) {
            int j = 0;
            while (j < n - i2) {
                double tc = x[j] - z;
                double td = x[i2 + j] - z;
                double divider = x[j] - x[i2 + j];
                if (divider == 0.0) {
                    throw new DuplicateSampleAbscissaException(x[i2], i2, i2 + j);
                }
                double w = (c[j + 1] - d[j]) / divider;
                c[j] = tc * w;
                d[j] = td * w;
                ++j;
            }
            value = (double)nearest < 0.5 * (double)(n - i2 + 1) ? (value += c[nearest]) : (value += d[--nearest]);
            ++i2;
        }
        return value;
    }

    protected void computeCoefficients() throws ArithmeticException {
        int n = this.degree() + 1;
        this.coefficients = new double[n];
        int i = 0;
        while (i < n) {
            this.coefficients[i] = 0.0;
            ++i;
        }
        double[] c = new double[n + 1];
        c[0] = 1.0;
        int i2 = 0;
        while (i2 < n) {
            int j = i2;
            while (j > 0) {
                c[j] = c[j - 1] - c[j] * this.x[i2];
                --j;
            }
            c[0] = c[0] * -this.x[i2];
            c[i2 + 1] = 1.0;
            ++i2;
        }
        double[] tc = new double[n];
        int i3 = 0;
        while (i3 < n) {
            double d = 1.0;
            int j = 0;
            while (j < n) {
                if (i3 != j) {
                    d *= this.x[i3] - this.x[j];
                }
                ++j;
            }
            if (d == 0.0) {
                int k = 0;
                while (k < n) {
                    if (i3 != k && this.x[i3] == this.x[k]) {
                        throw MathRuntimeException.createArithmeticException(LocalizedFormats.IDENTICAL_ABSCISSAS_DIVISION_BY_ZERO, i3, k, this.x[i3]);
                    }
                    ++k;
                }
            }
            double t = this.y[i3] / d;
            tc[n - 1] = c[n];
            int n2 = n - 1;
            this.coefficients[n2] = this.coefficients[n2] + t * tc[n - 1];
            int j2 = n - 2;
            while (j2 >= 0) {
                tc[j2] = c[j2 + 1] + tc[j2 + 1] * this.x[i3];
                int n3 = j2;
                this.coefficients[n3] = this.coefficients[n3] + t * tc[j2];
                --j2;
            }
            ++i3;
        }
        this.coefficientsComputed = true;
    }

    public static void verifyInterpolationArray(double[] x, double[] y) throws IllegalArgumentException {
        if (x.length != y.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, x.length, y.length);
        }
        if (x.length < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.WRONG_NUMBER_OF_POINTS, 2, x.length);
        }
    }
}

