/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.CauchyDistribution;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class CauchyDistributionImpl
extends AbstractContinuousDistribution
implements CauchyDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private double median = 0.0;
    private double scale = 1.0;
    private final double solverAbsoluteAccuracy;

    public CauchyDistributionImpl() {
        this(0.0, 1.0);
    }

    public CauchyDistributionImpl(double median, double s) {
        this(median, s, 1.0E-9);
    }

    public CauchyDistributionImpl(double median, double s, double inverseCumAccuracy) {
        this.setMedianInternal(median);
        this.setScaleInternal(s);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    @Override
    public double cumulativeProbability(double x) {
        return 0.5 + FastMath.atan((x - this.median) / this.scale) / Math.PI;
    }

    @Override
    public double getMedian() {
        return this.median;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double x) {
        double dev = x - this.median;
        return 0.3183098861837907 * (this.scale / (dev * dev + this.scale * this.scale));
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_RANGE_SIMPLE, p, 0.0, 1.0);
        }
        double ret = p == 0.0 ? Double.NEGATIVE_INFINITY : (p == 1.0 ? Double.POSITIVE_INFINITY : this.median + this.scale * FastMath.tan(Math.PI * (p - 0.5)));
        return ret;
    }

    @Override
    @Deprecated
    public void setMedian(double median) {
        this.setMedianInternal(median);
    }

    private void setMedianInternal(double newMedian) {
        this.median = newMedian;
    }

    @Override
    @Deprecated
    public void setScale(double s) {
        this.setScaleInternal(s);
    }

    private void setScaleInternal(double s) {
        if (s <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_SCALE, s);
        }
        this.scale = s;
    }

    @Override
    protected double getDomainLowerBound(double p) {
        double ret = p < 0.5 ? -1.7976931348623157E308 : this.median;
        return ret;
    }

    @Override
    protected double getDomainUpperBound(double p) {
        double ret = p < 0.5 ? this.median : Double.MAX_VALUE;
        return ret;
    }

    @Override
    protected double getInitialDomain(double p) {
        double ret = p < 0.5 ? this.median - this.scale : (p > 0.5 ? this.median + this.scale : this.median);
        return ret;
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

