/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.estimation;

import java.util.Arrays;
import org.apache.commons.math.estimation.EstimatedParameter;
import org.apache.commons.math.estimation.EstimationException;
import org.apache.commons.math.estimation.EstimationProblem;
import org.apache.commons.math.estimation.Estimator;
import org.apache.commons.math.estimation.WeightedMeasurement;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.util.FastMath;

@Deprecated
public abstract class AbstractEstimator
implements Estimator {
    public static final int DEFAULT_MAX_COST_EVALUATIONS = 100;
    protected WeightedMeasurement[] measurements;
    protected EstimatedParameter[] parameters;
    protected double[] jacobian;
    protected int cols;
    protected int rows;
    protected double[] residuals;
    protected double cost;
    private int maxCostEval;
    private int costEvaluations;
    private int jacobianEvaluations;

    protected AbstractEstimator() {
        this.setMaxCostEval(100);
    }

    public final void setMaxCostEval(int maxCostEval) {
        this.maxCostEval = maxCostEval;
    }

    public final int getCostEvaluations() {
        return this.costEvaluations;
    }

    public final int getJacobianEvaluations() {
        return this.jacobianEvaluations;
    }

    protected void updateJacobian() {
        this.incrementJacobianEvaluationsCounter();
        Arrays.fill(this.jacobian, 0.0);
        int index = 0;
        int i = 0;
        while (i < this.rows) {
            WeightedMeasurement wm = this.measurements[i];
            double factor = -FastMath.sqrt(wm.getWeight());
            int j = 0;
            while (j < this.cols) {
                this.jacobian[index++] = factor * wm.getPartial(this.parameters[j]);
                ++j;
            }
            ++i;
        }
    }

    protected final void incrementJacobianEvaluationsCounter() {
        ++this.jacobianEvaluations;
    }

    protected void updateResidualsAndCost() throws EstimationException {
        if (++this.costEvaluations > this.maxCostEval) {
            throw new EstimationException(LocalizedFormats.MAX_EVALUATIONS_EXCEEDED, this.maxCostEval);
        }
        this.cost = 0.0;
        int index = 0;
        int i = 0;
        while (i < this.rows) {
            WeightedMeasurement wm = this.measurements[i];
            double residual = wm.getResidual();
            this.residuals[i] = FastMath.sqrt(wm.getWeight()) * residual;
            this.cost += wm.getWeight() * residual * residual;
            ++i;
            index += this.cols;
        }
        this.cost = FastMath.sqrt(this.cost);
    }

    @Override
    public double getRMS(EstimationProblem problem) {
        WeightedMeasurement[] wm = problem.getMeasurements();
        double criterion = 0.0;
        int i = 0;
        while (i < wm.length) {
            double residual = wm[i].getResidual();
            criterion += wm[i].getWeight() * residual * residual;
            ++i;
        }
        return FastMath.sqrt(criterion / (double)wm.length);
    }

    public double getChiSquare(EstimationProblem problem) {
        WeightedMeasurement[] wm = problem.getMeasurements();
        double chiSquare = 0.0;
        int i = 0;
        while (i < wm.length) {
            double residual = wm[i].getResidual();
            chiSquare += residual * residual / wm[i].getWeight();
            ++i;
        }
        return chiSquare;
    }

    @Override
    public double[][] getCovariances(EstimationProblem problem) throws EstimationException {
        this.updateJacobian();
        int n = problem.getMeasurements().length;
        int m = problem.getUnboundParameters().length;
        int max = m * n;
        double[][] jTj = new double[m][m];
        int i = 0;
        while (i < m) {
            int j = i;
            while (j < m) {
                double sum = 0.0;
                int k = 0;
                while (k < max) {
                    sum += this.jacobian[k + i] * this.jacobian[k + j];
                    k += m;
                }
                jTj[i][j] = sum;
                jTj[j][i] = sum;
                ++j;
            }
            ++i;
        }
        try {
            RealMatrix inverse = new LUDecompositionImpl(MatrixUtils.createRealMatrix(jTj)).getSolver().getInverse();
            return inverse.getData();
        }
        catch (InvalidMatrixException ime) {
            throw new EstimationException(LocalizedFormats.UNABLE_TO_COMPUTE_COVARIANCE_SINGULAR_PROBLEM, new Object[0]);
        }
    }

    @Override
    public double[] guessParametersErrors(EstimationProblem problem) throws EstimationException {
        int p;
        int m = problem.getMeasurements().length;
        if (m <= (p = problem.getUnboundParameters().length)) {
            throw new EstimationException(LocalizedFormats.NO_DEGREES_OF_FREEDOM, m, p);
        }
        double[] errors = new double[problem.getUnboundParameters().length];
        double c = FastMath.sqrt(this.getChiSquare(problem) / (double)(m - p));
        double[][] covar = this.getCovariances(problem);
        int i = 0;
        while (i < errors.length) {
            errors[i] = FastMath.sqrt(covar[i][i]) * c;
            ++i;
        }
        return errors;
    }

    protected void initializeEstimate(EstimationProblem problem) {
        this.costEvaluations = 0;
        this.jacobianEvaluations = 0;
        this.measurements = problem.getMeasurements();
        this.parameters = problem.getUnboundParameters();
        this.rows = this.measurements.length;
        this.cols = this.parameters.length;
        this.jacobian = new double[this.rows * this.cols];
        this.residuals = new double[this.rows];
        this.cost = Double.POSITIVE_INFINITY;
    }

    @Override
    public abstract void estimate(EstimationProblem var1) throws EstimationException;
}

