/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.estimation;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math.estimation.AbstractEstimator;
import org.apache.commons.math.estimation.EstimationException;
import org.apache.commons.math.estimation.EstimationProblem;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

@Deprecated
public class LevenbergMarquardtEstimator
extends AbstractEstimator
implements Serializable {
    private static final long serialVersionUID = -5705952631533171019L;
    private int solvedCols;
    private double[] diagR;
    private double[] jacNorm;
    private double[] beta;
    private int[] permutation;
    private int rank;
    private double lmPar;
    private double[] lmDir;
    private double initialStepBoundFactor;
    private double costRelativeTolerance;
    private double parRelativeTolerance;
    private double orthoTolerance;

    public LevenbergMarquardtEstimator() {
        this.setMaxCostEval(1000);
        this.setInitialStepBoundFactor(100.0);
        this.setCostRelativeTolerance(1.0E-10);
        this.setParRelativeTolerance(1.0E-10);
        this.setOrthoTolerance(1.0E-10);
    }

    public void setInitialStepBoundFactor(double initialStepBoundFactor) {
        this.initialStepBoundFactor = initialStepBoundFactor;
    }

    public void setCostRelativeTolerance(double costRelativeTolerance) {
        this.costRelativeTolerance = costRelativeTolerance;
    }

    public void setParRelativeTolerance(double parRelativeTolerance) {
        this.parRelativeTolerance = parRelativeTolerance;
    }

    public void setOrthoTolerance(double orthoTolerance) {
        this.orthoTolerance = orthoTolerance;
    }

    @Override
    public void estimate(EstimationProblem problem) throws EstimationException {
        this.initializeEstimate(problem);
        this.solvedCols = FastMath.min(this.rows, this.cols);
        this.diagR = new double[this.cols];
        this.jacNorm = new double[this.cols];
        this.beta = new double[this.cols];
        this.permutation = new int[this.cols];
        this.lmDir = new double[this.cols];
        double delta = 0.0;
        double xNorm = 0.0;
        double[] diag = new double[this.cols];
        double[] oldX = new double[this.cols];
        double[] oldRes = new double[this.rows];
        double[] work1 = new double[this.cols];
        double[] work2 = new double[this.cols];
        double[] work3 = new double[this.cols];
        this.updateResidualsAndCost();
        this.lmPar = 0.0;
        boolean firstIteration = true;
        block0: while (true) {
            int j;
            this.updateJacobian();
            this.qrDecomposition();
            this.qTy(this.residuals);
            int k = 0;
            while (k < this.solvedCols) {
                int pk = this.permutation[k];
                this.jacobian[k * this.cols + pk] = this.diagR[pk];
                ++k;
            }
            if (firstIteration) {
                xNorm = 0.0;
                k = 0;
                while (k < this.cols) {
                    double dk = this.jacNorm[k];
                    if (dk == 0.0) {
                        dk = 1.0;
                    }
                    double xk = dk * this.parameters[k].getEstimate();
                    xNorm += xk * xk;
                    diag[k] = dk;
                    ++k;
                }
                delta = (xNorm = FastMath.sqrt(xNorm)) == 0.0 ? this.initialStepBoundFactor : this.initialStepBoundFactor * xNorm;
            }
            double maxCosine = 0.0;
            if (this.cost != 0.0) {
                j = 0;
                while (j < this.solvedCols) {
                    int pj = this.permutation[j];
                    double s = this.jacNorm[pj];
                    if (s != 0.0) {
                        double sum = 0.0;
                        int index = pj;
                        int i = 0;
                        while (i <= j) {
                            sum += this.jacobian[index] * this.residuals[i];
                            index += this.cols;
                            ++i;
                        }
                        maxCosine = FastMath.max(maxCosine, FastMath.abs(sum) / (s * this.cost));
                    }
                    ++j;
                }
            }
            if (maxCosine <= this.orthoTolerance) {
                return;
            }
            j = 0;
            while (j < this.cols) {
                diag[j] = FastMath.max(diag[j], this.jacNorm[j]);
                ++j;
            }
            double ratio = 0.0;
            do {
                if (!(ratio < 1.0E-4)) continue block0;
                int j2 = 0;
                while (j2 < this.solvedCols) {
                    int pj = this.permutation[j2];
                    oldX[pj] = this.parameters[pj].getEstimate();
                    ++j2;
                }
                double previousCost = this.cost;
                double[] tmpVec = this.residuals;
                this.residuals = oldRes;
                oldRes = tmpVec;
                this.determineLMParameter(oldRes, delta, diag, work1, work2, work3);
                double lmNorm = 0.0;
                int j3 = 0;
                while (j3 < this.solvedCols) {
                    int pj = this.permutation[j3];
                    this.lmDir[pj] = -this.lmDir[pj];
                    this.parameters[pj].setEstimate(oldX[pj] + this.lmDir[pj]);
                    double s = diag[pj] * this.lmDir[pj];
                    lmNorm += s * s;
                    ++j3;
                }
                lmNorm = FastMath.sqrt(lmNorm);
                if (firstIteration) {
                    delta = FastMath.min(delta, lmNorm);
                }
                this.updateResidualsAndCost();
                double actRed = -1.0;
                if (0.1 * this.cost < previousCost) {
                    double r = this.cost / previousCost;
                    actRed = 1.0 - r * r;
                }
                int j4 = 0;
                while (j4 < this.solvedCols) {
                    int pj = this.permutation[j4];
                    double dirJ = this.lmDir[pj];
                    work1[j4] = 0.0;
                    int index = pj;
                    int i = 0;
                    while (i <= j4) {
                        int n = i++;
                        work1[n] = work1[n] + this.jacobian[index] * dirJ;
                        index += this.cols;
                    }
                    ++j4;
                }
                double coeff1 = 0.0;
                int j5 = 0;
                while (j5 < this.solvedCols) {
                    coeff1 += work1[j5] * work1[j5];
                    ++j5;
                }
                double pc2 = previousCost * previousCost;
                double coeff2 = this.lmPar * lmNorm * lmNorm / pc2;
                double preRed = (coeff1 /= pc2) + 2.0 * coeff2;
                double dirDer = -(coeff1 + coeff2);
                double d = ratio = preRed == 0.0 ? 0.0 : actRed / preRed;
                if (ratio <= 0.25) {
                    double tmp;
                    double d2 = tmp = actRed < 0.0 ? 0.5 * dirDer / (dirDer + 0.5 * actRed) : 0.5;
                    if (0.1 * this.cost >= previousCost || tmp < 0.1) {
                        tmp = 0.1;
                    }
                    delta = tmp * FastMath.min(delta, 10.0 * lmNorm);
                    this.lmPar /= tmp;
                } else if (this.lmPar == 0.0 || ratio >= 0.75) {
                    delta = 2.0 * lmNorm;
                    this.lmPar *= 0.5;
                }
                if (ratio >= 1.0E-4) {
                    firstIteration = false;
                    xNorm = 0.0;
                    int k2 = 0;
                    while (k2 < this.cols) {
                        double xK = diag[k2] * this.parameters[k2].getEstimate();
                        xNorm += xK * xK;
                        ++k2;
                    }
                    xNorm = FastMath.sqrt(xNorm);
                } else {
                    this.cost = previousCost;
                    int j6 = 0;
                    while (j6 < this.solvedCols) {
                        int pj = this.permutation[j6];
                        this.parameters[pj].setEstimate(oldX[pj]);
                        ++j6;
                    }
                    tmpVec = this.residuals;
                    this.residuals = oldRes;
                    oldRes = tmpVec;
                }
                if (FastMath.abs(actRed) <= this.costRelativeTolerance && preRed <= this.costRelativeTolerance && ratio <= 2.0 || delta <= this.parRelativeTolerance * xNorm) {
                    return;
                }
                if (FastMath.abs(actRed) <= 2.2204E-16 && preRed <= 2.2204E-16 && ratio <= 2.0) {
                    throw new EstimationException("cost relative tolerance is too small ({0}), no further reduction in the sum of squares is possible", this.costRelativeTolerance);
                }
                if (!(delta <= 2.2204E-16 * xNorm)) continue;
                throw new EstimationException("parameters relative tolerance is too small ({0}), no further improvement in the approximate solution is possible", this.parRelativeTolerance);
            } while (!(maxCosine <= 2.2204E-16));
            break;
        }
        throw new EstimationException("orthogonality tolerance is too small ({0}), solution is orthogonal to the jacobian", this.orthoTolerance);
    }

    private void determineLMParameter(double[] qy, double delta, double[] diag, double[] work1, double[] work2, double[] work3) {
        int index;
        double sum;
        int pj;
        int j;
        int j2 = 0;
        while (j2 < this.rank) {
            this.lmDir[this.permutation[j2]] = qy[j2];
            ++j2;
        }
        j2 = this.rank;
        while (j2 < this.cols) {
            this.lmDir[this.permutation[j2]] = 0.0;
            ++j2;
        }
        int k = this.rank - 1;
        while (k >= 0) {
            int pk = this.permutation[k];
            double ypk = this.lmDir[pk] / this.diagR[pk];
            int index2 = pk;
            int i = 0;
            while (i < k) {
                int n = this.permutation[i];
                this.lmDir[n] = this.lmDir[n] - ypk * this.jacobian[index2];
                index2 += this.cols;
                ++i;
            }
            this.lmDir[pk] = ypk;
            --k;
        }
        double dxNorm = 0.0;
        int j3 = 0;
        while (j3 < this.solvedCols) {
            double s;
            int pj2 = this.permutation[j3];
            work1[pj2] = s = diag[pj2] * this.lmDir[pj2];
            dxNorm += s * s;
            ++j3;
        }
        double fp = (dxNorm = FastMath.sqrt(dxNorm)) - delta;
        if (fp <= 0.1 * delta) {
            this.lmPar = 0.0;
            return;
        }
        double parl = 0.0;
        if (this.rank == this.solvedCols) {
            j = 0;
            while (j < this.solvedCols) {
                int n = pj = this.permutation[j];
                work1[n] = work1[n] * (diag[pj] / dxNorm);
                ++j;
            }
            double sum2 = 0.0;
            j = 0;
            while (j < this.solvedCols) {
                double s;
                pj = this.permutation[j];
                sum = 0.0;
                index = pj;
                int i = 0;
                while (i < j) {
                    sum += this.jacobian[index] * work1[this.permutation[i]];
                    index += this.cols;
                    ++i;
                }
                work1[pj] = s = (work1[pj] - sum) / this.diagR[pj];
                sum2 += s * s;
                ++j;
            }
            parl = fp / (delta * sum2);
        }
        double sum2 = 0.0;
        j = 0;
        while (j < this.solvedCols) {
            pj = this.permutation[j];
            sum = 0.0;
            index = pj;
            int i = 0;
            while (i <= j) {
                sum += this.jacobian[index] * qy[i];
                index += this.cols;
                ++i;
            }
            sum2 += (sum /= diag[pj]) * sum;
            ++j;
        }
        double gNorm = FastMath.sqrt(sum2);
        double paru = gNorm / delta;
        if (paru == 0.0) {
            paru = 2.2251E-308 / FastMath.min(delta, 0.1);
        }
        this.lmPar = FastMath.min(paru, FastMath.max(this.lmPar, parl));
        if (this.lmPar == 0.0) {
            this.lmPar = gNorm / dxNorm;
        }
        int countdown = 10;
        while (countdown >= 0) {
            int pj3;
            int pj4;
            if (this.lmPar == 0.0) {
                this.lmPar = FastMath.max(2.2251E-308, 0.001 * paru);
            }
            double sPar = FastMath.sqrt(this.lmPar);
            int j4 = 0;
            while (j4 < this.solvedCols) {
                pj4 = this.permutation[j4];
                work1[pj4] = sPar * diag[pj4];
                ++j4;
            }
            this.determineLMDirection(qy, work1, work2, work3);
            dxNorm = 0.0;
            j4 = 0;
            while (j4 < this.solvedCols) {
                double s;
                pj4 = this.permutation[j4];
                work3[pj4] = s = diag[pj4] * this.lmDir[pj4];
                dxNorm += s * s;
                ++j4;
            }
            dxNorm = FastMath.sqrt(dxNorm);
            double previousFP = fp;
            fp = dxNorm - delta;
            if (FastMath.abs(fp) <= 0.1 * delta || parl == 0.0 && fp <= previousFP && previousFP < 0.0) {
                return;
            }
            int j5 = 0;
            while (j5 < this.solvedCols) {
                pj3 = this.permutation[j5];
                work1[pj3] = work3[pj3] * diag[pj3] / dxNorm;
                ++j5;
            }
            j5 = 0;
            while (j5 < this.solvedCols) {
                int n = pj3 = this.permutation[j5];
                work1[n] = work1[n] / work2[j5];
                double tmp = work1[pj3];
                int i = j5 + 1;
                while (i < this.solvedCols) {
                    int n2 = this.permutation[i];
                    work1[n2] = work1[n2] - this.jacobian[i * this.cols + pj3] * tmp;
                    ++i;
                }
                ++j5;
            }
            sum2 = 0.0;
            j5 = 0;
            while (j5 < this.solvedCols) {
                double s = work1[this.permutation[j5]];
                sum2 += s * s;
                ++j5;
            }
            double correction = fp / (delta * sum2);
            if (fp > 0.0) {
                parl = FastMath.max(parl, this.lmPar);
            } else if (fp < 0.0) {
                paru = FastMath.min(paru, this.lmPar);
            }
            this.lmPar = FastMath.max(parl, this.lmPar + correction);
            --countdown;
        }
    }

    private void determineLMDirection(double[] qy, double[] diag, double[] lmDiag, double[] work) {
        int pj;
        int j = 0;
        while (j < this.solvedCols) {
            pj = this.permutation[j];
            int i = j + 1;
            while (i < this.solvedCols) {
                this.jacobian[i * this.cols + pj] = this.jacobian[j * this.cols + this.permutation[i]];
                ++i;
            }
            this.lmDir[j] = this.diagR[pj];
            work[j] = qy[j];
            ++j;
        }
        j = 0;
        while (j < this.solvedCols) {
            pj = this.permutation[j];
            double dpj = diag[pj];
            if (dpj != 0.0) {
                Arrays.fill(lmDiag, j + 1, lmDiag.length, 0.0);
            }
            lmDiag[j] = dpj;
            double qtbpj = 0.0;
            int k = j;
            while (k < this.solvedCols) {
                int pk = this.permutation[k];
                if (lmDiag[k] != 0.0) {
                    double cos;
                    double sin;
                    double rkk = this.jacobian[k * this.cols + pk];
                    if (FastMath.abs(rkk) < FastMath.abs(lmDiag[k])) {
                        double cotan = rkk / lmDiag[k];
                        sin = 1.0 / FastMath.sqrt(1.0 + cotan * cotan);
                        cos = sin * cotan;
                    } else {
                        double tan = lmDiag[k] / rkk;
                        cos = 1.0 / FastMath.sqrt(1.0 + tan * tan);
                        sin = cos * tan;
                    }
                    this.jacobian[k * this.cols + pk] = cos * rkk + sin * lmDiag[k];
                    double temp = cos * work[k] + sin * qtbpj;
                    qtbpj = -sin * work[k] + cos * qtbpj;
                    work[k] = temp;
                    int i = k + 1;
                    while (i < this.solvedCols) {
                        double rik = this.jacobian[i * this.cols + pk];
                        double temp2 = cos * rik + sin * lmDiag[i];
                        lmDiag[i] = -sin * rik + cos * lmDiag[i];
                        this.jacobian[i * this.cols + pk] = temp2;
                        ++i;
                    }
                }
                ++k;
            }
            int index = j * this.cols + this.permutation[j];
            lmDiag[j] = this.jacobian[index];
            this.jacobian[index] = this.lmDir[j];
            ++j;
        }
        int nSing = this.solvedCols;
        int j2 = 0;
        while (j2 < this.solvedCols) {
            if (lmDiag[j2] == 0.0 && nSing == this.solvedCols) {
                nSing = j2;
            }
            if (nSing < this.solvedCols) {
                work[j2] = 0.0;
            }
            ++j2;
        }
        if (nSing > 0) {
            j2 = nSing - 1;
            while (j2 >= 0) {
                int pj2 = this.permutation[j2];
                double sum = 0.0;
                int i = j2 + 1;
                while (i < nSing) {
                    sum += this.jacobian[i * this.cols + pj2] * work[i];
                    ++i;
                }
                work[j2] = (work[j2] - sum) / lmDiag[j2];
                --j2;
            }
        }
        j2 = 0;
        while (j2 < this.lmDir.length) {
            this.lmDir[this.permutation[j2]] = work[j2];
            ++j2;
        }
    }

    private void qrDecomposition() throws EstimationException {
        int k = 0;
        while (k < this.cols) {
            this.permutation[k] = k;
            double norm2 = 0.0;
            int index = k;
            while (index < this.jacobian.length) {
                double akk = this.jacobian[index];
                norm2 += akk * akk;
                index += this.cols;
            }
            this.jacNorm[k] = FastMath.sqrt(norm2);
            ++k;
        }
        k = 0;
        while (k < this.cols) {
            double betak;
            int nextColumn = -1;
            double ak2 = Double.NEGATIVE_INFINITY;
            int i = k;
            while (i < this.cols) {
                int iDiag;
                double norm2 = 0.0;
                int index = iDiag = k * this.cols + this.permutation[i];
                while (index < this.jacobian.length) {
                    double aki = this.jacobian[index];
                    norm2 += aki * aki;
                    index += this.cols;
                }
                if (Double.isInfinite(norm2) || Double.isNaN(norm2)) {
                    throw new EstimationException(LocalizedFormats.UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, this.rows, this.cols);
                }
                if (norm2 > ak2) {
                    nextColumn = i;
                    ak2 = norm2;
                }
                ++i;
            }
            if (ak2 == 0.0) {
                this.rank = k;
                return;
            }
            int pk = this.permutation[nextColumn];
            this.permutation[nextColumn] = this.permutation[k];
            this.permutation[k] = pk;
            int kDiag = k * this.cols + pk;
            double akk = this.jacobian[kDiag];
            double alpha = akk > 0.0 ? -FastMath.sqrt(ak2) : FastMath.sqrt(ak2);
            this.beta[pk] = betak = 1.0 / (ak2 - akk * alpha);
            this.diagR[pk] = alpha;
            int n = kDiag;
            this.jacobian[n] = this.jacobian[n] - alpha;
            int dk = this.cols - 1 - k;
            while (dk > 0) {
                int dkp = this.permutation[k + dk] - pk;
                double gamma = 0.0;
                int index = kDiag;
                while (index < this.jacobian.length) {
                    gamma += this.jacobian[index] * this.jacobian[index + dkp];
                    index += this.cols;
                }
                gamma *= betak;
                index = kDiag;
                while (index < this.jacobian.length) {
                    int n2 = index + dkp;
                    this.jacobian[n2] = this.jacobian[n2] - gamma * this.jacobian[index];
                    index += this.cols;
                }
                --dk;
            }
            ++k;
        }
        this.rank = this.solvedCols;
    }

    private void qTy(double[] y) {
        int k = 0;
        while (k < this.cols) {
            int pk = this.permutation[k];
            int kDiag = k * this.cols + pk;
            double gamma = 0.0;
            int index = kDiag;
            int i = k;
            while (i < this.rows) {
                gamma += this.jacobian[index] * y[i];
                index += this.cols;
                ++i;
            }
            gamma *= this.beta[pk];
            index = kDiag;
            i = k;
            while (i < this.rows) {
                int n = i++;
                y[n] = y[n] - gamma * this.jacobian[index];
                index += this.cols;
            }
            ++k;
        }
    }
}

