/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import java.io.Serializable;
import org.apache.commons.math.Field;
import org.apache.commons.math.FieldElement;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.AbstractFieldMatrix;
import org.apache.commons.math.linear.FieldMatrix;
import org.apache.commons.math.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixVisitorException;

public class Array2DRowFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T>
implements Serializable {
    private static final long serialVersionUID = 7260756672015356458L;
    protected T[][] data;

    public Array2DRowFieldMatrix(Field<T> field) {
        super(field);
    }

    public Array2DRowFieldMatrix(Field<T> field, int rowDimension, int columnDimension) throws IllegalArgumentException {
        super(field, rowDimension, columnDimension);
        this.data = Array2DRowFieldMatrix.buildArray(field, (int)rowDimension, (int)columnDimension);
    }

    public Array2DRowFieldMatrix(T[][] d) throws IllegalArgumentException, NullPointerException {
        super(Array2DRowFieldMatrix.extractField(d));
        this.copyIn((FieldElement[][])d);
    }

    public Array2DRowFieldMatrix(T[][] d, boolean copyArray) throws IllegalArgumentException, NullPointerException {
        super(Array2DRowFieldMatrix.extractField(d));
        if (copyArray) {
            this.copyIn((FieldElement[][])d);
        } else {
            if (d == null) {
                throw new NullPointerException();
            }
            int nRows = d.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = d[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            int r = 1;
            while (r < nRows) {
                if (d[r].length != nCols) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, d[r].length);
                }
                ++r;
            }
            this.data = d;
        }
    }

    public Array2DRowFieldMatrix(T[] v) {
        super(Array2DRowFieldMatrix.extractField(v));
        int nRows = v.length;
        this.data = Array2DRowFieldMatrix.buildArray(this.getField(), (int)nRows, (int)1);
        int row = 0;
        while (row < nRows) {
            this.data[row][0] = v[row];
            ++row;
        }
    }

    @Override
    public FieldMatrix<T> createMatrix(int rowDimension, int columnDimension) throws IllegalArgumentException {
        return new Array2DRowFieldMatrix(this.getField(), rowDimension, columnDimension);
    }

    @Override
    public FieldMatrix<T> copy() {
        return new Array2DRowFieldMatrix(this.copyOut(), false);
    }

    @Override
    public FieldMatrix<T> add(FieldMatrix<T> m) throws IllegalArgumentException {
        try {
            return this.add((Array2DRowFieldMatrix)m);
        }
        catch (ClassCastException cce) {
            return super.add(m);
        }
    }

    @Override
    public Array2DRowFieldMatrix<T> add(Array2DRowFieldMatrix<T> m) throws IllegalArgumentException {
        this.checkAdditionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = Array2DRowFieldMatrix.buildArray(this.getField(), (int)rowCount, (int)columnCount);
        int row = 0;
        while (row < rowCount) {
            T[] dataRow = this.data[row];
            T[] mRow = m.data[row];
            FieldElement[] outDataRow = outData[row];
            int col = 0;
            while (col < columnCount) {
                outDataRow[col] = (FieldElement)dataRow[col].add(mRow[col]);
                ++col;
            }
            ++row;
        }
        return new Array2DRowFieldMatrix(outData, false);
    }

    @Override
    public FieldMatrix<T> subtract(FieldMatrix<T> m) throws IllegalArgumentException {
        try {
            return this.subtract((Array2DRowFieldMatrix)m);
        }
        catch (ClassCastException cce) {
            return super.subtract(m);
        }
    }

    @Override
    public Array2DRowFieldMatrix<T> subtract(Array2DRowFieldMatrix<T> m) throws IllegalArgumentException {
        this.checkSubtractionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = Array2DRowFieldMatrix.buildArray(this.getField(), (int)rowCount, (int)columnCount);
        int row = 0;
        while (row < rowCount) {
            T[] dataRow = this.data[row];
            T[] mRow = m.data[row];
            FieldElement[] outDataRow = outData[row];
            int col = 0;
            while (col < columnCount) {
                outDataRow[col] = (FieldElement)dataRow[col].subtract(mRow[col]);
                ++col;
            }
            ++row;
        }
        return new Array2DRowFieldMatrix(outData, false);
    }

    @Override
    public FieldMatrix<T> multiply(FieldMatrix<T> m) throws IllegalArgumentException {
        try {
            return this.multiply((Array2DRowFieldMatrix)m);
        }
        catch (ClassCastException cce) {
            return super.multiply(m);
        }
    }

    @Override
    public Array2DRowFieldMatrix<T> multiply(Array2DRowFieldMatrix<T> m) throws IllegalArgumentException {
        this.checkMultiplicationCompatible(m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        FieldElement[][] outData = Array2DRowFieldMatrix.buildArray(this.getField(), (int)nRows, (int)nCols);
        int row = 0;
        while (row < nRows) {
            T[] dataRow = this.data[row];
            FieldElement[] outDataRow = outData[row];
            int col = 0;
            while (col < nCols) {
                FieldElement sum = (FieldElement)this.getField().getZero();
                int i = 0;
                while (i < nSum) {
                    sum = sum.add((FieldElement)dataRow[i].multiply(m.data[i][col]));
                    ++i;
                }
                outDataRow[col] = sum;
                ++col;
            }
            ++row;
        }
        return new Array2DRowFieldMatrix(outData, false);
    }

    @Override
    public T[][] getData() {
        return this.copyOut();
    }

    public T[][] getDataRef() {
        return this.data;
    }

    @Override
    public void setSubMatrix(T[][] subMatrix, int row, int column) throws MatrixIndexException {
        if (this.data == null) {
            if (row > 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, row);
            }
            if (column > 0) {
                throw MathRuntimeException.createIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, column);
            }
            int nRows = subMatrix.length;
            if (nRows == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_ROW, new Object[0]);
            }
            int nCols = subMatrix[0].length;
            if (nCols == 0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.AT_LEAST_ONE_COLUMN, new Object[0]);
            }
            this.data = Array2DRowFieldMatrix.buildArray(this.getField(), (int)subMatrix.length, (int)nCols);
            int i = 0;
            while (i < this.data.length) {
                if (subMatrix[i].length != nCols) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIFFERENT_ROWS_LENGTHS, nCols, subMatrix[i].length);
                }
                System.arraycopy(subMatrix[i], 0, this.data[i + row], column, nCols);
                ++i;
            }
        } else {
            super.setSubMatrix(subMatrix, row, column);
        }
    }

    @Override
    public T getEntry(int row, int column) throws MatrixIndexException {
        try {
            return this.data[row][column];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public void setEntry(int row, int column, T value) throws MatrixIndexException {
        try {
            this.data[row][column] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public void addToEntry(int row, int column, T increment) throws MatrixIndexException {
        try {
            this.data[row][column] = (FieldElement)this.data[row][column].add(increment);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public void multiplyEntry(int row, int column, T factor) throws MatrixIndexException {
        try {
            this.data[row][column] = (FieldElement)this.data[row][column].multiply(factor);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixIndexException(LocalizedFormats.NO_SUCH_MATRIX_ENTRY, row, column, this.getRowDimension(), this.getColumnDimension());
        }
    }

    @Override
    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    @Override
    public T[] operate(T[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nCols);
        }
        FieldElement[] out = Array2DRowFieldMatrix.buildArray(this.getField(), (int)nRows);
        int row = 0;
        while (row < nRows) {
            T[] dataRow = this.data[row];
            FieldElement sum = (FieldElement)this.getField().getZero();
            int i = 0;
            while (i < nCols) {
                sum = sum.add((FieldElement)dataRow[i].multiply(v[i]));
                ++i;
            }
            out[row] = sum;
            ++row;
        }
        return out;
    }

    @Override
    public T[] preMultiply(T[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, v.length, nRows);
        }
        FieldElement[] out = Array2DRowFieldMatrix.buildArray(this.getField(), (int)nCols);
        int col = 0;
        while (col < nCols) {
            FieldElement sum = (FieldElement)this.getField().getZero();
            int i = 0;
            while (i < nRows) {
                sum = sum.add((FieldElement)this.data[i][col].multiply(v[i]));
                ++i;
            }
            out[col] = sum;
            ++col;
        }
        return out;
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int i = 0;
        while (i < rows) {
            T[] rowI = this.data[i];
            int j = 0;
            while (j < columns) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
                ++j;
            }
            ++i;
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int i = 0;
        while (i < rows) {
            T[] rowI = this.data[i];
            int j = 0;
            while (j < columns) {
                visitor.visit(i, j, rowI[j]);
                ++j;
            }
            ++i;
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int i = startRow;
        while (i <= endRow) {
            T[] rowI = this.data[i];
            int j = startColumn;
            while (j <= endColumn) {
                rowI[j] = visitor.visit(i, j, rowI[j]);
                ++j;
            }
            ++i;
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int i = startRow;
        while (i <= endRow) {
            T[] rowI = this.data[i];
            int j = startColumn;
            while (j <= endColumn) {
                visitor.visit(i, j, rowI[j]);
                ++j;
            }
            ++i;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int j = 0;
        while (j < columns) {
            int i = 0;
            while (i < rows) {
                T[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
                ++i;
            }
            ++j;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int j = 0;
        while (j < columns) {
            int i = 0;
            while (i < rows) {
                visitor.visit(i, j, this.data[i][j]);
                ++i;
            }
            ++j;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int j = startColumn;
        while (j <= endColumn) {
            int i = startRow;
            while (i <= endRow) {
                T[] rowI = this.data[i];
                rowI[j] = visitor.visit(i, j, rowI[j]);
                ++i;
            }
            ++j;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int j = startColumn;
        while (j <= endColumn) {
            int i = startRow;
            while (i <= endRow) {
                visitor.visit(i, j, this.data[i][j]);
                ++i;
            }
            ++j;
        }
        return visitor.end();
    }

    private T[][] copyOut() {
        int nRows = this.getRowDimension();
        FieldElement[][] out = Array2DRowFieldMatrix.buildArray(this.getField(), (int)nRows, (int)this.getColumnDimension());
        int i = 0;
        while (i < nRows) {
            System.arraycopy(this.data[i], 0, out[i], 0, this.data[i].length);
            ++i;
        }
        return out;
    }

    private void copyIn(T[][] in) {
        this.setSubMatrix((FieldElement[][])in, 0, 0);
    }
}

