/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.EigenDecomposition;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SingularMatrixException;
import org.apache.commons.math.linear.TriDiagonalTransformer;
import org.apache.commons.math.util.FastMath;

public class EigenDecompositionImpl
implements EigenDecomposition {
    private byte maxIter = (byte)30;
    private double[] main;
    private double[] secondary;
    private TriDiagonalTransformer transformer;
    private double[] realEigenvalues;
    private double[] imagEigenvalues;
    private ArrayRealVector[] eigenvectors;
    private RealMatrix cachedV;
    private RealMatrix cachedD;
    private RealMatrix cachedVt;

    public EigenDecompositionImpl(RealMatrix matrix, double splitTolerance) throws InvalidMatrixException {
        if (!this.isSymmetric(matrix)) {
            throw new InvalidMatrixException(LocalizedFormats.ASSYMETRIC_EIGEN_NOT_SUPPORTED, new Object[0]);
        }
        this.transformToTridiagonal(matrix);
        this.findEigenVectors(this.transformer.getQ().getData());
    }

    public EigenDecompositionImpl(double[] main, double[] secondary, double splitTolerance) throws InvalidMatrixException {
        this.main = (double[])main.clone();
        this.secondary = (double[])secondary.clone();
        this.transformer = null;
        int size = main.length;
        double[][] z = new double[size][size];
        int i = 0;
        while (i < size) {
            z[i][i] = 1.0;
            ++i;
        }
        this.findEigenVectors(z);
    }

    private boolean isSymmetric(RealMatrix matrix) {
        int rows = matrix.getRowDimension();
        int columns = matrix.getColumnDimension();
        double eps = (double)(10 * rows * columns) * (double)1.110223E-16f;
        int i = 0;
        while (i < rows) {
            int j = i + 1;
            while (j < columns) {
                double mji;
                double mij = matrix.getEntry(i, j);
                if (FastMath.abs(mij - (mji = matrix.getEntry(j, i))) > FastMath.max(FastMath.abs(mij), Math.abs(mji)) * eps) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public RealMatrix getV() throws InvalidMatrixException {
        if (this.cachedV == null) {
            int m = this.eigenvectors.length;
            this.cachedV = MatrixUtils.createRealMatrix(m, m);
            int k = 0;
            while (k < m) {
                this.cachedV.setColumnVector(k, this.eigenvectors[k]);
                ++k;
            }
        }
        return this.cachedV;
    }

    @Override
    public RealMatrix getD() throws InvalidMatrixException {
        if (this.cachedD == null) {
            this.cachedD = MatrixUtils.createRealDiagonalMatrix(this.realEigenvalues);
        }
        return this.cachedD;
    }

    @Override
    public RealMatrix getVT() throws InvalidMatrixException {
        if (this.cachedVt == null) {
            int m = this.eigenvectors.length;
            this.cachedVt = MatrixUtils.createRealMatrix(m, m);
            int k = 0;
            while (k < m) {
                this.cachedVt.setRowVector(k, this.eigenvectors[k]);
                ++k;
            }
        }
        return this.cachedVt;
    }

    @Override
    public double[] getRealEigenvalues() throws InvalidMatrixException {
        return (double[])this.realEigenvalues.clone();
    }

    @Override
    public double getRealEigenvalue(int i) throws InvalidMatrixException, ArrayIndexOutOfBoundsException {
        return this.realEigenvalues[i];
    }

    @Override
    public double[] getImagEigenvalues() throws InvalidMatrixException {
        return (double[])this.imagEigenvalues.clone();
    }

    @Override
    public double getImagEigenvalue(int i) throws InvalidMatrixException, ArrayIndexOutOfBoundsException {
        return this.imagEigenvalues[i];
    }

    @Override
    public RealVector getEigenvector(int i) throws InvalidMatrixException, ArrayIndexOutOfBoundsException {
        return this.eigenvectors[i].copy();
    }

    @Override
    public double getDeterminant() {
        double determinant = 1.0;
        double[] dArray = this.realEigenvalues;
        int n = this.realEigenvalues.length;
        int n2 = 0;
        while (n2 < n) {
            double lambda = dArray[n2];
            determinant *= lambda;
            ++n2;
        }
        return determinant;
    }

    @Override
    public DecompositionSolver getSolver() {
        return new Solver(this.realEigenvalues, this.imagEigenvalues, this.eigenvectors);
    }

    private void transformToTridiagonal(RealMatrix matrix) {
        this.transformer = new TriDiagonalTransformer(matrix);
        this.main = this.transformer.getMainDiagonalRef();
        this.secondary = this.transformer.getSecondaryDiagonalRef();
    }

    private void findEigenVectors(double[][] householderMatrix) {
        double[][] z = (double[][])householderMatrix.clone();
        int n = this.main.length;
        this.realEigenvalues = new double[n];
        this.imagEigenvalues = new double[n];
        double[] e = new double[n];
        int i = 0;
        while (i < n - 1) {
            this.realEigenvalues[i] = this.main[i];
            e[i] = this.secondary[i];
            ++i;
        }
        this.realEigenvalues[n - 1] = this.main[n - 1];
        e[n - 1] = 0.0;
        double maxAbsoluteValue = 0.0;
        int i2 = 0;
        while (i2 < n) {
            if (FastMath.abs(this.realEigenvalues[i2]) > maxAbsoluteValue) {
                maxAbsoluteValue = FastMath.abs(this.realEigenvalues[i2]);
            }
            if (FastMath.abs(e[i2]) > maxAbsoluteValue) {
                maxAbsoluteValue = FastMath.abs(e[i2]);
            }
            ++i2;
        }
        if (maxAbsoluteValue != 0.0) {
            i2 = 0;
            while (i2 < n) {
                if (FastMath.abs(this.realEigenvalues[i2]) <= (double)1.110223E-16f * maxAbsoluteValue) {
                    this.realEigenvalues[i2] = 0.0;
                }
                if (FastMath.abs(e[i2]) <= (double)1.110223E-16f * maxAbsoluteValue) {
                    e[i2] = 0.0;
                }
                ++i2;
            }
        }
        int j = 0;
        while (j < n) {
            int m;
            int its = 0;
            do {
                m = j;
                while (m < n - 1) {
                    double delta = FastMath.abs(this.realEigenvalues[m]) + FastMath.abs(this.realEigenvalues[m + 1]);
                    if (FastMath.abs(e[m]) + delta == delta) break;
                    ++m;
                }
                if (m == j) continue;
                if (its == this.maxIter) {
                    throw new InvalidMatrixException(new MaxIterationsExceededException(this.maxIter));
                }
                ++its;
                double q = (this.realEigenvalues[j + 1] - this.realEigenvalues[j]) / (2.0 * e[j]);
                double t = FastMath.sqrt(1.0 + q * q);
                q = q < 0.0 ? this.realEigenvalues[m] - this.realEigenvalues[j] + e[j] / (q - t) : this.realEigenvalues[m] - this.realEigenvalues[j] + e[j] / (q + t);
                double u = 0.0;
                double s = 1.0;
                double c = 1.0;
                int i3 = m - 1;
                while (i3 >= j) {
                    double p = s * e[i3];
                    double h = c * e[i3];
                    if (FastMath.abs(p) >= FastMath.abs(q)) {
                        c = q / p;
                        t = FastMath.sqrt(c * c + 1.0);
                        e[i3 + 1] = p * t;
                        s = 1.0 / t;
                        c *= s;
                    } else {
                        s = p / q;
                        t = FastMath.sqrt(s * s + 1.0);
                        e[i3 + 1] = q * t;
                        c = 1.0 / t;
                        s *= c;
                    }
                    if (e[i3 + 1] == 0.0) {
                        int n2 = i3 + 1;
                        this.realEigenvalues[n2] = this.realEigenvalues[n2] - u;
                        e[m] = 0.0;
                        break;
                    }
                    q = this.realEigenvalues[i3 + 1] - u;
                    t = (this.realEigenvalues[i3] - q) * s + 2.0 * c * h;
                    u = s * t;
                    this.realEigenvalues[i3 + 1] = q + u;
                    q = c * t - h;
                    int ia = 0;
                    while (ia < n) {
                        p = z[ia][i3 + 1];
                        z[ia][i3 + 1] = s * z[ia][i3] + c * p;
                        z[ia][i3] = c * z[ia][i3] - s * p;
                        ++ia;
                    }
                    --i3;
                }
                if (t == 0.0 && i3 >= j) continue;
                int n3 = j;
                this.realEigenvalues[n3] = this.realEigenvalues[n3] - u;
                e[j] = q;
                e[m] = 0.0;
            } while (m != j);
            ++j;
        }
        i2 = 0;
        while (i2 < n) {
            int k = i2;
            double p = this.realEigenvalues[i2];
            int j2 = i2 + 1;
            while (j2 < n) {
                if (this.realEigenvalues[j2] > p) {
                    k = j2;
                    p = this.realEigenvalues[j2];
                }
                ++j2;
            }
            if (k != i2) {
                this.realEigenvalues[k] = this.realEigenvalues[i2];
                this.realEigenvalues[i2] = p;
                j2 = 0;
                while (j2 < n) {
                    p = z[j2][i2];
                    z[j2][i2] = z[j2][k];
                    z[j2][k] = p;
                    ++j2;
                }
            }
            ++i2;
        }
        maxAbsoluteValue = 0.0;
        i2 = 0;
        while (i2 < n) {
            if (FastMath.abs(this.realEigenvalues[i2]) > maxAbsoluteValue) {
                maxAbsoluteValue = FastMath.abs(this.realEigenvalues[i2]);
            }
            ++i2;
        }
        if (maxAbsoluteValue != 0.0) {
            i2 = 0;
            while (i2 < n) {
                if (FastMath.abs(this.realEigenvalues[i2]) < (double)1.110223E-16f * maxAbsoluteValue) {
                    this.realEigenvalues[i2] = 0.0;
                }
                ++i2;
            }
        }
        this.eigenvectors = new ArrayRealVector[n];
        double[] tmp = new double[n];
        int i4 = 0;
        while (i4 < n) {
            int j3 = 0;
            while (j3 < n) {
                tmp[j3] = z[j3][i4];
                ++j3;
            }
            this.eigenvectors[i4] = new ArrayRealVector(tmp);
            ++i4;
        }
    }

    private static class Solver
    implements DecompositionSolver {
        private double[] realEigenvalues;
        private double[] imagEigenvalues;
        private final ArrayRealVector[] eigenvectors;

        private Solver(double[] realEigenvalues, double[] imagEigenvalues, ArrayRealVector[] eigenvectors) {
            this.realEigenvalues = realEigenvalues;
            this.imagEigenvalues = imagEigenvalues;
            this.eigenvectors = eigenvectors;
        }

        @Override
        public double[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            if (b.length != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.length, m);
            }
            double[] bp = new double[m];
            int i = 0;
            while (i < m) {
                ArrayRealVector v = this.eigenvectors[i];
                double[] vData = v.getDataRef();
                double s = v.dotProduct(b) / this.realEigenvalues[i];
                int j = 0;
                while (j < m) {
                    int n = j;
                    bp[n] = bp[n] + s * vData[j];
                    ++j;
                }
                ++i;
            }
            return bp;
        }

        @Override
        public RealVector solve(RealVector b) throws IllegalArgumentException, InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            if (b.getDimension() != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.getDimension(), m);
            }
            double[] bp = new double[m];
            int i = 0;
            while (i < m) {
                ArrayRealVector v = this.eigenvectors[i];
                double[] vData = v.getDataRef();
                double s = v.dotProduct(b) / this.realEigenvalues[i];
                int j = 0;
                while (j < m) {
                    int n = j;
                    bp[n] = bp[n] + s * vData[j];
                    ++j;
                }
                ++i;
            }
            return new ArrayRealVector(bp, false);
        }

        @Override
        public RealMatrix solve(RealMatrix b) throws IllegalArgumentException, InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            if (b.getRowDimension() != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b.getRowDimension(), b.getColumnDimension(), m, "n");
            }
            int nColB = b.getColumnDimension();
            double[][] bp = new double[m][nColB];
            int k = 0;
            while (k < nColB) {
                int i = 0;
                while (i < m) {
                    ArrayRealVector v = this.eigenvectors[i];
                    double[] vData = v.getDataRef();
                    double s = 0.0;
                    int j = 0;
                    while (j < m) {
                        s += v.getEntry(j) * b.getEntry(j, k);
                        ++j;
                    }
                    s /= this.realEigenvalues[i];
                    j = 0;
                    while (j < m) {
                        double[] dArray = bp[j];
                        int n = k;
                        dArray[n] = dArray[n] + s * vData[j];
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
            return MatrixUtils.createRealMatrix(bp);
        }

        @Override
        public boolean isNonSingular() {
            int i = 0;
            while (i < this.realEigenvalues.length) {
                if (this.realEigenvalues[i] == 0.0 && this.imagEigenvalues[i] == 0.0) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public RealMatrix getInverse() throws InvalidMatrixException {
            if (!this.isNonSingular()) {
                throw new SingularMatrixException();
            }
            int m = this.realEigenvalues.length;
            double[][] invData = new double[m][m];
            int i = 0;
            while (i < m) {
                double[] invI = invData[i];
                int j = 0;
                while (j < m) {
                    double invIJ = 0.0;
                    int k = 0;
                    while (k < m) {
                        double[] vK = this.eigenvectors[k].getDataRef();
                        invIJ += vK[i] * vK[j] / this.realEigenvalues[k];
                        ++k;
                    }
                    invI[j] = invIJ;
                    ++j;
                }
                ++i;
            }
            return MatrixUtils.createRealMatrix(invData);
        }
    }
}

