/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.events;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.BrentSolver;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.events.EventException;
import org.apache.commons.math.ode.events.EventHandler;
import org.apache.commons.math.ode.sampling.StepInterpolator;
import org.apache.commons.math.util.FastMath;

public class EventState {
    private final EventHandler handler;
    private final double maxCheckInterval;
    private final double convergence;
    private final int maxIterationCount;
    private double t0;
    private double g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private double pendingEventTime;
    private double previousEventTime;
    private boolean forward;
    private boolean increasing;
    private int nextAction;

    public EventState(EventHandler handler, double maxCheckInterval, double convergence, int maxIterationCount) {
        this.handler = handler;
        this.maxCheckInterval = maxCheckInterval;
        this.convergence = FastMath.abs(convergence);
        this.maxIterationCount = maxIterationCount;
        this.t0 = Double.NaN;
        this.g0 = Double.NaN;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        this.previousEventTime = Double.NaN;
        this.increasing = true;
        this.nextAction = 3;
    }

    public EventHandler getEventHandler() {
        return this.handler;
    }

    public double getMaxCheckInterval() {
        return this.maxCheckInterval;
    }

    public double getConvergence() {
        return this.convergence;
    }

    public int getMaxIterationCount() {
        return this.maxIterationCount;
    }

    public void reinitializeBegin(double tStart, double[] yStart) throws EventException {
        this.t0 = tStart;
        this.g0 = this.handler.g(tStart, yStart);
        this.g0Positive = this.g0 >= 0.0;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean evaluateStep(final StepInterpolator interpolator) throws DerivativeException, EventException, ConvergenceException {
        try {
            this.forward = interpolator.isForward();
            double t1 = interpolator.getCurrentTime();
            int n = FastMath.max(1, (int)FastMath.ceil(FastMath.abs(t1 - this.t0) / this.maxCheckInterval));
            double h = (t1 - this.t0) / (double)n;
            double ta = this.t0;
            double ga = this.g0;
            double tb = this.t0 + (interpolator.isForward() ? this.convergence : -this.convergence);
            int i = 0;
            while (i < n) {
                interpolator.setInterpolatedTime(tb += h);
                double gb = this.handler.g(tb, interpolator.getInterpolatedState());
                if (this.g0Positive ^ gb >= 0.0) {
                    double root;
                    if (ga * gb > 0.0) {
                        double epsilon = (this.forward ? 0.25 : -0.25) * this.convergence;
                        int k = 0;
                        while (k < 4 && ga * gb > 0.0) {
                            interpolator.setInterpolatedTime(ta += epsilon);
                            ga = this.handler.g(ta, interpolator.getInterpolatedState());
                            ++k;
                        }
                        if (ga * gb > 0.0) {
                            throw MathRuntimeException.createInternalError(null);
                        }
                    }
                    this.increasing = gb >= ga;
                    UnivariateRealFunction f = new UnivariateRealFunction(){

                        @Override
                        public double value(double t) throws FunctionEvaluationException {
                            try {
                                interpolator.setInterpolatedTime(t);
                                return EventState.this.handler.g(t, interpolator.getInterpolatedState());
                            }
                            catch (DerivativeException e) {
                                throw new FunctionEvaluationException((Throwable)e, t);
                            }
                            catch (EventException e) {
                                throw new FunctionEvaluationException((Throwable)e, t);
                            }
                        }
                    };
                    BrentSolver solver = new BrentSolver();
                    solver.setAbsoluteAccuracy(this.convergence);
                    solver.setMaximalIterationCount(this.maxIterationCount);
                    double d = root = ta <= tb ? solver.solve(f, ta, tb) : solver.solve(f, tb, ta);
                    if (FastMath.abs(root - ta) <= this.convergence && FastMath.abs(root - this.previousEventTime) <= this.convergence) {
                        ta = tb;
                        ga = gb;
                    } else if (Double.isNaN(this.previousEventTime) || FastMath.abs(this.previousEventTime - root) > this.convergence) {
                        this.pendingEventTime = root;
                        if (this.pendingEvent && FastMath.abs(t1 - this.pendingEventTime) <= this.convergence) {
                            return false;
                        }
                        this.pendingEvent = true;
                        return true;
                    }
                } else {
                    ta = tb;
                    ga = gb;
                }
                ++i;
            }
            this.pendingEvent = false;
            this.pendingEventTime = Double.NaN;
            return false;
        }
        catch (FunctionEvaluationException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof DerivativeException) {
                throw (DerivativeException)cause;
            }
            if (cause != null && cause instanceof EventException) {
                throw (EventException)cause;
            }
            throw new EventException(e);
        }
    }

    public double getEventTime() {
        return this.pendingEventTime;
    }

    public void stepAccepted(double t, double[] y) throws EventException {
        this.t0 = t;
        this.g0 = this.handler.g(t, y);
        if (this.pendingEvent) {
            this.previousEventTime = t;
            this.g0Positive = this.increasing;
            this.nextAction = this.handler.eventOccurred(t, y, !(this.increasing ^ this.forward));
        } else {
            this.g0Positive = this.g0 >= 0.0;
            this.nextAction = 3;
        }
    }

    public boolean stop() {
        return this.nextAction == 0;
    }

    public boolean reset(double t, double[] y) throws EventException {
        if (!this.pendingEvent) {
            return false;
        }
        if (this.nextAction == 1) {
            this.handler.resetState(t, y);
        }
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        return this.nextAction == 1 || this.nextAction == 2;
    }
}

