/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.nonstiff;

import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math.ode.sampling.StepInterpolator;

class EulerStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = -7179861704951334960L;

    public EulerStepInterpolator() {
    }

    public EulerStepInterpolator(EulerStepInterpolator interpolator) {
        super(interpolator);
    }

    @Override
    protected StepInterpolator doCopy() {
        return new EulerStepInterpolator(this);
    }

    @Override
    protected void computeInterpolatedStateAndDerivatives(double theta, double oneMinusThetaH) throws DerivativeException {
        int i = 0;
        while (i < this.interpolatedState.length) {
            this.interpolatedState[i] = this.currentState[i] - oneMinusThetaH * this.yDotK[0][i];
            ++i;
        }
        System.arraycopy(this.yDotK[0], 0, this.interpolatedDerivatives, 0, this.interpolatedDerivatives.length);
    }
}

