/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.nonstiff;

import org.apache.commons.math.ode.AbstractIntegrator;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math.ode.IntegratorException;
import org.apache.commons.math.ode.events.CombinedEventsManager;
import org.apache.commons.math.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math.ode.sampling.AbstractStepInterpolator;
import org.apache.commons.math.ode.sampling.DummyStepInterpolator;
import org.apache.commons.math.ode.sampling.StepHandler;
import org.apache.commons.math.util.FastMath;

public abstract class RungeKuttaIntegrator
extends AbstractIntegrator {
    private final double[] c;
    private final double[][] a;
    private final double[] b;
    private final RungeKuttaStepInterpolator prototype;
    private final double step;

    protected RungeKuttaIntegrator(String name, double[] c, double[][] a, double[] b, RungeKuttaStepInterpolator prototype, double step) {
        super(name);
        this.c = c;
        this.a = a;
        this.b = b;
        this.prototype = prototype;
        this.step = FastMath.abs(step);
    }

    @Override
    public double integrate(FirstOrderDifferentialEquations equations, double t0, double[] y0, double t, double[] y) throws DerivativeException, IntegratorException {
        AbstractStepInterpolator interpolator;
        this.sanityChecks(equations, t0, y0, t, y);
        this.setEquations(equations);
        this.resetEvaluations();
        boolean forward = t > t0;
        int stages = this.c.length + 1;
        if (y != y0) {
            System.arraycopy(y0, 0, y, 0, y0.length);
        }
        double[][] yDotK = new double[stages][];
        int i = 0;
        while (i < stages) {
            yDotK[i] = new double[y0.length];
            ++i;
        }
        double[] yTmp = new double[y0.length];
        if (this.requiresDenseOutput() || !this.eventsHandlersManager.isEmpty()) {
            RungeKuttaStepInterpolator rki = (RungeKuttaStepInterpolator)this.prototype.copy();
            rki.reinitialize(this, yTmp, yDotK, forward);
            interpolator = rki;
        } else {
            interpolator = new DummyStepInterpolator(yTmp, yDotK[stages - 1], forward);
        }
        interpolator.storeTime(t0);
        this.stepStart = t0;
        this.stepSize = forward ? this.step : -this.step;
        for (StepHandler handler : this.stepHandlers) {
            handler.reset();
        }
        CombinedEventsManager manager = this.addEndTimeChecker(t0, t, this.eventsHandlersManager);
        boolean lastStep = false;
        while (!lastStep) {
            interpolator.shift();
            boolean loop = true;
            while (loop) {
                this.computeDerivatives(this.stepStart, y, yDotK[0]);
                int k = 1;
                while (k < stages) {
                    int j = 0;
                    while (j < y0.length) {
                        double sum = this.a[k - 1][0] * yDotK[0][j];
                        int l = 1;
                        while (l < k) {
                            sum += this.a[k - 1][l] * yDotK[l][j];
                            ++l;
                        }
                        yTmp[j] = y[j] + this.stepSize * sum;
                        ++j;
                    }
                    this.computeDerivatives(this.stepStart + this.c[k - 1] * this.stepSize, yTmp, yDotK[k]);
                    ++k;
                }
                int j = 0;
                while (j < y0.length) {
                    double sum = this.b[0] * yDotK[0][j];
                    int l = 1;
                    while (l < stages) {
                        sum += this.b[l] * yDotK[l][j];
                        ++l;
                    }
                    yTmp[j] = y[j] + this.stepSize * sum;
                    ++j;
                }
                interpolator.storeTime(this.stepStart + this.stepSize);
                if (manager.evaluateStep(interpolator)) {
                    double dt = manager.getEventTime() - this.stepStart;
                    if (FastMath.abs(dt) <= FastMath.ulp(this.stepStart)) {
                        interpolator.storeTime(this.stepStart);
                        System.arraycopy(y, 0, yTmp, 0, y0.length);
                        this.stepSize = 0.0;
                        loop = false;
                        continue;
                    }
                    this.stepSize = dt;
                    continue;
                }
                loop = false;
            }
            double nextStep = this.stepStart + this.stepSize;
            System.arraycopy(yTmp, 0, y, 0, y0.length);
            manager.stepAccepted(nextStep, y);
            lastStep = manager.stop();
            interpolator.storeTime(nextStep);
            for (StepHandler handler : this.stepHandlers) {
                handler.handleStep(interpolator, lastStep);
            }
            this.stepStart = nextStep;
            if (manager.reset(this.stepStart, y) && !lastStep) {
                this.computeDerivatives(this.stepStart, y, yDotK[0]);
            }
            double d = this.stepSize = forward ? this.step : -this.step;
        }
        double stopTime = this.stepStart;
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
        return stopTime;
    }
}

