/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.apache.commons.math.exception.ConvergenceException;
import org.apache.commons.math.exception.MathIllegalStateException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.optimization.BaseMultivariateRealOptimizer;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.random.RandomVectorGenerator;

public class BaseMultiStartMultivariateRealOptimizer<FUNC extends MultivariateRealFunction>
implements BaseMultivariateRealOptimizer<FUNC> {
    private final BaseMultivariateRealOptimizer<FUNC> optimizer;
    private int maxEvaluations;
    private int totalEvaluations;
    private int starts;
    private RandomVectorGenerator generator;
    private RealPointValuePair[] optima;

    protected BaseMultiStartMultivariateRealOptimizer(BaseMultivariateRealOptimizer<FUNC> optimizer, int starts, RandomVectorGenerator generator) {
        this.optimizer = optimizer;
        this.starts = starts;
        this.generator = generator;
    }

    public RealPointValuePair[] getOptima() {
        if (this.optima == null) {
            throw new MathIllegalStateException((Localizable)LocalizedFormats.NO_OPTIMUM_COMPUTED_YET, new Object[0]);
        }
        return (RealPointValuePair[])this.optima.clone();
    }

    @Override
    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    @Override
    public int getEvaluations() {
        return this.totalEvaluations;
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
        this.optimizer.setMaxEvaluations(maxEvaluations);
    }

    @Override
    public void setConvergenceChecker(ConvergenceChecker<RealPointValuePair> checker) {
        this.optimizer.setConvergenceChecker(checker);
    }

    @Override
    public ConvergenceChecker<RealPointValuePair> getConvergenceChecker() {
        return this.optimizer.getConvergenceChecker();
    }

    @Override
    public RealPointValuePair optimize(FUNC f, GoalType goal, double[] startPoint) throws FunctionEvaluationException {
        this.optima = new RealPointValuePair[this.starts];
        int i = 0;
        while (i < this.starts) {
            try {
                this.optima[i] = this.optimizer.optimize(f, goal, i == 0 ? startPoint : this.generator.nextVector());
            }
            catch (FunctionEvaluationException fee) {
                this.optima[i] = null;
            }
            catch (ConvergenceException oe) {
                this.optima[i] = null;
            }
            int usedEvaluations = this.optimizer.getEvaluations();
            this.optimizer.setMaxEvaluations(this.optimizer.getMaxEvaluations() - usedEvaluations);
            this.totalEvaluations += usedEvaluations;
            ++i;
        }
        this.sortPairs(goal);
        if (this.optima[0] == null) {
            throw new ConvergenceException((Localizable)LocalizedFormats.NO_CONVERGENCE_WITH_ANY_START_POINT, this.starts);
        }
        return this.optima[0];
    }

    private void sortPairs(final GoalType goal) {
        Arrays.sort(this.optima, new Comparator<RealPointValuePair>(){

            @Override
            public int compare(RealPointValuePair o1, RealPointValuePair o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : 1;
                }
                if (o2 == null) {
                    return -1;
                }
                double v1 = o1.getValue();
                double v2 = o2.getValue();
                return goal == GoalType.MINIMIZE ? Double.compare(v1, v2) : Double.compare(v2, v1);
            }
        });
    }
}

