/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.MultivariateVectorialFunction;
import org.apache.commons.math.exception.ConvergenceException;
import org.apache.commons.math.exception.MathIllegalStateException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.optimization.BaseMultivariateVectorialOptimizer;
import org.apache.commons.math.optimization.ConvergenceChecker;
import org.apache.commons.math.optimization.VectorialPointValuePair;
import org.apache.commons.math.random.RandomVectorGenerator;

public class BaseMultiStartMultivariateVectorialOptimizer<FUNC extends MultivariateVectorialFunction>
implements BaseMultivariateVectorialOptimizer<FUNC> {
    private final BaseMultivariateVectorialOptimizer<FUNC> optimizer;
    private int maxEvaluations;
    private int totalEvaluations;
    private int starts;
    private RandomVectorGenerator generator;
    private VectorialPointValuePair[] optima;

    protected BaseMultiStartMultivariateVectorialOptimizer(BaseMultivariateVectorialOptimizer<FUNC> optimizer, int starts, RandomVectorGenerator generator) {
        this.optimizer = optimizer;
        this.starts = starts;
        this.generator = generator;
    }

    public VectorialPointValuePair[] getOptima() {
        if (this.optima == null) {
            throw new MathIllegalStateException((Localizable)LocalizedFormats.NO_OPTIMUM_COMPUTED_YET, new Object[0]);
        }
        return (VectorialPointValuePair[])this.optima.clone();
    }

    @Override
    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    @Override
    public int getEvaluations() {
        return this.totalEvaluations;
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
        this.optimizer.setMaxEvaluations(maxEvaluations);
    }

    @Override
    public void setConvergenceChecker(ConvergenceChecker<VectorialPointValuePair> checker) {
        this.optimizer.setConvergenceChecker(checker);
    }

    @Override
    public ConvergenceChecker<VectorialPointValuePair> getConvergenceChecker() {
        return this.optimizer.getConvergenceChecker();
    }

    @Override
    public VectorialPointValuePair optimize(FUNC f, double[] target, double[] weights, double[] startPoint) throws FunctionEvaluationException {
        this.optima = new VectorialPointValuePair[this.starts];
        int i = 0;
        while (i < this.starts) {
            try {
                this.optima[i] = this.optimizer.optimize(f, target, weights, i == 0 ? startPoint : this.generator.nextVector());
            }
            catch (FunctionEvaluationException fee) {
                this.optima[i] = null;
            }
            catch (ConvergenceException oe) {
                this.optima[i] = null;
            }
            int usedEvaluations = this.optimizer.getEvaluations();
            this.optimizer.setMaxEvaluations(this.optimizer.getMaxEvaluations() - usedEvaluations);
            this.totalEvaluations += usedEvaluations;
            ++i;
        }
        this.sortPairs(target, weights);
        if (this.optima[0] == null) {
            throw new ConvergenceException((Localizable)LocalizedFormats.NO_CONVERGENCE_WITH_ANY_START_POINT, this.starts);
        }
        return this.optima[0];
    }

    private void sortPairs(final double[] target, final double[] weights) {
        Arrays.sort(this.optima, new Comparator<VectorialPointValuePair>(){

            @Override
            public int compare(VectorialPointValuePair o1, VectorialPointValuePair o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return Double.compare(this.weightedResidual(o1), this.weightedResidual(o2));
            }

            private double weightedResidual(VectorialPointValuePair pv) {
                double[] value = pv.getValueRef();
                double sum = 0.0;
                int i = 0;
                while (i < value.length) {
                    double ri = value[i] - target[i];
                    sum += weights[i] * ri * ri;
                    ++i;
                }
                return sum;
            }
        });
    }
}

